/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.Revision;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.DotConnector;
import net.sourceforge.schemaspy.view.DotConnectorFinder;
import net.sourceforge.schemaspy.view.DotNode;
import net.sourceforge.schemaspy.view.StyleSheet;
import net.sourceforge.schemaspy.view.WriteStats;

public class DotFormatter {
    private static DotFormatter instance = new DotFormatter();
    private final int fontSize = Config.getInstance().getFontSize();

    private DotFormatter() {
    }

    public static DotFormatter getInstance() {
        return instance;
    }

    public Set<ForeignKeyConstraint> writeRealRelationships(Table table, boolean bl, WriteStats writeStats, LineWriter lineWriter) throws IOException {
        return this.writeRelationships(table, bl, writeStats, false, lineWriter);
    }

    public void writeAllRelationships(Table table, boolean bl, WriteStats writeStats, LineWriter lineWriter) throws IOException {
        this.writeRelationships(table, bl, writeStats, true, lineWriter);
    }

    private Set<ForeignKeyConstraint> writeRelationships(Table table, boolean bl, WriteStats writeStats, boolean bl2, LineWriter lineWriter) throws IOException {
        Object object;
        Iterator<Object> iterator;
        HashSet<Table> hashSet = new HashSet<Table>();
        HashSet<ForeignKeyConstraint> hashSet2 = new HashSet<ForeignKeyConstraint>();
        DotConnectorFinder dotConnectorFinder = DotConnectorFinder.getInstance();
        String string = bl2 ? "impliedTwoDegreesRelationshipsDiagram" : (bl ? "twoDegreesRelationshipsDiagram" : "oneDegreeRelationshipsDiagram");
        this.writeHeader(string, true, lineWriter);
        Set<Table> set = this.getImmediateRelatives(table, true, bl2, hashSet2);
        TreeSet<DotConnector> treeSet = new TreeSet<DotConnector>(dotConnectorFinder.getRelatedConnectors(table, bl2));
        hashSet.add(table);
        TreeMap<Table, DotNode> treeMap = new TreeMap<Table, DotNode>();
        for (Table object42 : set) {
            if (!hashSet.add(object42)) continue;
            treeMap.put(object42, new DotNode(object42, "", new DotNode.DotNodeConfig(false, false)));
            treeSet.addAll(dotConnectorFinder.getRelatedConnectors(object42, table, true, bl2));
        }
        for (DotConnector dotConnector : treeSet) {
            if (!dotConnector.pointsTo(table)) continue;
            dotConnector.connectToParentDetails();
        }
        HashSet hashSet3 = new HashSet();
        TreeSet<DotConnector> treeSet2 = new TreeSet<DotConnector>();
        if (bl) {
            for (Table table2 : set) {
                iterator = this.getImmediateRelatives(table2, false, bl2, hashSet2);
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    object = (Table)iterator2.next();
                    if (!hashSet.add((Table)object)) continue;
                    treeSet2.addAll(dotConnectorFinder.getRelatedConnectors((Table)object, table2, false, bl2));
                    treeMap.put((Table)object, new DotNode((Table)object, false, ""));
                }
                hashSet3.addAll(iterator);
            }
        }
        ArrayList arrayList = new ArrayList(treeMap.keySet());
        Iterator iterator3 = arrayList.iterator();
        while (iterator3.hasNext()) {
            iterator = (Table)iterator3.next();
            iterator3.remove();
            Iterator iterator4 = arrayList.iterator();
            while (iterator4.hasNext()) {
                object = (Table)iterator4.next();
                for (DotConnector dotConnector : dotConnectorFinder.getRelatedConnectors((Table)((Object)iterator), (Table)object, false, bl2)) {
                    if (bl && (hashSet3.contains(iterator) || hashSet3.contains(object))) {
                        treeSet2.add(dotConnector);
                        continue;
                    }
                    treeSet.add(dotConnector);
                }
            }
        }
        this.markExcludedColumns(treeMap, writeStats.getExcludedColumns());
        for (DotConnector dotConnector : treeSet2) {
            if (hashSet3.contains(dotConnector.getParentTable()) && !set.contains(dotConnector.getParentTable())) {
                dotConnector.connectToParentTitle();
            }
            if (!hashSet3.contains(dotConnector.getChildTable()) || set.contains(dotConnector.getChildTable())) continue;
            dotConnector.connectToChildTitle();
        }
        treeMap.put(table, new DotNode(table, ""));
        treeSet.addAll(treeSet2);
        for (DotConnector dotConnector : treeSet) {
            if (dotConnector.isImplied()) {
                object = (DotNode)treeMap.get(dotConnector.getParentTable());
                if (object != null) {
                    ((DotNode)object).setShowImplied(true);
                }
                if ((object = (DotNode)treeMap.get(dotConnector.getChildTable())) != null) {
                    ((DotNode)object).setShowImplied(true);
                }
            }
            lineWriter.writeln(dotConnector.toString());
        }
        for (DotNode dotNode : treeMap.values()) {
            lineWriter.writeln(dotNode.toString());
            writeStats.wroteTable(dotNode.getTable());
        }
        lineWriter.writeln("}");
        return hashSet2;
    }

    private Set<Table> getImmediateRelatives(Table table, boolean bl, boolean bl2, Set<ForeignKeyConstraint> set) {
        HashSet<TableColumn> hashSet = new HashSet<TableColumn>();
        for (TableColumn object : table.getColumns()) {
            ForeignKeyConstraint foreignKeyConstraint;
            if (object.isAllExcluded() || !bl && object.isExcluded()) continue;
            for (TableColumn tableColumn : object.getChildren()) {
                if (tableColumn.isAllExcluded() || !bl && tableColumn.isExcluded()) continue;
                foreignKeyConstraint = object.getChildConstraint(tableColumn);
                if (bl2 || !foreignKeyConstraint.isImplied()) {
                    hashSet.add(tableColumn);
                    continue;
                }
                set.add(foreignKeyConstraint);
            }
            for (TableColumn tableColumn : object.getParents()) {
                if (tableColumn.isAllExcluded() || !bl && tableColumn.isExcluded()) continue;
                foreignKeyConstraint = object.getParentConstraint(tableColumn);
                if (bl2 || !foreignKeyConstraint.isImplied()) {
                    hashSet.add(tableColumn);
                    continue;
                }
                set.add(foreignKeyConstraint);
            }
        }
        HashSet hashSet2 = new HashSet();
        for (TableColumn tableColumn : hashSet) {
            hashSet2.add(tableColumn.getTable());
        }
        hashSet2.remove(table);
        return hashSet2;
    }

    private void writeHeader(String string, boolean bl, LineWriter lineWriter) throws IOException {
        lineWriter.writeln("// dot " + String.valueOf(Dot.getInstance().getVersion()) + " on " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        lineWriter.writeln("// SchemaSpy rev " + String.valueOf(new Revision()));
        lineWriter.writeln("digraph \"" + string + "\" {");
        lineWriter.writeln("  graph [");
        boolean bl2 = Config.getInstance().isRankDirBugEnabled();
        if (!bl2) {
            lineWriter.writeln("    rankdir=\"RL\"");
        }
        lineWriter.writeln("    bgcolor=\"" + StyleSheet.getInstance().getBodyBackground() + "\"");
        if (bl) {
            if (bl2) {
                lineWriter.writeln("    label=\"\\nLayout is significantly better without '-rankdirbug' option\"");
            } else {
                lineWriter.writeln("    label=\"\\nGenerated by SchemaSpy\"");
            }
            lineWriter.writeln("    labeljust=\"l\"");
        }
        lineWriter.writeln("    nodesep=\"0.18\"");
        lineWriter.writeln("    ranksep=\"0.46\"");
        lineWriter.writeln("    fontname=\"" + Config.getInstance().getFont() + "\"");
        lineWriter.writeln("    fontsize=\"" + this.fontSize + "\"");
        lineWriter.writeln("  ];");
        lineWriter.writeln("  node [");
        lineWriter.writeln("    fontname=\"" + Config.getInstance().getFont() + "\"");
        lineWriter.writeln("    fontsize=\"" + this.fontSize + "\"");
        lineWriter.writeln("    shape=\"plaintext\"");
        lineWriter.writeln("  ];");
        lineWriter.writeln("  edge [");
        lineWriter.writeln("    arrowsize=\"0.8\"");
        lineWriter.writeln("  ];");
    }

    public void writeRealRelationships(Database database, Collection<Table> collection, boolean bl, boolean bl2, WriteStats writeStats, LineWriter lineWriter) throws IOException {
        this.writeRelationships(database, collection, bl, bl2, false, writeStats, lineWriter);
    }

    public boolean writeAllRelationships(Database database, Collection<Table> collection, boolean bl, boolean bl2, WriteStats writeStats, LineWriter lineWriter) throws IOException {
        return this.writeRelationships(database, collection, bl, bl2, true, writeStats, lineWriter);
    }

    private boolean writeRelationships(Database database, Collection<Table> collection, boolean bl, boolean bl2, boolean bl3, WriteStats writeStats, LineWriter lineWriter) throws IOException {
        DotConnectorFinder dotConnectorFinder = DotConnectorFinder.getInstance();
        DotNode.DotNodeConfig dotNodeConfig = bl2 ? new DotNode.DotNodeConfig(!bl, false) : new DotNode.DotNodeConfig();
        boolean bl4 = false;
        String string = bl3 ? (bl ? "compactImpliedRelationshipsDiagram" : "largeImpliedRelationshipsDiagram") : (bl ? "compactRelationshipsDiagram" : "largeRelationshipsDiagram");
        this.writeHeader(string, true, lineWriter);
        TreeMap<Table, DotNode> treeMap = new TreeMap<Table, DotNode>();
        for (Table object2 : collection) {
            if (object2.isOrphan(bl3)) continue;
            treeMap.put(object2, new DotNode(object2, "tables/", dotNodeConfig));
        }
        for (Table table : database.getRemoteTables()) {
            treeMap.put(table, new DotNode(table, "tables/", dotNodeConfig));
        }
        TreeSet treeSet = new TreeSet();
        for (Object object : treeMap.values()) {
            treeSet.addAll(dotConnectorFinder.getRelatedConnectors(((DotNode)object).getTable(), bl3));
        }
        this.markExcludedColumns(treeMap, writeStats.getExcludedColumns());
        for (Object object : treeMap.values()) {
            Table table = ((DotNode)object).getTable();
            lineWriter.writeln(((DotNode)object).toString());
            writeStats.wroteTable(table);
            bl4 = bl4 || bl3 && table.isOrphan(false);
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (DotConnector)iterator.next();
            lineWriter.writeln(((DotConnector)object).toString());
        }
        lineWriter.writeln("}");
        return bl4;
    }

    private void markExcludedColumns(Map<Table, DotNode> map, Set<TableColumn> set) {
        for (TableColumn tableColumn : set) {
            DotNode dotNode = map.get(tableColumn.getTable());
            if (dotNode == null) continue;
            dotNode.excludeColumn(tableColumn);
        }
    }

    public void writeOrphan(Table table, LineWriter lineWriter) throws IOException {
        this.writeHeader(table.getName(), false, lineWriter);
        lineWriter.writeln(new DotNode(table, true, "tables/").toString());
        lineWriter.writeln("}");
    }
}

