/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.AccessController;
import org.owasp.esapi.Authenticator;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Encryptor;
import org.owasp.esapi.Executor;
import org.owasp.esapi.HTTPUtilities;
import org.owasp.esapi.IntrusionDetector;
import org.owasp.esapi.LogFactory;
import org.owasp.esapi.Logger;
import org.owasp.esapi.Randomizer;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.util.ObjFactory;

public final class ESAPI {
    private static String securityConfigurationImplName = System.getProperty("org.owasp.esapi.SecurityConfiguration", "org.owasp.esapi.reference.DefaultSecurityConfiguration");
    private static volatile SecurityConfiguration overrideConfig = null;

    private ESAPI() {
    }

    public static void clearCurrent() {
        ESAPI.authenticator().clearCurrent();
        ESAPI.httpUtilities().clearCurrent();
    }

    public static HttpServletRequest currentRequest() {
        return ESAPI.httpUtilities().getCurrentRequest();
    }

    public static HttpServletResponse currentResponse() {
        return ESAPI.httpUtilities().getCurrentResponse();
    }

    public static AccessController accessController() {
        return (AccessController)ObjFactory.make(ESAPI.securityConfiguration().getAccessControlImplementation(), "AccessController");
    }

    public static Authenticator authenticator() {
        return (Authenticator)ObjFactory.make(ESAPI.securityConfiguration().getAuthenticationImplementation(), "Authenticator");
    }

    public static Encoder encoder() {
        return (Encoder)ObjFactory.make(ESAPI.securityConfiguration().getEncoderImplementation(), "Encoder");
    }

    public static Encryptor encryptor() {
        return (Encryptor)ObjFactory.make(ESAPI.securityConfiguration().getEncryptionImplementation(), "Encryptor");
    }

    public static Executor executor() {
        return (Executor)ObjFactory.make(ESAPI.securityConfiguration().getExecutorImplementation(), "Executor");
    }

    public static HTTPUtilities httpUtilities() {
        return (HTTPUtilities)ObjFactory.make(ESAPI.securityConfiguration().getHTTPUtilitiesImplementation(), "HTTPUtilities");
    }

    public static IntrusionDetector intrusionDetector() {
        return (IntrusionDetector)ObjFactory.make(ESAPI.securityConfiguration().getIntrusionDetectionImplementation(), "IntrusionDetector");
    }

    private static LogFactory logFactory() {
        return (LogFactory)ObjFactory.make(ESAPI.securityConfiguration().getLogImplementation(), "LogFactory");
    }

    public static Logger getLogger(Class clazz) {
        return ESAPI.logFactory().getLogger(clazz);
    }

    public static Logger getLogger(String moduleName) {
        return ESAPI.logFactory().getLogger(moduleName);
    }

    public static Logger log() {
        return ESAPI.logFactory().getLogger("DefaultLogger");
    }

    public static Randomizer randomizer() {
        return (Randomizer)ObjFactory.make(ESAPI.securityConfiguration().getRandomizerImplementation(), "Randomizer");
    }

    public static SecurityConfiguration securityConfiguration() {
        SecurityConfiguration override = overrideConfig;
        if (override != null) {
            return override;
        }
        return (SecurityConfiguration)ObjFactory.make(securityConfigurationImplName, "SecurityConfiguration");
    }

    public static Validator validator() {
        return (Validator)ObjFactory.make(ESAPI.securityConfiguration().getValidationImplementation(), "Validator");
    }

    public static String initialize(String impl) {
        String oldImpl = securityConfigurationImplName;
        securityConfigurationImplName = impl;
        return oldImpl;
    }

    public static void override(SecurityConfiguration config) {
        overrideConfig = config;
    }

    public static boolean isMethodExplicityEnabled(String fullyQualifiedMethodName) {
        if (fullyQualifiedMethodName == null || fullyQualifiedMethodName.trim().isEmpty()) {
            throw new IllegalArgumentException("Program error: fullyQualifiedMethodName parameter cannot be null or empty");
        }
        String desiredMethodName = fullyQualifiedMethodName.trim();
        if (!desiredMethodName.matches("^org\\.owasp\\.esapi\\.(\\p{Alnum}|\\.)*$")) {
            throw new IllegalArgumentException("Program error: fullyQualifiedMethodName must start with 'org.owasp.esapi.' and be a valid method name.");
        }
        String enabledMethods = null;
        try {
            enabledMethods = ESAPI.securityConfiguration().getStringProp("ESAPI.dangerouslyAllowUnsafeMethods.methodNames");
        }
        catch (ConfigurationException cex) {
            return false;
        }
        String result = Arrays.stream(enabledMethods.trim().split(",")).filter(methodName -> methodName.trim().equals(desiredMethodName)).findFirst().orElse("");
        return !result.isEmpty();
    }
}

