/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.sponsor.hierarchy.SponsorHierarchy;
import org.kuali.coeus.common.impl.sponsor.SponsorHierarchyMaintenanceService;
import org.kuali.coeus.common.impl.sponsor.hierarchy.SponsorHierarchyForm;
import org.kuali.coeus.common.impl.sponsor.hierarchy.SponsorHierarchyRule;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class SponsorHierarchyAction
extends KualiAction
implements BackLocationAction {
    private static final String MAINT = "maint";
    private static final String NEW = "new";
    private static final String LOOKUP = "lookup";
    private static final String HIERARCHY_NAME = "hierarchyName";
    private static final String SELECTED_HIERARCHY_NAME = "selectedHierarchyName";
    private UnitAuthorizationService unitAuthorizationService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Modify Sponsor Hierarchy")) {
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            ActionForward forward = super.execute(mapping, form, request, response);
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("mapKey"))) {
                sponsorHierarchyForm.getNewSponsors().get(0).clear();
            }
            sponsorHierarchyForm.setTopSponsorHierarchies(KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).getTopSponsorHierarchy());
            sponsorHierarchyForm.setHierarchyNameList(KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).getTopSponsorHierarchyList());
            return forward;
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Open Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Add Sponsor Hierarchy")) {
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            sponsorHierarchyForm.setHierarchyName(sponsorHierarchyForm.getSelectedSponsorHierarchy());
            return mapping.findForward("copy");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Copy Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward deleteSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Delete Sponsor Hierarchy")) {
            KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).deleteSponsorHierarchy((SponsorHierarchyForm)form);
            ((SponsorHierarchyForm)form).setHierarchyNameList(KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).getTopSponsorHierarchyList());
            ((SponsorHierarchyForm)form).setMessage("Sponsor Hierarchy was deleted successfully");
            return mapping.findForward("basic");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Delete Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward copySponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Add Sponsor Hierarchy")) {
            boolean rulePassed = new SponsorHierarchyRule().newHierarchyNameRequired((SponsorHierarchyForm)form);
            if (rulePassed) {
                KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).copySponsorHierarchy((SponsorHierarchyForm)form);
                ((SponsorHierarchyForm)form).setTopSponsorHierarchies(KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).getTopSponsorHierarchy());
                ((SponsorHierarchyForm)form).setMessage("Sponsor Hierarchy was copied successfully");
            }
            return mapping.findForward("basic");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Copy Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward cancelSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).clearCurrentActions();
        return this.returnToSender(request, mapping, (KualiForm)form);
    }

    public ActionForward cancelSponsorHierarchyMaint(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
        sponsorHierarchyForm.setSponsorCodeList("");
        sponsorHierarchyForm.setNewHierarchyName("");
        sponsorHierarchyForm.setSelectedSponsorHierarchy("");
        KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).clearCurrentActions();
        GlobalVariables.getUserSession().removeObject(SELECTED_HIERARCHY_NAME);
        GlobalVariables.getUserSession().removeObject(HIERARCHY_NAME);
        GlobalVariables.getUserSession().removeObject(sponsorHierarchyForm.getTimestamp());
        return mapping.findForward("basic");
    }

    public ActionForward saveSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Modify Sponsor Hierarchy")) {
            KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).executeActions();
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            sponsorHierarchyForm.setActionSelected(MAINT);
            sponsorHierarchyForm.setSponsorCodeList(KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).loadToSponsorHierachyMt(sponsorHierarchyForm.getSelectedSponsorHierarchy()));
            GlobalVariables.getUserSession().removeObject(SELECTED_HIERARCHY_NAME);
            GlobalVariables.getUserSession().removeObject(sponsorHierarchyForm.getTimestamp());
            GlobalVariables.getUserSession().removeObject("sponsorCodes");
            sponsorHierarchyForm.setTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp().toString());
            return mapping.findForward(MAINT);
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Save Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward newSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Add Sponsor Hierarchy")) {
            boolean rulePassed = new SponsorHierarchyRule().newHierarchyNameRequired((SponsorHierarchyForm)form);
            if (rulePassed) {
                ((SponsorHierarchyForm)form).setNewSponsorHierarchy(new SponsorHierarchy());
                SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
                sponsorHierarchyForm.setHierarchyName(sponsorHierarchyForm.getNewHierarchyName());
                sponsorHierarchyForm.setSponsorCodeList("");
                sponsorHierarchyForm.setTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp().toString());
                ((SponsorHierarchyForm)form).setActionSelected(NEW);
                KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).clearCurrentActions();
                GlobalVariables.getUserSession().addObject(SELECTED_HIERARCHY_NAME, (Object)sponsorHierarchyForm.getSelectedSponsorHierarchy());
                GlobalVariables.getUserSession().addObject(HIERARCHY_NAME, (Object)sponsorHierarchyForm.getHierarchyName());
                return mapping.findForward(MAINT);
            }
            return mapping.findForward("basic");
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Add Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward maintSponsorHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Modify Sponsor Hierarchy")) {
            ((SponsorHierarchyForm)form).setActionSelected(MAINT);
            SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
            sponsorHierarchyForm.setHierarchyName(sponsorHierarchyForm.getSelectedSponsorHierarchy());
            sponsorHierarchyForm.setSponsorCodeList(KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).loadToSponsorHierachyMt(sponsorHierarchyForm.getSelectedSponsorHierarchy()));
            GlobalVariables.getUserSession().removeObject(SELECTED_HIERARCHY_NAME);
            GlobalVariables.getUserSession().addObject(HIERARCHY_NAME, (Object)sponsorHierarchyForm.getHierarchyName());
            KcServiceLocator.getService(SponsorHierarchyMaintenanceService.class).clearCurrentActions();
            sponsorHierarchyForm.setTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp().toString());
            return mapping.findForward(MAINT);
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Modify Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward deleteSponsorHierarchyGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
        int selectedSponsorHierarchy = this.getLineToDelete(request);
        if (this.getUnitAuthorizationService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", "Delete Sponsor Hierarchy")) {
            sponsorHierarchyForm.getSponsorHierarchyList().remove(selectedSponsorHierarchy);
            sponsorHierarchyForm.getNewSponsors().remove(this.getLineToDelete(request));
            return mapping.findForward(NEW);
        }
        throw new AuthorizationException(GlobalVariables.getUserSession().getPrincipalId(), "Delete Sponsor Hierarchy", "sponsorhirearchy");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        SponsorHierarchyForm sponsorHierarchyForm = (SponsorHierarchyForm)form;
        Object sponsors = "";
        if (sponsorHierarchyForm.getLookupResultsBOClassName() != null && sponsorHierarchyForm.getLookupResultsSequenceNumber() != null) {
            String lookupResultsSequenceNumber = sponsorHierarchyForm.getLookupResultsSequenceNumber();
            Class<?> lookupResultsBOClass = Class.forName(sponsorHierarchyForm.getLookupResultsBOClassName());
            LookupResultsService lookupService = KcServiceLocator.getService(LookupResultsService.class);
            String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            Collection rawValues = lookupService.retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, principalId);
            int idx = 0;
            String idxString = StringUtils.substringBetween((String)sponsorHierarchyForm.getLookedUpCollectionName(), (String)"[", (String)"]");
            if (StringUtils.isNotBlank((CharSequence)idxString)) {
                idx = Integer.parseInt(idxString);
            }
            sponsorHierarchyForm.getNewSponsors().set(0, new ArrayList());
            sponsorHierarchyForm.setSelectedSponsors("");
            for (BusinessObject rawValue : rawValues) {
                Sponsor sponsor = (Sponsor)rawValue;
                sponsorHierarchyForm.getNewSponsors().get(idx).add(sponsor);
                if (StringUtils.isBlank((CharSequence)sponsors)) {
                    sponsors = sponsor.getSponsorCode() + ":" + sponsor.getSponsorName();
                    continue;
                }
                sponsors = (String)sponsors + ";1;" + sponsor.getSponsorCode() + ":" + sponsor.getSponsorName();
            }
            sponsorHierarchyForm.setLookupResultsSequenceNumber(null);
        }
        if (StringUtils.isNotBlank((CharSequence)sponsorHierarchyForm.getActionSelected()) && (sponsorHierarchyForm.getActionSelected().equals(MAINT) || sponsorHierarchyForm.getActionSelected().equals(NEW)) || StringUtils.isNotBlank((CharSequence)sponsors)) {
            sponsorHierarchyForm.setSelectedSponsors((String)sponsors);
            return mapping.findForward(LOOKUP);
        }
        return mapping.findForward(NEW);
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }
}

