/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.xcontent.XContentType;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryDao;
import org.kuali.coeus.elasticsearch.ElasticsearchAccessControlService;
import org.kuali.coeus.elasticsearch.ElasticsearchBatchContext;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.elasticsearch.GrantsSearchDocument;
import org.kuali.coeus.elasticsearch.serializers.ElasticsearchDocumentSerializer;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Configurable(autowire=Autowire.BY_TYPE)
@Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
public class ElasticsearchIndexServiceImpl
implements ElasticsearchIndexService {
    private static final Logger LOG = LogManager.getLogger(ElasticsearchIndexServiceImpl.class);
    private static final int INDEX_TIME_WARN_THRESHOLD = 5000;
    private static final int INDEX_PROGRESS_SIZE = 100;
    private static final int INDEX_BATCH_SIZE = 100;
    private static final QueryByCriteria PLACEHOLDER_DOC_CRITERIA = QueryByCriteria.Builder.forAttribute((String)"documentDescription", (Object)"*****PLACEHOLDER*****").build();
    @Autowired
    private List<ElasticsearchDocumentSerializer> serializers;
    @Autowired
    private DataObjectService dataObjectService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ElasticsearchAccessControlService elasticsearchAccessControlService;
    @Autowired
    @Qualifier(value="elasticsearchClient")
    private RestHighLevelClient elasticsearchClient;
    @Autowired
    @Qualifier(value="elasticsearchObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private PersonService personService;
    @Autowired
    private VersionHistoryDao versionHistoryDao;
    @Autowired
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="elasticsearchForkJoinPool")
    private ForkJoinPool indexThreadPool;
    private String indexName = "documents";
    private Boolean bulkChunkEnabled = false;
    private Integer bulkChunkSize = 100;
    private final Set<DocumentStatus> inactiveStatus = Set.of(DocumentStatus.INITIATED, DocumentStatus.DISAPPROVED, DocumentStatus.CANCELED);

    @Override
    public List<CompletableFuture<Boolean>> bulkIndex(List<String> documentIds) {
        if (this.bulkChunkEnabled.booleanValue()) {
            LOG.info("Bulk chunk indexing enabled");
            return this.chunkBulkIndex(documentIds);
        }
        this.filterInactiveDocumentIds(documentIds);
        int numDocs = documentIds.size();
        AtomicInteger progress = new AtomicInteger();
        AtomicInteger successfullyIndexed = new AtomicInteger();
        Stopwatch timer = Stopwatch.createStarted();
        UserSession userSession = GlobalVariables.getUserSession();
        ElasticsearchBatchContext batchContext = this.elasticsearchAccessControlService.createBatchContext();
        LOG.info(String.format("Bulk indexing %d documents using %d threads...", numDocs, this.indexThreadPool.getParallelism()));
        List<CompletableFuture<Boolean>> results = documentIds.stream().map(docId -> CompletableFuture.supplyAsync(() -> {
            GlobalVariables.setUserSession((UserSession)userSession);
            return this.retrieveDocument((String)docId).map(document -> {
                int numProcessed;
                LOG.info("Indexing document {} with last modified date {}", (Object)document.getDocumentNumber(), (Object)document.getDocumentHeader().getWorkflowDocument().getDateLastModified());
                boolean success = this.doIndex((Document)document, Collections.emptySet(), batchContext);
                if (success) {
                    successfullyIndexed.incrementAndGet();
                }
                if ((numProcessed = progress.incrementAndGet()) % 100 == 0) {
                    LOG.info(String.format("%d / %d documents processed for indexing", numProcessed, numDocs));
                }
                return success;
            }).orElse(false);
        }, this.indexThreadPool)).collect(Collectors.toList());
        CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).whenCompleteAsync((result, e) -> {
            timer.stop();
            LOG.info(String.format("Took %d seconds to index %d / %d documents", timer.elapsed(TimeUnit.SECONDS), successfullyIndexed.get(), progress.get()));
        });
        return results;
    }

    private List<CompletableFuture<Boolean>> chunkBulkIndex(List<String> documentIds) {
        this.filterInactiveDocumentIds(documentIds);
        int numDocs = documentIds.size();
        AtomicInteger progress = new AtomicInteger();
        AtomicInteger successfullyIndexed = new AtomicInteger();
        Stopwatch timer = Stopwatch.createStarted();
        UserSession userSession = GlobalVariables.getUserSession();
        ElasticsearchBatchContext batchContext = this.elasticsearchAccessControlService.createBatchContext();
        LOG.info("Bulk indexing {} documents with chunk size {} and using {} threads...", (Object)numDocs, (Object)this.bulkChunkSize, (Object)this.indexThreadPool.getParallelism());
        List<CompletableFuture<Boolean>> results = Lists.partition(documentIds, (int)this.bulkChunkSize).parallelStream().map(docIds -> CompletableFuture.supplyAsync(() -> {
            GlobalVariables.setUserSession((UserSession)userSession);
            return (Boolean)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.retrieveDocuments((List<String>)docIds).thenCompose(docs -> this.mapDocumentsToIndexes((List<Document>)docs, batchContext))).thenComposeAsync(this::doBulkIndex, (Executor)this.indexThreadPool)).thenApplyAsync(success -> {
                int numProcessed;
                if (success.booleanValue()) {
                    successfullyIndexed.addAndGet(docIds.size());
                }
                if ((numProcessed = progress.addAndGet(docIds.size())) % 100 == 0) {
                    LOG.info("{} / {} documents processed for indexing", (Object)numProcessed, (Object)numDocs);
                }
                return success;
            }, (Executor)this.indexThreadPool)).join();
        }, this.indexThreadPool)).toList();
        CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).whenCompleteAsync((result, e) -> {
            timer.stop();
            LOG.info("Took {} seconds to index {} / {} documents", (Object)timer.elapsed(TimeUnit.SECONDS), (Object)successfullyIndexed.get(), (Object)progress.get());
        });
        return results;
    }

    @Override
    public CompletableFuture<Void> newBulkIndex(List<String> documentIds) {
        this.filterInactiveDocumentIds(documentIds);
        int numDocs = documentIds.size();
        AtomicInteger progress = new AtomicInteger();
        AtomicInteger successfullyIndexed = new AtomicInteger();
        Stopwatch timer = Stopwatch.createStarted();
        UserSession userSession = GlobalVariables.getUserSession();
        ElasticsearchBatchContext batchContext = this.elasticsearchAccessControlService.createBatchContext();
        LOG.info(String.format("Bulk indexing %d documents using %d threads...", numDocs, this.indexThreadPool.getParallelism()));
        List<CompletableFuture> results = Lists.partition(documentIds, (int)100).stream().map(docIds -> CompletableFuture.supplyAsync(() -> {
            GlobalVariables.setUserSession((UserSession)userSession);
            int batchSize = docIds.size();
            return (Boolean)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.retrieveDocuments((List<String>)docIds).thenCompose(docs -> this.mapDocumentsToIndexes((List<Document>)docs, batchContext))).thenComposeAsync(this::doBulkIndex, (Executor)this.indexThreadPool)).thenApplyAsync(success -> {
                int numProcessed;
                if (success.booleanValue()) {
                    successfullyIndexed.addAndGet(batchSize);
                }
                if ((numProcessed = progress.addAndGet(batchSize)) % 100 == 0) {
                    LOG.info(String.format("%d / %d documents processed for indexing", numProcessed, numDocs));
                }
                return success;
            }, (Executor)this.indexThreadPool)).join();
        }, this.indexThreadPool)).toList();
        return CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).whenComplete((result, e) -> {
            timer.stop();
            LOG.info(String.format("Took %d seconds to index %d / %d documents", timer.elapsed(TimeUnit.SECONDS), successfullyIndexed.get(), progress.get()));
        });
    }

    protected void filterInactiveDocumentIds(List<String> documentIds) {
        Set<String> inactiveVersions = Set.of(VersionStatus.CANCELED.name(), VersionStatus.ARCHIVED.name());
        documentIds.removeAll(this.versionHistoryDao.getAwardDocumentNumbersByVersionStatus(inactiveVersions));
        documentIds.removeAll(this.versionHistoryDao.getIPDocumentNumbersByVersionStatus(inactiveVersions));
        documentIds.removeAll(this.versionHistoryDao.getSubAwardDocumentNumbersByVersionStatus(inactiveVersions));
        documentIds.removeAll(this.getAwardPlaceholderDocIds());
    }

    protected Set<String> getAwardPlaceholderDocIds() {
        return this.dataObjectService.findMatching(DocumentHeader.class, PLACEHOLDER_DOC_CRITERIA).getResults().stream().map(DocumentHeader::getDocumentNumber).collect(Collectors.toSet());
    }

    @Override
    public void indexPostCommit(final String documentId, final Set<String> documentsToDelete) {
        final UserSession userSession = this.globalVariableService.getUserSession();
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                ElasticsearchIndexServiceImpl.this.globalVariableService.doInNewGlobalVariables(userSession, () -> ElasticsearchIndexServiceImpl.this.index(documentId, (Set<String>)documentsToDelete));
            }
        });
    }

    @Override
    public Future<Boolean> index(String docId, Set<String> documentsToDelete) {
        UserSession userSession = this.globalVariableService.getUserSession();
        return this.indexThreadPool.submit(() -> this.globalVariableService.doInNewGlobalVariables(userSession, () -> this.retrieveDocument(docId).map(doc -> this.doIndex((Document)doc, documentsToDelete)).orElse(false)));
    }

    @Override
    public CompletableFuture<Boolean> indexCompletable(String docId, Set<String> documentsToDelete) {
        return CompletableFuture.supplyAsync(() -> this.retrieveDocument(docId).map(doc -> this.doIndex((Document)doc, documentsToDelete)).orElse(false), this.indexThreadPool);
    }

    @Override
    public Future<Boolean> index(Document document, Set<String> documentsToDelete) {
        return this.indexThreadPool.submit(() -> this.doIndex(document, documentsToDelete));
    }

    protected boolean doIndex(Document document, Set<String> documentsToDelete) {
        return this.doIndex(document, documentsToDelete, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doIndex(Document document, Set<String> documentsToDelete, ElasticsearchBatchContext batchContext) {
        Set<Object> otherDocumentsToDelete;
        Set<Object> set = otherDocumentsToDelete = documentsToDelete == null ? Collections.emptySet() : documentsToDelete;
        if (document == null) {
            LOG.error("Document is null");
            return false;
        }
        if (document.getDocumentHeader() != null && document.getDocumentHeader().getWorkflowDocument() != null && document.getDocumentHeader().getWorkflowDocument().getStatus() != null && this.inactiveStatus.contains(document.getDocumentHeader().getWorkflowDocument().getStatus())) {
            return this.doDelete(document.getDocumentNumber());
        }
        Stopwatch timer = Stopwatch.createStarted();
        try {
            boolean bl = this.buildIndexRequestForDocument(document, batchContext).map(indexRequest -> {
                List<DeleteRequest> deleteRequests = otherDocumentsToDelete.stream().map(this::buildDeleteRequestForDocument).toList();
                List<IndexRequest> indexRequests = otherDocumentsToDelete.contains(document.getDocumentNumber()) ? Collections.emptyList() : List.of(indexRequest);
                BulkRequest request = this.buildBulkRequestForDocuments(indexRequests, deleteRequests, null);
                request.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
                try {
                    BulkResponse indexResponse = this.elasticsearchClient.bulk(request, RequestOptions.DEFAULT);
                    if (indexResponse.hasFailures()) {
                        LOG.error("Bulk index had failures for document {}: {}", (Object)document.getDocumentNumber(), (Object)indexResponse.buildFailureMessage());
                        Boolean bl = false;
                        return bl;
                    }
                    LOG.trace("Document {} indexed into Elasticsearch successfully", (Object)document.getDocumentNumber());
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException ioe) {
                    LOG.error(String.format("Failed to index document %s into Elasticsearch", document.getDocumentNumber()), (Throwable)ioe);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    timer.stop();
                    long elapsed = timer.elapsed(TimeUnit.MILLISECONDS);
                    if (elapsed > 5000L) {
                        LOG.warn("Took {} ms to index document {} into Elasticsearch", (Object)elapsed, (Object)document.getDocumentNumber());
                    }
                }
            }).orElse(false);
            return bl;
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to build index request for document %s", document.getDocumentNumber()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (timer.isRunning()) {
                timer.stop();
                long elapsedTime = timer.elapsed(TimeUnit.MILLISECONDS);
                LOG.warn("Took {} milliseconds to index document {}", (Object)elapsedTime, (Object)document.getDocumentNumber());
            }
        }
    }

    protected CompletableFuture<Boolean> doBulkIndex(List<IndexRequest> indexRequests) {
        CompletableFuture cf = new CompletableFuture();
        BulkRequest bulkIndex = this.buildBulkRequestForDocuments(indexRequests, null, null);
        LOG.info("Sending bulk request to Elasticsearch with {} items", (Object)indexRequests.size());
        Stopwatch timer = Stopwatch.createStarted();
        this.elasticsearchClient.bulkAsync(bulkIndex, RequestOptions.DEFAULT, ActionListener.wrap(cf::complete, cf::completeExceptionally));
        timer.stop();
        LOG.info("Took {} milliseconds to send bulk request", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
        return cf.thenApply(response -> {
            BulkItemResponse[] items = response.getItems();
            if (!response.hasFailures()) {
                LOG.info("Successfully indexed {} items", (Object)items.length);
                return true;
            }
            for (BulkItemResponse itemResponse : items) {
                if (itemResponse.getOpType() != DocWriteRequest.OpType.INDEX || !itemResponse.isFailed()) continue;
                LOG.error("Unable to index document {}", (Object)itemResponse.getItemId());
            }
            return false;
        });
    }

    protected Optional<Document> retrieveDocument(String docId) {
        try {
            return Optional.ofNullable(this.documentService.getByDocumentHeaderId(docId));
        }
        catch (WorkflowException e) {
            LOG.error(String.format("Failed to retrieve document #%s", docId), (Throwable)e);
            return Optional.empty();
        }
    }

    protected CompletableFuture<List<IndexRequest>> mapDocumentsToIndexes(List<Document> documents) {
        return this.mapDocumentsToIndexes(documents, null);
    }

    protected CompletableFuture<List<IndexRequest>> mapDocumentsToIndexes(List<Document> documents, ElasticsearchBatchContext batchContext) {
        List<CompletableFuture> results = documents.stream().map(document -> CompletableFuture.supplyAsync(() -> this.buildIndexRequestForDocument((Document)document, batchContext), this.indexThreadPool)).toList();
        return CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).thenApply(v -> results.stream().map(CompletableFuture::join).flatMap(Optional::stream).collect(Collectors.toList()));
    }

    protected CompletableFuture<List<Document>> retrieveDocuments(List<String> docIds) {
        List<CompletableFuture> documentFutures = docIds.parallelStream().map(docId -> CompletableFuture.supplyAsync(() -> {
            Document doc = null;
            try {
                doc = this.documentService.getByDocumentHeaderId(docId);
                LOG.info("Indexing document {} with last modified date {}", (Object)doc.getDocumentNumber(), (Object)doc.getDocumentHeader().getWorkflowDocument().getDateLastModified());
            }
            catch (Exception e) {
                LOG.error(String.format("Failed to retrieve document #%s", docId), (Throwable)e);
            }
            return Optional.ofNullable(doc);
        }, this.indexThreadPool)).toList();
        return CompletableFuture.allOf(documentFutures.toArray(new CompletableFuture[0])).thenApply(v -> documentFutures.stream().map(CompletableFuture::join).flatMap(Optional::stream).collect(Collectors.toList()));
    }

    protected Optional<IndexRequest> buildIndexRequestForDocument(Document document) {
        return this.buildIndexRequestForDocument(document, null);
    }

    protected Optional<IndexRequest> buildIndexRequestForDocument(Document document, ElasticsearchBatchContext batchContext) {
        if (document instanceof DocumentLevelPermissionable) {
            return this.translateDocument((DocumentLevelPermissionable)document, batchContext).map(esDoc -> {
                try {
                    IndexRequest indexRequest = new IndexRequest(this.indexName);
                    indexRequest.id(document.getDocumentNumber());
                    indexRequest.source(this.objectMapper.writeValueAsBytes(esDoc), XContentType.JSON);
                    return indexRequest;
                }
                catch (JsonProcessingException e) {
                    LOG.error(String.format("Exception encountered preparing document %s for indexing", document.getDocumentNumber()), (Throwable)e);
                    return null;
                }
            });
        }
        return Optional.empty();
    }

    protected BulkRequest buildBulkRequestForDocuments(List<IndexRequest> indexRequests, List<DeleteRequest> deleteRequests, List<UpdateRequest> updateRequests) {
        LOG.info("Building bulk request");
        Stopwatch timer = Stopwatch.createStarted();
        BulkRequest bulkRequest = new BulkRequest();
        if (indexRequests != null) {
            for (IndexRequest indexRequest : indexRequests) {
                bulkRequest.add(indexRequest);
            }
        }
        if (deleteRequests != null) {
            for (DeleteRequest deleteRequest : deleteRequests) {
                bulkRequest.add(deleteRequest);
            }
        }
        if (updateRequests != null) {
            for (UpdateRequest updateRequest : updateRequests) {
                bulkRequest.add(updateRequest);
            }
        }
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        timer.stop();
        LOG.info("Done building bulk request {}", (Object)timer.elapsed(TimeUnit.SECONDS));
        return bulkRequest;
    }

    @Override
    public Future<Boolean> delete(String documentId) {
        return this.indexThreadPool.submit(() -> this.doDelete(documentId));
    }

    @Override
    public CompletableFuture<Boolean> deleteCompletable(String documentId) {
        return CompletableFuture.supplyAsync(() -> this.doDelete(documentId), this.indexThreadPool);
    }

    protected boolean doDelete(final String documentId) {
        this.elasticsearchClient.deleteAsync(this.buildDeleteRequestForDocument(documentId), RequestOptions.DEFAULT, (ActionListener)new ActionListener<DeleteResponse>(this){

            public void onResponse(DeleteResponse deleteResponse) {
                LOG.trace(String.format("Document %s deleted from Elasticsearch successfully", documentId));
            }

            public void onFailure(Exception e) {
                LOG.error(String.format("Failed to delete document %s from Elasticsearch", documentId), (Throwable)e);
            }
        });
        return true;
    }

    protected DeleteRequest buildDeleteRequestForDocument(String documentId) {
        return new DeleteRequest(this.indexName, documentId);
    }

    protected Optional<GrantsSearchDocument> translateDocument(DocumentLevelPermissionable document) {
        return this.translateDocument(document, null);
    }

    protected Optional<GrantsSearchDocument> translateDocument(DocumentLevelPermissionable document, ElasticsearchBatchContext batchContext) {
        try {
            if (StringUtils.isBlank((CharSequence)document.getDocumentNumberForPermission())) {
                return Optional.empty();
            }
        }
        catch (NullPointerException e) {
            LOG.warn(String.format("Document %s has no associated transactional data", document.getDocumentNumber()), (Throwable)e);
            return Optional.empty();
        }
        return this.serializers.stream().filter(serializer -> serializer.supports(document)).findFirst().map(serializer -> {
            try {
                GrantsSearchDocument esDoc = serializer.translateDocument(document);
                esDoc.setViewers(this.elasticsearchAccessControlService.getDocumentViewers(document, serializer.getViewPermissions(), batchContext));
                esDoc.setViewerUserNames(esDoc.getViewers().stream().map(arg_0 -> ((PersonService)this.personService).getPerson(arg_0)).filter(Objects::nonNull).map(Person::getPrincipalName).collect(Collectors.toSet()));
                esDoc.setViewUnits(this.elasticsearchAccessControlService.getSubUnitsForView(esDoc.getNamespace(), esDoc.getLeadUnitNumber(), batchContext));
                return esDoc;
            }
            catch (RuntimeException e) {
                LOG.error(String.format("Failed to serialize document %s using %s", document.getDocumentNumber(), serializer.getClass().getSimpleName()), (Throwable)e);
                return null;
            }
        });
    }

    @Override
    public boolean isIdle() {
        return this.indexThreadPool.isQuiescent();
    }

    public void setSerializers(List<ElasticsearchDocumentSerializer> serializers) {
        this.serializers = serializers;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setElasticsearchClient(RestHighLevelClient elasticsearchClient) {
        this.elasticsearchClient = elasticsearchClient;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setIndexThreadPool(ForkJoinPool indexThreadPool) {
        this.indexThreadPool = indexThreadPool;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setBulkChunkEnabled(Boolean bulkChunkEnabled) {
        this.bulkChunkEnabled = bulkChunkEnabled;
    }

    public void setBulkChunkSize(Integer bulkChunkSize) {
        this.bulkChunkSize = bulkChunkSize;
    }

    public Boolean getBulkChunkEnabled() {
        return this.bulkChunkEnabled;
    }

    public Integer getBulkChunkSize() {
        return this.bulkChunkSize;
    }
}

