/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.person.KcPersonContract;
import org.kuali.coeus.common.api.person.KcPersonRepositoryService;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.unit.admin.UnitAdministratorContract;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.instprop.api.admin.ProposalAdminDetailsContract;
import org.kuali.coeus.instprop.api.admin.ProposalAdminDetailsService;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.impl.s2s.map.Address;
import org.kuali.coeus.propdev.impl.s2s.map.KeyPerson;
import org.kuali.coeus.propdev.impl.s2s.map.MappingConstants;
import org.kuali.coeus.propdev.impl.s2s.map.PersonMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.PersonName;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="personMappingService")
public class PersonMappingServiceImpl
implements PersonMappingService {
    private static final String DEFAULT_CONTACT_TYPE = "O";
    private static final String DUMMY_NSF_ID = "000000000";
    private static final String PROPOSAL_CONTACT_TYPE_CONFIG = "PROPOSAL_CONTACT_TYPE";
    private static final String US = "US";
    @Autowired
    @Qualifier(value="proposalAdminDetailsService")
    private ProposalAdminDetailsService proposalAdminDetailsService;
    @Autowired
    @Qualifier(value="kcPersonRepositoryService")
    private KcPersonRepositoryService kcPersonRepositoryService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="countryService")
    private CountryService countryService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2sConfigurationService;
    @Autowired
    @Qualifier(value="unitService")
    private UnitService unitService;

    @Override
    public KeyPerson getAor(DevelopmentProposalContract proposal) {
        ProposalAdminDetailsContract proposalAdminDetails;
        KeyPerson person = this.isOverrideWithSignedBy(proposal) ? this.overridePerson(proposal) : (this.isProposalAdminWithSignedBy(proposalAdminDetails = (ProposalAdminDetailsContract)this.getProposalAdminDetailsService().findProposalAdminDetailsByPropDevNumber(proposal.getProposalNumber()).stream().findFirst().orElse(null)) ? this.submittedPerson(proposalAdminDetails) : this.notSubmittedPerson(proposal));
        return person;
    }

    @Override
    public Optional<KeyPerson> fromRolodex(Integer rolodexId) {
        return Optional.ofNullable(rolodexId).map(arg_0 -> ((RolodexService)this.rolodexService).getRolodex(arg_0)).map(this::fromRolodex);
    }

    @Override
    public Optional<KeyPerson> getProjectDirector(DevelopmentProposalContract proposal) {
        return proposal.getProposalPersons().stream().filter(ProposalPersonContract::isPrincipalInvestigator).findFirst().map(proposalPerson -> this.fromProposalPerson((ProposalPersonContract)proposalPerson, proposal));
    }

    @Override
    public Optional<KeyPerson> getContactPerson(DevelopmentProposalContract proposal) {
        String contactTypeCode = Optional.ofNullable(this.s2sConfigurationService.getValueAsString(PROPOSAL_CONTACT_TYPE_CONFIG)).orElse(DEFAULT_CONTACT_TYPE);
        return Optional.ofNullable(proposal.getOwnedByUnit()).flatMap(unit -> this.getUnitAdministratorForUnit((UnitContract)unit, contactTypeCode)).or(() -> this.getUnitAdministratorForUnit(this.unitService.getTopUnit(), contactTypeCode)).map(this::fromKcPerson);
    }

    private Optional<KcPersonContract> getUnitAdministratorForUnit(UnitContract unit, String contactTypeCode) {
        return Optional.ofNullable(unit).map(UnitContract::getUnitAdministrators).flatMap(unitAdmins -> unitAdmins.stream().filter(unitAdmin -> contactTypeCode.equals(unitAdmin.getUnitAdministratorType().getCode())).findFirst()).map(UnitAdministratorContract::getPersonId).map(arg_0 -> ((KcPersonRepositoryService)this.kcPersonRepositoryService).findKcPersonByPersonId(arg_0));
    }

    private boolean isOverrideWithSignedBy(DevelopmentProposalContract proposal) {
        return proposal.getS2sOverride() != null && proposal.getS2sOverride().isActive() && StringUtils.isNotBlank((CharSequence)proposal.getS2sOverride().getSignedBy()) && proposal.getS2sOverride().getSignedByPerson() != null;
    }

    private boolean isOverrideWithSubmittedDate(DevelopmentProposalContract proposal) {
        return proposal.getS2sOverride() != null && proposal.getS2sOverride().isActive() && proposal.getS2sOverride().getSubmittedDate() != null;
    }

    private boolean isProposalAdminWithSignedBy(ProposalAdminDetailsContract proposalAdminDetails) {
        return proposalAdminDetails != null && StringUtils.isNotBlank((CharSequence)proposalAdminDetails.getSignedBy());
    }

    private KeyPerson overridePerson(DevelopmentProposalContract proposal) {
        return this.fromKcPerson(proposal.getS2sOverride().getSignedByPerson());
    }

    private KeyPerson submittedPerson(ProposalAdminDetailsContract proposalAdminDetails) {
        return this.fromKcPerson(this.getKcPersonRepositoryService().findKcPersonByUserName(proposalAdminDetails.getSignedBy()));
    }

    private KeyPerson notSubmittedPerson(DevelopmentProposalContract proposal) {
        return this.fromRolodex(proposal.getApplicantOrganization().getRolodex());
    }

    private KeyPerson fromProposalPerson(ProposalPersonContract propPerson, DevelopmentProposalContract proposal) {
        KeyPerson person = new KeyPerson();
        person.setName(this.toName(propPerson.getFirstName(), propPerson.getMiddleName(), propPerson.getLastName()));
        person.setAddress(this.toAddress((Addressable)propPerson));
        person.setEmail(propPerson.getEmailAddress());
        person.setPhoneNumber(propPerson.getOfficePhone());
        person.setFaxNumber(propPerson.getFaxNumber());
        person.setSignature(propPerson.getFullName());
        person.setTitle(propPerson.getPrimaryTitle());
        person.setNsfId(propPerson.getNsfId());
        this.getDepartmentName(propPerson, proposal).ifPresent(person::setDepartmentName);
        this.getDivisionName(propPerson).ifPresent(person::setDivisionName);
        return person;
    }

    private KeyPerson fromKcPerson(KcPersonContract kcPerson) {
        KeyPerson person = new KeyPerson();
        person.setName(this.toName(kcPerson.getFirstName(), kcPerson.getMiddleName(), kcPerson.getLastName()));
        person.setAddress(this.toAddress((Addressable)kcPerson));
        person.setEmail(kcPerson.getEmailAddress());
        person.setPhoneNumber(kcPerson.getOfficePhone());
        person.setFaxNumber(kcPerson.getFaxNumber());
        person.setSignature(kcPerson.getFullName());
        person.setTitle(kcPerson.getPrimaryTitle());
        person.setNsfId(kcPerson.getNsfId());
        return person;
    }

    private KeyPerson fromRolodex(RolodexContract rolodex) {
        KeyPerson person = new KeyPerson();
        person.setName(this.toName(rolodex.getFirstName(), rolodex.getMiddleName(), rolodex.getLastName()));
        person.setAddress(this.toAddress((Addressable)rolodex));
        person.setSignature(rolodex.getFullName());
        person.setEmail(rolodex.getEmailAddress());
        person.setPhoneNumber(rolodex.getPhoneNumber());
        person.setFaxNumber(rolodex.getFaxNumber());
        person.setTitle(rolodex.getTitle());
        person.setNsfId(DUMMY_NSF_ID);
        return person;
    }

    private Optional<String> getDepartmentName(ProposalPersonContract propPerson, DevelopmentProposalContract proposal) {
        return Optional.ofNullable(propPerson.getPerson()).map(KcPersonContract::getUnit).map(UnitContract::getUnitName).or(() -> Optional.ofNullable(proposal).map(DevelopmentProposalContract::getOwnedByUnit).map(UnitContract::getUnitName));
    }

    private Optional<String> getDivisionName(ProposalPersonContract propPerson) {
        return Optional.ofNullable(propPerson.getPerson()).map(KcPersonContract::getUnit).map(UnitContract::getParentUnit).map(UnitContract::getUnitName).or(() -> Optional.ofNullable(propPerson.getPerson()).map(KcPersonContract::getUnit).map(UnitContract::getUnitName));
    }

    private PersonName toName(String first, String middle, String last) {
        PersonName name = new PersonName();
        name.setFirst(first);
        name.setMiddle(middle);
        name.setLast(last);
        return name;
    }

    private Address toAddress(Addressable addressable) {
        Address address = new Address();
        address.setStreet1(addressable.getAddressLine1());
        address.setStreet2(addressable.getAddressLine2());
        address.setCity(addressable.getCity());
        address.setCounty(addressable.getCounty());
        address.setZipPostalCode(addressable.getPostalCode());
        Optional<Country> maybeCountry = Optional.ofNullable(addressable.getCountryCode()).filter(StringUtils::isNotBlank).map(arg_0 -> ((CountryService)this.countryService).getCountryByAlternateCode(arg_0));
        maybeCountry.map(country -> MappingConstants.Country.valueOf(country.getAlternateCode())).ifPresent(country -> {
            address.setCountryV2(country.getDisplayV2());
            address.setCountryV3(country.getDisplayV3());
        });
        if (StringUtils.isNotBlank((CharSequence)addressable.getState())) {
            maybeCountry.filter(country -> US.equals(country.getCode())).map(state -> MappingConstants.State.valueOf(addressable.getState())).ifPresentOrElse(state -> {
                address.setStateV2(state.getDisplayV2());
                address.setStateV3(state.getDisplayV3());
            }, () -> address.setProvince(addressable.getState()));
        }
        return address;
    }

    public ProposalAdminDetailsService getProposalAdminDetailsService() {
        return this.proposalAdminDetailsService;
    }

    public void setProposalAdminDetailsService(ProposalAdminDetailsService proposalAdminDetailsService) {
        this.proposalAdminDetailsService = proposalAdminDetailsService;
    }

    public KcPersonRepositoryService getKcPersonRepositoryService() {
        return this.kcPersonRepositoryService;
    }

    public void setKcPersonRepositoryService(KcPersonRepositoryService kcPersonRepositoryService) {
        this.kcPersonRepositoryService = kcPersonRepositoryService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public CountryService getCountryService() {
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }

    public S2SConfigurationService getS2sConfigurationService() {
        return this.s2sConfigurationService;
    }

    public void setS2sConfigurationService(S2SConfigurationService s2sConfigurationService) {
        this.s2sConfigurationService = s2sConfigurationService;
    }
}

