/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.web.struts.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.kuali.coeus.common.framework.keyword.KeywordsService;
import org.kuali.coeus.common.framework.version.VersionException;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCfda;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalNotepad;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLog;
import org.kuali.kra.institutionalproposal.proposallog.ProposalLogUtils;
import org.kuali.kra.institutionalproposal.proposallog.service.ProposalLogService;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCfdaRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalNoteAddEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalNoteEventBase;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalNoteAttachmentService;
import org.kuali.kra.institutionalproposal.web.struts.action.InstitutionalProposalAction;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthenticationException;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalHomeAction
extends InstitutionalProposalAction {
    private static final String VERSION_EDITPENDING_PROMPT_KEY = "message.award.version.editpending.prompt";
    private static final String PENDING = "PENDING";
    private InstitutionalProposalNoteAttachmentService institutionalProposalNoteAttachmentService;
    private KeywordsService keywordsService;
    private NegotiationService negotiationService;
    private ProposalLogService proposalLogService;
    private VersionHistoryService versionHistoryService;
    private GlobalVariableService globalVariableService;

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (this.applyRules((DocumentEvent)new InstitutionalProposalNoteAddEvent("", ((InstitutionalProposalForm)form).getDocument(), institutionalProposalForm.getInstitutionalProposalNotepadBean().getNewInstitutionalProposalNotepad(), InstitutionalProposalNoteEventBase.ErrorType.HARDERROR))) {
            return this.getInstitutionalProposalNoteAttachmentService().addNote(mapping, institutionalProposalForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateNotes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward deleteNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getLineToDelete(request);
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        return this.getInstitutionalProposalNoteAttachmentService().deleteNote(mapping, institutionalProposalForm, selection);
    }

    public ActionForward selectAllScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        List<InstitutionalProposalScienceKeyword> keywords = institutionalProposalDocument.getInstitutionalProposal().getKeywords();
        keywords.forEach(institutionalProposalScienceKeyword -> institutionalProposalScienceKeyword.setSelectKeyword(true));
        return mapping.findForward("basic");
    }

    public ActionForward deleteSelectedScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        this.getKeywordsService().deleteKeyword(institutionalProposalDocument.getInstitutionalProposal());
        return mapping.findForward("basic");
    }

    public ActionForward recalculateTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        InstitutionalProposalForm propMultiLookupForm = (InstitutionalProposalForm)form;
        String lookupResultsBOClassName = request.getParameter("lookupResultsBOClassName");
        String lookupResultsSequenceNumber = request.getParameter("lookupResultsSequenceNumber");
        propMultiLookupForm.setLookupResultsBOClassName(lookupResultsBOClassName);
        propMultiLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        InstitutionalProposal prop = propMultiLookupForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        this.getKeywordsService().addKeywords(prop, propMultiLookupForm);
        if (prop.getRolodexId() != null) {
            prop.refreshReferenceObject("rolodex");
        }
        return mapping.findForward("basic");
    }

    public ActionForward addInstitutionalProposalCfda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        InstitutionalProposalCfda newProposalCfda = institutionalProposalForm.getNewProposalCfda();
        InstitutionalProposal institutionalProposal = institutionalProposalDocument.getInstitutionalProposal();
        newProposalCfda.setSequenceNumber(institutionalProposal.getSequenceNumber());
        newProposalCfda.setProposalNumber(institutionalProposal.getProposalNumber());
        newProposalCfda.setInstitutionalProposal(institutionalProposal);
        newProposalCfda.setProposalId(institutionalProposal.getProposalId());
        institutionalProposal.getProposalCfdas().add(newProposalCfda);
        institutionalProposalForm.setNewProposalCfda(new InstitutionalProposalCfda());
        this.getKualiRuleService().applyRules((DocumentEvent)new InstitutionalProposalCfdaRuleEvent("", institutionalProposalForm.getInstitutionalProposalDocument()));
        return mapping.findForward("basic");
    }

    public ActionForward deleteInstitutionalProposalCfda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        int delIpCfda = this.getLineToDelete(request);
        institutionalProposalDocument.getInstitutionalProposal().getProposalCfdas().remove(delIpCfda);
        return mapping.findForward("basic");
    }

    protected KeywordsService getKeywordsService() {
        if (this.keywordsService == null) {
            this.keywordsService = KcServiceLocator.getService(KeywordsService.class);
        }
        return this.keywordsService;
    }

    public void setKeywordsService(KeywordsService keywordsService) {
        this.keywordsService = keywordsService;
    }

    public ActionForward clearMailingNameAddress(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        if (institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().getRolodex() != null) {
            institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().setRolodexId(null);
            institutionalProposalForm.getInstitutionalProposalDocument().getInstitutionalProposal().setRolodex(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        InstitutionalProposalForm institutionalProposalForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = institutionalProposalForm.getInstitutionalProposalDocument();
        InstitutionalProposal institutionalProposal = institutionalProposalDocument.getInstitutionalProposal();
        if (institutionalProposal.getProposalSequenceStatus().equalsIgnoreCase(PENDING)) {
            response.sendRedirect(this.buildForwardUrl(institutionalProposalForm.getDocId()));
            return null;
        }
        InstitutionalProposal pendingProposal = this.findPendingVersion(institutionalProposal.getProposalNumber());
        if (pendingProposal != null) {
            String question;
            forward = this.isPessimisticLockInPlace(pendingProposal.getInstitutionalProposalDocument().getDocumentNumber()) ? this.displayAnotherUserEditingError(mapping) : ((question = request.getParameter("buttonClicked")) == null ? this.showPromptForEditingPendingVersion(mapping, institutionalProposalForm, request, response) : this.processPromptForEditingPendingVersionResponse(mapping, request, response, institutionalProposalForm, pendingProposal));
        } else if (this.isPessimisticLockInPlace(institutionalProposalDocument.getDocumentNumber())) {
            forward = this.displayAnotherUserEditingError(mapping);
        } else {
            forward = this.createAndSaveNewVersion(response, institutionalProposalForm, institutionalProposalDocument, institutionalProposal);
            this.generateNewLock(institutionalProposalForm.getInstitutionalProposalDocument());
        }
        return forward;
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)kualiDocumentFormBase;
        ProposalLog proposalLog = this.retrieveProposalLog(ipForm.getProposalNumber());
        if (proposalLog != null) {
            CommentType ct = new CommentType();
            ct.setCommentTypeCode("12");
            ct.setDescription("description");
            ct.setChecklistFlag(false);
            ct.setTemplateFlag(false);
            ct.setAwardCommentScreenFlag(false);
            ct.setSubAwardCommentScreenFlag(false);
            ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().setDeadlineDate(proposalLog.getDeadlineDate());
            ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().setDeadlineTime(proposalLog.getDeadlineTime());
            InstitutionalProposalComment ipCmt = new InstitutionalProposalComment("12");
            ipCmt.setCommentType(ct);
            ipCmt.setComments(proposalLog.getComments());
            ipCmt.setProposalNumber(proposalLog.getProposalNumber());
            ipCmt.setProposalId(ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().getProposalId());
            ipCmt.setInstitutionalProposal(ipForm.getInstitutionalProposalDocument().getInstitutionalProposal());
            ipCmt.getInstitutionalProposal().setProposalNumber(proposalLog.getProposalNumber());
            ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().add(ipCmt);
            ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().setProposalNumber(proposalLog.getProposalNumber());
            ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().doProposalLogDataFeed(proposalLog);
        } else {
            ipForm.getInstitutionalProposalDocument().getInstitutionalProposal().setProposalNumber(this.getInstitutionalProposalService().getNextInstitutionalProposalNumber());
        }
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        InstitutionalProposal ip = ipForm.getInstitutionalProposalDocument().getInstitutionalProposal();
        if (!ip.getInstitutionalProposalScienceKeywords().isEmpty()) {
            ip.setScienceCodeIndicator("1");
        } else {
            ip.setScienceCodeIndicator("0");
        }
        String navigateTo = ipForm.getNavigateTo();
        if (navigateTo == null || navigateTo.equalsIgnoreCase("home")) {
            this.getKualiRuleService().applyRules((DocumentEvent)new InstitutionalProposalCfdaRuleEvent("", ipForm.getInstitutionalProposalDocument()));
        }
        ActionForward forward = super.save(mapping, form, request, response);
        ProposalLog proposalLog = this.retrieveProposalLog(ipForm.getProposalNumber());
        if (proposalLog != null && !proposalLog.getLogStatus().equals(ProposalLogUtils.getProposalLogSubmittedStatusCode())) {
            this.getProposalLogService().promoteProposalLog(proposalLog.getProposalNumber());
            this.getNegotiationService().promoteProposalLogNegotiation(proposalLog.getProposalNumber(), ip.getProposalNumber());
        }
        ip.setSponsorNihMultiplePi(this.getSponsorHierarchyService().isSponsorNihMultiplePi(ip.getSponsorCode()));
        ip.refreshReferenceObject("institutionalProposalNotepads");
        return forward;
    }

    public NegotiationService getNegotiationService() {
        if (this.negotiationService == null) {
            this.negotiationService = KcServiceLocator.getService(NegotiationService.class);
        }
        return this.negotiationService;
    }

    public void setNegotiationService(NegotiationService negotiationService) {
        this.negotiationService = negotiationService;
    }

    private ProposalLog retrieveProposalLog(String proposalNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("proposalNumber", proposalNumber);
        return (ProposalLog)this.getBusinessObjectService().findByPrimaryKey(ProposalLog.class, criteria);
    }

    private InstitutionalProposal findPendingVersion(String proposalNumber) {
        return this.getInstitutionalProposalVersioningService().getPendingInstitutionalProposalVersion(proposalNumber);
    }

    private ActionForward createAndSaveNewVersion(HttpServletResponse response, InstitutionalProposalForm institutionalProposalForm, InstitutionalProposalDocument institutionalProposalDocument, InstitutionalProposal institutionalProposal) throws VersionException, WorkflowException, IOException {
        InstitutionalProposalDocument newInstitutionalProposalDocument = this.getInstitutionalProposalService().createAndSaveNewVersion(institutionalProposal, institutionalProposalDocument);
        this.reinitializeForm(institutionalProposalForm, newInstitutionalProposalDocument);
        return new ActionRedirect(this.buildForwardUrl(newInstitutionalProposalDocument.getDocumentNumber()));
    }

    public VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    public GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    private void reinitializeForm(InstitutionalProposalForm institutionalProposalForm, InstitutionalProposalDocument document) {
        institutionalProposalForm.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        institutionalProposalForm.setDocument(document);
        institutionalProposalForm.initialize();
    }

    private ActionForward showPromptForEditingPendingVersion(ActionMapping mapping, InstitutionalProposalForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performQuestionWithoutInput(mapping, (ActionForm)form, request, response, "EDIT_OR_VERSION_QUESTION_ID", this.getResources(request).getMessage(VERSION_EDITPENDING_PROMPT_KEY), "confirmationQuestion", "cancel", "");
    }

    private ActionForward processPromptForEditingPendingVersionResponse(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, InstitutionalProposalForm institutionalProposalForm, InstitutionalProposal institutionalProposal) throws WorkflowException, IOException {
        ActionForward forward;
        String buttonClicked = request.getParameter("buttonClicked");
        if ("1".equals(buttonClicked)) {
            forward = mapping.findForward("basic");
        } else {
            this.generateNewLock(institutionalProposal.getInstitutionalProposalDocument());
            this.initializeFormWithInstutitionalProposal(institutionalProposalForm, institutionalProposal);
            response.sendRedirect(this.buildForwardUrl(institutionalProposalForm.getInstitutionalProposalDocument().getDocumentNumber()));
            forward = null;
        }
        return forward;
    }

    private void initializeFormWithInstutitionalProposal(InstitutionalProposalForm institutionalProposalForm, InstitutionalProposal institutionalProposal) throws WorkflowException {
        this.reinitializeForm(institutionalProposalForm, this.findDocumentForInstitutionalProposal(institutionalProposal));
    }

    private InstitutionalProposalDocument findDocumentForInstitutionalProposal(InstitutionalProposal institutionalProposal) throws WorkflowException {
        InstitutionalProposalDocument document = (InstitutionalProposalDocument)this.getDocumentService().getByDocumentHeaderId(institutionalProposal.getInstitutionalProposalDocument().getDocumentNumber());
        document.setInstitutionalProposal(institutionalProposal);
        return document;
    }

    public ActionForward downloadBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int attachmentIndex = this.selectedAttachmentIndex(request);
        InstitutionalProposalForm ipForm = (InstitutionalProposalForm)form;
        InstitutionalProposalDocument institutionalProposalDocument = ipForm.getInstitutionalProposalDocument();
        if (!WebUtils.canViewNoteAttachment((Document)institutionalProposalDocument, null)) {
            throw new AuthenticationException("Unable to view attachment.");
        }
        List<InstitutionalProposalNotepad> notepads = institutionalProposalDocument.getInstitutionalProposal().getInstitutionalProposalNotepads();
        InstitutionalProposalNotepad noteParent = notepads.get(attachmentIndex);
        if (attachmentIndex >= 0) {
            Attachment attachment = noteParent.getAttachments().get(0).getAttachment();
            KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
            documentForm.copyPopulateEditablePropertiesToActionEditableProperties();
            WebUtils.saveMimeInputStreamAsFile((HttpServletResponse)response, (String)attachment.getAttachmentMimeTypeCode(), (InputStream)attachment.getAttachmentContents(), (String)attachment.getAttachmentFileName(), (int)attachment.getAttachmentFileSize().intValue());
            return null;
        }
        return mapping.findForward("basic");
    }

    private boolean isPessimisticLockInPlace(String documentNumber) {
        return this.getPessimisticLockService().getPessimisticLocksForDocument(documentNumber).stream().findAny().isPresent();
    }

    private void generateNewLock(InstitutionalProposalDocument institutionalProposalDocument) {
        this.getPessimisticLockService().generateNewLock(institutionalProposalDocument.getDocumentNumber(), this.getVersionHistoryService().getVersionLockDescriptor(institutionalProposalDocument.getDocumentTypeCode(), institutionalProposalDocument.getDocumentNumber()), GlobalVariables.getUserSession().getPerson());
    }

    private ActionForward displayAnotherUserEditingError(ActionMapping mapping) {
        this.getGlobalVariableService().getMessageMap().putError("document.documentHeader.documentNumber", "message.document.version.another.user.editing", new String[]{"Institutional Proposal", this.globalVariableService.getUserSession().getPerson().getFirstName(), this.globalVariableService.getUserSession().getPerson().getLastName(), this.globalVariableService.getUserSession().getPrincipalName()});
        return mapping.findForward("basic");
    }

    protected ProposalLogService getProposalLogService() {
        if (this.proposalLogService == null) {
            this.proposalLogService = KcServiceLocator.getService(ProposalLogService.class);
        }
        return this.proposalLogService;
    }

    public InstitutionalProposalNoteAttachmentService getInstitutionalProposalNoteAttachmentService() {
        if (this.institutionalProposalNoteAttachmentService == null) {
            this.institutionalProposalNoteAttachmentService = KcServiceLocator.getService(InstitutionalProposalNoteAttachmentService.class);
        }
        return this.institutionalProposalNoteAttachmentService;
    }
}

