/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.web.struts.action;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.attachment.AttachmentDocumentStatus;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.util.PrintingUtils;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAwardAttachment;
import org.kuali.kra.subaward.bo.SubAwardNotepadBean;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.subaward.subawardrule.events.AddSubAwardAttachmentEvent;
import org.kuali.kra.subaward.subawardrule.events.SubAwardNoteAddEvent;
import org.kuali.kra.subaward.subawardrule.events.SubAwardNoteEventBase;
import org.kuali.kra.subaward.web.struts.action.SubAwardAction;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;

public class SubAwardNotesAndAttachmentsAction
extends SubAwardAction {
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String CONFIRM_DELETE_ATTACHMENT = "confirmDeleteAttachment";
    private static final String CONFIRM_DELETE_ATTACHMENT_KEY = "confirmDeleteAttachmentKey";
    private static final String CONFIRM_VOID_ATTACHMENT = "confirmVoidAttachment";
    private static final String CONFIRM_VOID_ATTACHMENT_KEY = "confirmVoidAttachmentKey";
    private static final String EMPTY_STRING = "";
    public static final String SUBAWARD_ATTACHMENT_PREFIX = "document.subAwardList[0].subAwardAttachments[%d]";
    private SubAwardNotepadBean subAwardNotepadBean = new SubAwardNotepadBean();

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        subAwardForm.getSubAwardCommentBean().setSubAwardCommentScreenDisplayTypesOnForm();
        return actionForward;
    }

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.applyRules((DocumentEvent)new SubAwardNoteAddEvent(EMPTY_STRING, ((SubAwardForm)form).getDocument(), ((SubAwardForm)form).getSubAwardNotepadBean().getNewSubAwardNotepad(), SubAwardNoteEventBase.ErrorType.HARDERROR))) {
            this.subAwardNotepadBean.addNote(((SubAwardForm)form).getSubAwardNotepadBean());
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateNotes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward addAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardAttachment subAwardAttachment = ((SubAwardForm)form).getSubAwardAttachmentFormBean().getNewAttachment();
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAward = subAwardForm.getSubAwardDocument();
        if (this.getKualiRuleService().applyRules((DocumentEvent)new AddSubAwardAttachmentEvent(EMPTY_STRING, EMPTY_STRING, subAward, subAwardAttachment))) {
            ((SubAwardForm)form).getSubAwardAttachmentFormBean().addNewSubAwardAttachment();
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        int selection = this.getSelectedLine(request);
        SubAwardAttachment attachment = subAwardForm.getSubAwardAttachmentFormBean().retrieveExistingAttachment(selection);
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getData(), SubAwardNotesAndAttachmentsAction.getValidHeaderString(attachment.getName()), SubAwardNotesAndAttachmentsAction.getValidHeaderString(attachment.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int delAttachment = this.getLineToDelete(request);
        return this.confirm(this.buildDeleteAttachmentConfirmationQuestion(mapping, form, request, response, delAttachment), CONFIRM_DELETE_ATTACHMENT, EMPTY_STRING);
    }

    private StrutsConfirmation buildDeleteAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int deleteAttachment) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        SubAwardAttachment attachment = subAwardDocument.getSubAward().getSubAwardAttachments().get(deleteAttachment);
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_ATTACHMENT_KEY, "document.question.deleteAttachment.text", "Subaward Attachment", attachment.getName());
    }

    public ActionForward confirmDeleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int delAttachment = this.getLineToDelete(request);
        subAwardDocument.getSubAward().getSubAwardAttachments().remove(delAttachment);
        return mapping.findForward("basic");
    }

    public ActionForward modifyAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardDocument awardDocument = ((SubAwardForm)form).getSubAwardDocument();
        awardDocument.getSubAwardList().get(0).getSubAwardAttachments().get(this.getSelectedLine(request)).setModifyAttachment(true);
        return mapping.findForward("basic");
    }

    public ActionForward voidAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildVoidAttachmentConfirmationQuestion(mapping, form, request, response), CONFIRM_VOID_ATTACHMENT, EMPTY_STRING);
    }

    public ActionForward applyModifyAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardDocument subAwardDocument = ((SubAwardForm)form).getSubAwardDocument();
        int selectedLineIndex = this.getSelectedLine(request);
        SubAwardAttachment editSubAwardAttachment = subAwardDocument.getSubAward().getSubAwardAttachments().get(selectedLineIndex);
        if (new SubAwardDocumentRule().processApplySubAwardAttachmentModificationRule(new AddSubAwardAttachmentEvent(EMPTY_STRING, String.format(SUBAWARD_ATTACHMENT_PREFIX, selectedLineIndex), subAwardDocument, editSubAwardAttachment))) {
            editSubAwardAttachment.setModifyAttachment(false);
            this.updateTimestampIfModified(editSubAwardAttachment);
            this.getBusinessObjectService().save((PersistableBusinessObject)editSubAwardAttachment);
        }
        return mapping.findForward("basic");
    }

    protected void updateTimestampIfModified(SubAwardAttachment editSubAwardAttachment) {
        if (this.hasSubAwardAttachmentBeenModified(editSubAwardAttachment)) {
            editSubAwardAttachment.setLastUpdateTimestamp(new Timestamp(new Date().getTime()));
            editSubAwardAttachment.setLastUpdateUser(this.getGlobalVariableService().getUserSession().getPrincipalName());
        }
    }

    private boolean hasSubAwardAttachmentBeenModified(SubAwardAttachment subAwardAttachment) {
        SubAwardAttachment dbAwardAttachment = (SubAwardAttachment)this.getBusinessObjectService().findBySinglePrimaryKey(SubAwardAttachment.class, (Object)subAwardAttachment.getAttachmentId());
        return !dbAwardAttachment.getSubAwardAttachmentTypeCode().equals(subAwardAttachment.getSubAwardAttachmentTypeCode()) || !dbAwardAttachment.getDescription().equals(subAwardAttachment.getDescription());
    }

    private StrutsConfirmation buildVoidAttachmentConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_VOID_ATTACHMENT_KEY, "document.question.voidAttachment.text", EMPTY_STRING, EMPTY_STRING);
    }

    public ActionForward confirmVoidAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardDocument subAwardDocument = ((SubAwardForm)form).getSubAwardDocument();
        int selectedLineIndex = this.getSelectedLine(request);
        subAwardDocument.getSubAward().getSubAwardAttachments().get(selectedLineIndex).setDocumentStatusCode(AttachmentDocumentStatus.VOID.getCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)subAwardDocument.getSubAward().getSubAwardAttachments().get(selectedLineIndex));
        return mapping.findForward("basic");
    }

    public ActionForward downloadAllSubAwardAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDoc = subAwardForm.getSubAwardDocument();
        List<SubAwardAttachment> attachments = subAwardDoc.getSubAward().getSubAwardAttachments();
        ArrayList<AttachmentDataSource> genericAtts = new ArrayList<AttachmentDataSource>();
        for (SubAwardAttachment attachment : attachments) {
            PrintableAttachment newADS = new PrintableAttachment();
            newADS.setData(attachment.getData());
            newADS.setType(attachment.getType());
            newADS.setName(attachment.getName());
            genericAtts.add(newADS);
        }
        PrintingUtils.downloadAllAttachments(genericAtts, response, subAwardDoc.getSubAward().getSubAwardCode() + "-SubAward_Attachments.zip");
        return RESPONSE_ALREADY_HANDLED;
    }

    protected GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }
}

