/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelationContract;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBo;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationBoService;

public class TypeTypeRelationBoServiceImpl
implements TypeTypeRelationBoService {
    private DataObjectService dataObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public void setAttributeDefinitionService(KrmsAttributeDefinitionService attributeDefinitionService) {
        this.attributeDefinitionService = attributeDefinitionService;
    }

    public KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }

    @Override
    public TypeTypeRelation createTypeTypeRelation(TypeTypeRelation typeTypeRelation) {
        String typeTypeRelationIdKey;
        TypeTypeRelation existing;
        this.incomingParamCheck(typeTypeRelation, "typeTypeRelation");
        if (StringUtils.isNotEmpty((String)typeTypeRelation.getId()) && (existing = this.getTypeTypeRelation(typeTypeRelationIdKey = typeTypeRelation.getId())) != null) {
            throw new IllegalStateException("the TypeTypeRelation to create already exists: " + String.valueOf(typeTypeRelation));
        }
        TypeTypeRelationBo bo = (TypeTypeRelationBo)this.dataObjectService.save((Object)this.from(typeTypeRelation), new PersistenceOption[]{PersistenceOption.FLUSH});
        return TypeTypeRelationBo.to(bo);
    }

    @Override
    public TypeTypeRelation getTypeTypeRelation(String typeTypeRelationId) {
        this.incomingParamCheck(typeTypeRelationId, "typeTypeRelationId");
        TypeTypeRelationBo bo = (TypeTypeRelationBo)this.dataObjectService.find(TypeTypeRelationBo.class, (Object)typeTypeRelationId);
        return TypeTypeRelationBo.to(bo);
    }

    @Override
    public TypeTypeRelation updateTypeTypeRelation(TypeTypeRelation typeTypeRelation) {
        TypeTypeRelation toUpdate;
        this.incomingParamCheck(typeTypeRelation, "typeTypeRelation");
        TypeTypeRelation existing = this.getTypeTypeRelation(typeTypeRelation.getId());
        if (existing == null) {
            throw new IllegalStateException("the TypeTypeRelation to update does not exists: " + String.valueOf(typeTypeRelation));
        }
        if (!existing.getId().equals(typeTypeRelation.getId())) {
            TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((TypeTypeRelationContract)typeTypeRelation);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = typeTypeRelation;
        }
        TypeTypeRelationBo boToUpdate = this.from(toUpdate);
        TypeTypeRelationBo updatedData = (TypeTypeRelationBo)this.dataObjectService.save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
        return this.to(updatedData);
    }

    @Override
    public void deleteTypeTypeRelation(String typeTypeRelationId) {
        this.incomingParamCheck(typeTypeRelationId, "typeTypeRelationId");
        TypeTypeRelation existing = this.getTypeTypeRelation(typeTypeRelationId);
        if (existing == null) {
            throw new IllegalStateException("the TypeTypeRelation to delete does not exists: " + typeTypeRelationId);
        }
        this.dataObjectService.delete((Object)this.from(existing));
    }

    @Override
    public List<TypeTypeRelation> findTypeTypeRelationsByFromType(String fromTypeId) {
        if (StringUtils.isBlank((String)fromTypeId)) {
            throw new IllegalArgumentException("fromTypeId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fromTypeId", fromTypeId);
        List<TypeTypeRelationBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, TypeTypeRelationBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<TypeTypeRelation> findTypeTypeRelationsByToType(String toTypeId) {
        if (StringUtils.isBlank((String)toTypeId)) {
            throw new IllegalArgumentException("toTypeId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("toTypeId", toTypeId);
        List<TypeTypeRelationBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, TypeTypeRelationBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<TypeTypeRelation> findTypeTypeRelationsByRelationshipType(RelationshipType relationshipType) {
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType is null");
        }
        HashMap<String, RelationshipType> map = new HashMap<String, RelationshipType>();
        map.put("relationshipType", relationshipType);
        List<TypeTypeRelationBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, TypeTypeRelationBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    @Override
    public List<TypeTypeRelation> findTypeTypeRelationsBySequenceNumber(Integer sequenceNumber) {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("sequenceNumber is null");
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("sequenceNumber", sequenceNumber);
        List<TypeTypeRelationBo> bos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, TypeTypeRelationBo.class, map);
        return this.convertBosToImmutables(bos);
    }

    public List<TypeTypeRelation> convertBosToImmutables(Collection<TypeTypeRelationBo> typeTypeRelationBos) {
        LinkedList<TypeTypeRelation> immutables = new LinkedList<TypeTypeRelation>();
        if (typeTypeRelationBos != null) {
            TypeTypeRelation immutable = null;
            for (TypeTypeRelationBo bo : typeTypeRelationBos) {
                immutable = this.to(bo);
                immutables.add(immutable);
            }
        }
        return Collections.unmodifiableList(immutables);
    }

    @Override
    public TypeTypeRelation to(TypeTypeRelationBo typeTypeRelationBo) {
        return TypeTypeRelationBo.to(typeTypeRelationBo);
    }

    @Override
    public TypeTypeRelationBo from(TypeTypeRelation typeTypeRelation) {
        return TypeTypeRelationBo.from(typeTypeRelation);
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new IllegalArgumentException(name + " was blank");
        }
    }
}

