/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.impl.bus;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.SoapServiceConfiguration;

public class ServiceConfigurationSerializationHandler {
    private static final Set<Class<?>> CONFIG_CLASSES_SET = new HashSet();

    public static String marshallToXml(ServiceConfiguration serviceConfiguration) {
        if (serviceConfiguration == null) {
            throw new IllegalArgumentException("serviceConfiguration was null");
        }
        if (!CONFIG_CLASSES_SET.contains(serviceConfiguration.getClass())) {
            throw new IllegalArgumentException("Illegal ServiceConfiguration class: " + String.valueOf(serviceConfiguration.getClass()));
        }
        StringWriter writer = new StringWriter();
        try {
            ServiceConfigurationSerializationHandler.getContext().createMarshaller().marshal((Object)serviceConfiguration, (Writer)writer);
        }
        catch (JAXBException e) {
            throw new RiceRuntimeException("Failed to marshall ServiceConfiguration to XML: " + String.valueOf(serviceConfiguration), (Throwable)e);
        }
        return writer.toString();
    }

    public static ServiceConfiguration unmarshallFromXml(String xml) {
        if (StringUtils.isBlank((String)xml)) {
            throw new IllegalArgumentException("xml was null or blank");
        }
        try {
            Object unmarshalled = ServiceConfigurationSerializationHandler.getContext().createUnmarshaller().unmarshal((Reader)new StringReader(xml));
            if (!(unmarshalled instanceof ServiceConfiguration)) {
                throw new RiceRuntimeException("Unmarshalled value was not a valid ServiceConfiguration: " + String.valueOf(unmarshalled.getClass()));
            }
            return (ServiceConfiguration)unmarshalled;
        }
        catch (JAXBException e) {
            throw new RiceRuntimeException("Failed to unmarhsal ServiceConfiguration from XML: " + xml, (Throwable)e);
        }
    }

    private static JAXBContext getContext() {
        return ContextHolder.context;
    }

    static {
        CONFIG_CLASSES_SET.add(JavaServiceConfiguration.class);
        CONFIG_CLASSES_SET.add(SoapServiceConfiguration.class);
    }

    private static class ContextHolder {
        private static final Class<?>[] CONFIG_CLASSES_ARRAY = CONFIG_CLASSES_SET.toArray(new Class[0]);
        static final JAXBContext context;

        private ContextHolder() {
        }

        static {
            try {
                context = JAXBContext.newInstance((Class[])CONFIG_CLASSES_ARRAY);
            }
            catch (JAXBException e) {
                throw new RiceRuntimeException((Throwable)e);
            }
        }
    }
}

