/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.remote;

import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoRequest;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoResponse;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public final class TransportRemoteInfoAction
extends HandledTransportAction<RemoteInfoRequest, RemoteInfoResponse> {
    private final RemoteClusterService remoteClusterService;

    @Inject
    public TransportRemoteInfoAction(TransportService transportService, ActionFilters actionFilters, SearchTransportService searchTransportService) {
        super("cluster:monitor/remote/info", transportService, actionFilters, RemoteInfoRequest::new);
        this.remoteClusterService = searchTransportService.getRemoteClusterService();
    }

    @Override
    protected void doExecute(Task task, RemoteInfoRequest remoteInfoRequest, ActionListener<RemoteInfoResponse> listener) {
        if (!this.remoteClusterService.isEnabled()) {
            throw new IllegalArgumentException("node [" + this.remoteClusterService.getLocalNode().getName() + "] does not have the [" + DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + "] role");
        }
        listener.onResponse(new RemoteInfoResponse(this.remoteClusterService.getRemoteConnectionInfos().collect(Collectors.toList())));
    }
}

