/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ShardStats
implements Writeable,
ToXContentFragment {
    private ShardRouting shardRouting;
    private CommonStats commonStats;
    @Nullable
    private CommitStats commitStats;
    @Nullable
    private SeqNoStats seqNoStats;
    @Nullable
    private RetentionLeaseStats retentionLeaseStats;
    private String dataPath;
    private String statePath;
    private boolean isCustomDataPath;

    public RetentionLeaseStats getRetentionLeaseStats() {
        return this.retentionLeaseStats;
    }

    public ShardStats(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.commonStats = new CommonStats(in);
        this.commitStats = CommitStats.readOptionalCommitStatsFrom(in);
        this.statePath = in.readString();
        this.dataPath = in.readString();
        this.isCustomDataPath = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            this.seqNoStats = in.readOptionalWriteable(SeqNoStats::new);
        }
        if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.retentionLeaseStats = in.readOptionalWriteable(RetentionLeaseStats::new);
        }
    }

    public ShardStats(ShardRouting routing, ShardPath shardPath, CommonStats commonStats, CommitStats commitStats, SeqNoStats seqNoStats, RetentionLeaseStats retentionLeaseStats) {
        this.shardRouting = routing;
        this.dataPath = shardPath.getRootDataPath().toString();
        this.statePath = shardPath.getRootStatePath().toString();
        this.isCustomDataPath = shardPath.isCustomDataPath();
        this.commitStats = commitStats;
        this.commonStats = commonStats;
        this.seqNoStats = seqNoStats;
        this.retentionLeaseStats = retentionLeaseStats;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.commonStats;
    }

    @Nullable
    public CommitStats getCommitStats() {
        return this.commitStats;
    }

    @Nullable
    public SeqNoStats getSeqNoStats() {
        return this.seqNoStats;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getStatePath() {
        return this.statePath;
    }

    public boolean isCustomDataPath() {
        return this.isCustomDataPath;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        this.commonStats.writeTo(out);
        out.writeOptionalWriteable(this.commitStats);
        out.writeString(this.statePath);
        out.writeString(this.dataPath);
        out.writeBoolean(this.isCustomDataPath);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            out.writeOptionalWriteable(this.seqNoStats);
        }
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeOptionalWriteable(this.retentionLeaseStats);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("routing").field("state", (Enum)this.shardRouting.state()).field("primary", this.shardRouting.primary()).field("node", this.shardRouting.currentNodeId()).field("relocating_node", this.shardRouting.relocatingNodeId()).endObject();
        this.commonStats.toXContent(builder, params);
        if (this.commitStats != null) {
            this.commitStats.toXContent(builder, params);
        }
        if (this.seqNoStats != null) {
            this.seqNoStats.toXContent(builder, params);
        }
        if (this.retentionLeaseStats != null) {
            this.retentionLeaseStats.toXContent(builder, params);
        }
        builder.startObject("shard_path");
        builder.field("state_path", this.statePath);
        builder.field("data_path", this.dataPath);
        builder.field("is_custom_data_path", this.isCustomDataPath);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String ROUTING = "routing";
        static final String STATE = "state";
        static final String STATE_PATH = "state_path";
        static final String DATA_PATH = "data_path";
        static final String IS_CUSTOM_DATA_PATH = "is_custom_data_path";
        static final String SHARD_PATH = "shard_path";
        static final String PRIMARY = "primary";
        static final String NODE = "node";
        static final String RELOCATING_NODE = "relocating_node";

        Fields() {
        }
    }
}

