/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.ToIntBiFunction;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.BytesReferenceStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractBytesReference
implements BytesReference {
    private Integer hash = null;

    @Override
    public int getInt(int index) {
        return (this.get(index) & 0xFF) << 24 | (this.get(index + 1) & 0xFF) << 16 | (this.get(index + 2) & 0xFF) << 8 | this.get(index + 3) & 0xFF;
    }

    @Override
    public int indexOf(byte marker, int from) {
        int to = this.length();
        for (int i = from; i < to; ++i) {
            if (this.get(i) != marker) continue;
            return i;
        }
        return -1;
    }

    @Override
    public StreamInput streamInput() throws IOException {
        return new BytesReferenceStreamInput(this);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        BytesRef ref;
        BytesRefIterator iterator = this.iterator();
        while ((ref = iterator.next()) != null) {
            os.write(ref.bytes, ref.offset, ref.length);
        }
    }

    @Override
    public String utf8ToString() {
        return this.toBytesRef().utf8ToString();
    }

    @Override
    public BytesRefIterator iterator() {
        return new BytesRefIterator(){
            BytesRef ref;
            {
                this.ref = AbstractBytesReference.this.length() == 0 ? null : AbstractBytesReference.this.toBytesRef();
            }

            public BytesRef next() {
                BytesRef r = this.ref;
                this.ref = null;
                return r;
            }
        };
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof BytesReference) {
            BytesReference otherRef = (BytesReference)other;
            if (this.length() != otherRef.length()) {
                return false;
            }
            return AbstractBytesReference.compareIterators(this, otherRef, (a, b) -> a.bytesEquals(b) ? 0 : 1) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == null) {
            BytesRefIterator iterator = this.iterator();
            int result = 1;
            try {
                BytesRef ref;
                while ((ref = iterator.next()) != null) {
                    for (int i = 0; i < ref.length; ++i) {
                        result = 31 * result + ref.bytes[ref.offset + i];
                    }
                }
            }
            catch (IOException ex) {
                throw new AssertionError("wont happen", ex);
            }
            this.hash = result;
            return this.hash;
        }
        return this.hash;
    }

    @Override
    public int compareTo(BytesReference other) {
        return AbstractBytesReference.compareIterators(this, other, BytesRef::compareTo);
    }

    private static int compareIterators(BytesReference a, BytesReference b, ToIntBiFunction<BytesRef, BytesRef> f) {
        try {
            long lengthToCompare = Math.min(a.length(), b.length());
            BytesRefIterator aIter = a.iterator();
            BytesRefIterator bIter = b.iterator();
            BytesRef aRef = aIter.next();
            BytesRef bRef = bIter.next();
            if (aRef != null && bRef != null) {
                aRef = aRef.clone();
                bRef = bRef.clone();
                if (aRef.length == a.length() && bRef.length == b.length()) {
                    return f.applyAsInt(aRef, bRef);
                }
                int i = 0;
                while ((long)i < lengthToCompare) {
                    int length;
                    if (aRef.length == 0) {
                        aRef = aIter.next().clone();
                    }
                    if (bRef.length == 0) {
                        bRef = bIter.next().clone();
                    }
                    int aLength = aRef.length;
                    int bLength = bRef.length;
                    aRef.length = bRef.length = (length = Math.min(aLength, bLength));
                    int diff = f.applyAsInt(aRef, bRef);
                    aRef.length = aLength;
                    bRef.length = bLength;
                    if (diff != 0) {
                        return diff;
                    }
                    AbstractBytesReference.advance(aRef, length);
                    AbstractBytesReference.advance(bRef, length);
                    i += length;
                }
            }
            return a.length() - b.length();
        }
        catch (IOException ex) {
            throw new AssertionError("can not happen", ex);
        }
    }

    private static void advance(BytesRef ref, int length) {
        assert (ref.length >= length) : " ref.length: " + ref.length + " length: " + length;
        assert (ref.offset + length < ref.bytes.length || ref.offset + length == ref.bytes.length && ref.length - length == 0) : "offset: " + ref.offset + " ref.bytes.length: " + ref.bytes.length + " length: " + length + " ref.length: " + ref.length;
        ref.length -= length;
        ref.offset += length;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        BytesRef bytes = this.toBytesRef();
        return builder.value(bytes.bytes, bytes.offset, bytes.length);
    }
}

