/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.lookup.Lookupable;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiLookupAction;
import org.kuali.rice.kns.web.struts.action.KualiTableRenderAction;
import org.kuali.rice.kns.web.struts.form.MultipleValueLookupForm;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

@Deprecated
public class KualiMultipleValueLookupAction
extends KualiLookupAction
implements KualiTableRenderAction {
    private static final Logger LOG = LogManager.getLogger(KualiMultipleValueLookupAction.class);
    public static final int DEFAULT_MAX_ROWS_PER_PAGE = 50;

    @Override
    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Lookupable kualiLookupable;
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        String methodToCall = this.findMethodToCall(form, request);
        if (methodToCall.equalsIgnoreCase("search")) {
            GlobalVariables.getUserSession().removeObjectsByPrefix("search");
        }
        if ((kualiLookupable = multipleValueLookupForm.getLookupable()) == null) {
            LOG.error("Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        Collection displayList = new ArrayList();
        ArrayList<ResultRow> resultTable = new ArrayList<ResultRow>();
        kualiLookupable.validateSearchParameters(multipleValueLookupForm.getFields());
        boolean bounded = true;
        displayList = this.performMultipleValueLookup(multipleValueLookupForm, resultTable, this.getMaxRowsPerPage(multipleValueLookupForm), bounded);
        if (kualiLookupable.isSearchUsingOnlyPrimaryKeyValues()) {
            multipleValueLookupForm.setSearchUsingOnlyPrimaryKeyValues(true);
            multipleValueLookupForm.setPrimaryKeyFieldLabels(kualiLookupable.getPrimaryKeyFieldLabels());
        } else {
            multipleValueLookupForm.setSearchUsingOnlyPrimaryKeyValues(false);
            multipleValueLookupForm.setPrimaryKeyFieldLabels("");
        }
        request.setAttribute("reqSearchResultsActualSizeKnown", (Object)kualiLookupable.getSearchResultsActualSizeKnown());
        if (displayList instanceof CollectionIncomplete) {
            request.setAttribute("reqSearchResultsActualSize", (Object)((CollectionIncomplete)displayList).getActualSizeIfTruncated());
        } else {
            request.setAttribute("reqSearchResultsActualSize", (Object)displayList.size());
        }
        request.setAttribute("reqSearchResults", resultTable);
        if (displayList instanceof CollectionIncomplete) {
            multipleValueLookupForm.setResultsActualSize((int)((CollectionIncomplete)displayList).getActualSizeIfTruncated().longValue());
        } else {
            multipleValueLookupForm.setResultsActualSize(displayList.size());
        }
        multipleValueLookupForm.setResultsLimitedSize(resultTable.size());
        if (request.getParameter("searchResultKey") != null) {
            GlobalVariables.getUserSession().removeObject(request.getParameter("searchResultKey"));
        }
        request.setAttribute("searchResultKey", (Object)GlobalVariables.getUserSession().addObjectWithGeneratedKey(resultTable, "searchResults"));
        request.getParameter("refreshCaller");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward switchToPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.switchToPage(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.sort(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    public ActionForward prepareToReturnSelectedResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        if (StringUtils.isBlank((String)multipleValueLookupForm.getLookupResultsSequenceNumber())) {
            return this.prepareToReturnNone(mapping, form, request, response);
        }
        this.prepareToReturnSelectedResultBOs(multipleValueLookupForm);
        Properties parameters = new Properties();
        parameters.put("lookupResultsBOClassName", multipleValueLookupForm.getBusinessObjectClassName());
        parameters.put("lookupResultsSequenceNumber", multipleValueLookupForm.getLookupResultsSequenceNumber());
        parameters.put("docFormKey", multipleValueLookupForm.getFormKey());
        parameters.put("methodToCall", "refresh");
        parameters.put("refreshCaller", "multipleValues");
        parameters.put("anchor", multipleValueLookupForm.getLookupAnchor());
        parameters.put("lookedUpCollectionName", multipleValueLookupForm.getLookedUpCollectionName());
        if (multipleValueLookupForm.getDocNum() != null) {
            parameters.put("docNum", multipleValueLookupForm.getDocNum());
        }
        String backUrl = UrlFactory.parameterizeUrl((String)multipleValueLookupForm.getBackLocation(), (Properties)parameters);
        return new ActionForward(backUrl, true);
    }

    public ActionForward selectAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.selectAll(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    public ActionForward unselectAll(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.unselectAll(multipleValueLookupForm, this.getMaxRowsPerPage(multipleValueLookupForm));
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.prepareToReturnNone(mapping, form, request, response);
    }

    public ActionForward prepareToReturnNone(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        this.prepareToReturnNone(multipleValueLookupForm);
        Properties parameters = new Properties();
        parameters.put("docFormKey", multipleValueLookupForm.getFormKey());
        parameters.put("methodToCall", "refresh");
        parameters.put("refreshCaller", "multipleValues");
        parameters.put("anchor", multipleValueLookupForm.getLookupAnchor());
        if (multipleValueLookupForm.getDocNum() != null) {
            parameters.put("docNum", multipleValueLookupForm.getDocNum());
        }
        String backUrl = UrlFactory.parameterizeUrl((String)multipleValueLookupForm.getBackLocation(), (Properties)parameters);
        return new ActionForward(backUrl, true);
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        List<ResultRow> resultTable = this.prepareToExport(multipleValueLookupForm);
        request.setAttribute("reqSearchResults", resultTable);
        return mapping.findForward("basic");
    }

    protected Collection performMultipleValueLookup(MultipleValueLookupForm multipleValueLookupForm, List<ResultRow> resultTable, int maxRowsPerPage, boolean bounded) {
        Lookupable lookupable = multipleValueLookupForm.getLookupable();
        Collection<? extends BusinessObject> displayList = lookupable.performLookup(multipleValueLookupForm, resultTable, bounded);
        List<String> defaultSortColumns = lookupable.getDefaultSortColumns();
        if (defaultSortColumns != null && !defaultSortColumns.isEmpty() && resultTable != null && !resultTable.isEmpty()) {
            String firstSortColumn = defaultSortColumns.get(0);
            int firstSortColumnIdx = -1;
            List<Column> columnsForFirstResultRow = resultTable.get(0).getColumns();
            for (int i = 0; i < columnsForFirstResultRow.size(); ++i) {
                if (!StringUtils.equals((String)firstSortColumn, (String)columnsForFirstResultRow.get(i).getPropertyName())) continue;
                firstSortColumnIdx = i;
                break;
            }
            multipleValueLookupForm.setColumnToSortIndex(firstSortColumnIdx);
        } else {
            multipleValueLookupForm.setColumnToSortIndex(-1);
        }
        multipleValueLookupForm.jumpToFirstPage(resultTable.size(), maxRowsPerPage);
        SequenceAccessorService sas = KNSServiceLocator.getSequenceAccessorService();
        Long nextSeq = sas.getNextAvailableSequenceNumber("KRNS_LOOKUP_RSLT_S");
        String lookupResultsSequenceNumber = nextSeq.toString();
        multipleValueLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            lookupResultsService.persistResultsTable(lookupResultsSequenceNumber, resultTable, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to persist multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to persist multiple lookup results", e);
        }
        multipleValueLookupForm.setCompositeObjectIdMap(new HashMap<String, String>());
        return displayList;
    }

    protected List<ResultRow> switchToPage(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            resultTable = KNSServiceLocator.getLookupResultsService().retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to retrieve multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to retrieve multiple lookup results", e);
        }
        multipleValueLookupForm.jumpToPage(multipleValueLookupForm.getSwitchToPageNumber(), resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setColumnToSortIndex(Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex()));
        Map<String, String> selectedIds = LookupUtils.generateCompositeSelectedObjectIds(multipleValueLookupForm.getPreviouslySelectedObjectIdSet(), multipleValueLookupForm.getDisplayedObjectIdSet(), multipleValueLookupForm.getSelectedObjectIdSet());
        multipleValueLookupForm.setCompositeObjectIdMap(selectedIds);
        for (ResultRow row : resultTable) {
            String objId = row.getObjectId();
            for (Map.Entry<String, String> entry : selectedIds.entrySet()) {
                String selectedId = entry.getValue();
                if (!objId.equalsIgnoreCase(selectedId)) continue;
                HtmlData.InputHtmlData returnUrl = (HtmlData.InputHtmlData)row.getReturnUrlHtmlData();
                returnUrl.setChecked("checked");
                row.setReturnUrl(returnUrl.constructCompleteHtmlTag());
            }
        }
        return resultTable;
    }

    protected List<ResultRow> sort(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
        List<ResultRow> resultTable = null;
        try {
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to retrieve multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to retrieve multiple lookup results", e);
        }
        int columnToSortOn = multipleValueLookupForm.getColumnToSortIndex();
        int columnCurrentlySortedOn = Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex());
        if (columnToSortOn == columnCurrentlySortedOn) {
            Collections.reverse(resultTable);
        } else {
            Collections.sort(resultTable, new BeanComparator("columns[" + columnToSortOn + "].propertyValue", LookupUtils.findBestValueComparatorForColumn(resultTable, columnToSortOn)));
        }
        try {
            lookupResultsService.persistResultsTable(lookupResultsSequenceNumber, resultTable, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to persist multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to persist multiple lookup results", e);
        }
        multipleValueLookupForm.jumpToFirstPage(resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setCompositeObjectIdMap(LookupUtils.generateCompositeSelectedObjectIds(multipleValueLookupForm.getPreviouslySelectedObjectIdSet(), multipleValueLookupForm.getDisplayedObjectIdSet(), multipleValueLookupForm.getSelectedObjectIdSet()));
        return resultTable;
    }

    protected void prepareToReturnSelectedResultBOs(MultipleValueLookupForm multipleValueLookupForm) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        if (StringUtils.isBlank((String)lookupResultsSequenceNumber)) {
            return;
        }
        Map<String, String> compositeObjectIdMap = LookupUtils.generateCompositeSelectedObjectIds(multipleValueLookupForm.getPreviouslySelectedObjectIdSet(), multipleValueLookupForm.getDisplayedObjectIdSet(), multipleValueLookupForm.getSelectedObjectIdSet());
        Set<String> compositeObjectIds = compositeObjectIdMap.keySet();
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            lookupResultsService.persistSelectedObjectIds(lookupResultsSequenceNumber, compositeObjectIds, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to retrieve selected multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to retrieve selected multiple lookup results", e);
        }
    }

    protected void prepareToReturnNone(MultipleValueLookupForm multipleValueLookupForm) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        try {
            if (StringUtils.isNotBlank((String)lookupResultsSequenceNumber)) {
                LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
                lookupResultsService.clearPersistedLookupResults(lookupResultsSequenceNumber);
                multipleValueLookupForm.setLookupResultsSequenceNumber(null);
            }
        }
        catch (Exception e) {
            LOG.error("error occurred trying to clear lookup results seq nbr " + lookupResultsSequenceNumber, (Throwable)e);
        }
    }

    protected List<ResultRow> prepareToExport(MultipleValueLookupForm multipleValueLookupForm) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to export multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to export multiple lookup results", e);
        }
        return resultTable;
    }

    protected List<ResultRow> selectAll(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to export multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to export multiple lookup results", e);
        }
        HashMap<String, String> selectedObjectIds = new HashMap<String, String>();
        for (ResultRow row : resultTable) {
            String objId = row.getObjectId();
            HtmlData.InputHtmlData returnUrl = (HtmlData.InputHtmlData)row.getReturnUrlHtmlData();
            returnUrl.setChecked("checked");
            row.setReturnUrl(returnUrl.constructCompleteHtmlTag());
            if (objId == null) continue;
            selectedObjectIds.put(objId, objId);
        }
        multipleValueLookupForm.jumpToPage(multipleValueLookupForm.getViewedPageNumber(), resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setColumnToSortIndex(Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex()));
        multipleValueLookupForm.setCompositeObjectIdMap(selectedObjectIds);
        return resultTable;
    }

    @Override
    public ActionForward clearValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MultipleValueLookupForm multipleValueLookupForm = (MultipleValueLookupForm)form;
        this.prepareToReturnNone(multipleValueLookupForm);
        return super.clearValues(mapping, form, request, response);
    }

    protected List<ResultRow> unselectAll(MultipleValueLookupForm multipleValueLookupForm, int maxRowsPerPage) {
        String lookupResultsSequenceNumber = multipleValueLookupForm.getLookupResultsSequenceNumber();
        List<ResultRow> resultTable = null;
        try {
            LookupResultsService lookupResultsService = KNSServiceLocator.getLookupResultsService();
            resultTable = lookupResultsService.retrieveResultsTable(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        }
        catch (Exception e) {
            LOG.error("error occurred trying to export multiple lookup results", (Throwable)e);
            throw new RuntimeException("error occurred trying to export multiple lookup results", e);
        }
        HashMap<String, String> selectedObjectIds = new HashMap<String, String>();
        multipleValueLookupForm.jumpToPage(multipleValueLookupForm.getViewedPageNumber(), resultTable.size(), maxRowsPerPage);
        multipleValueLookupForm.setColumnToSortIndex(Integer.parseInt(multipleValueLookupForm.getPreviouslySortedColumnIndex()));
        multipleValueLookupForm.setCompositeObjectIdMap(selectedObjectIds);
        return resultTable;
    }

    protected int getMaxRowsPerPage(MultipleValueLookupForm multipleValueLookupForm) {
        Integer appMaxRowsPerPage = LookupUtils.getApplicationMaximumSearchResulsPerPageForMultipleValueLookups();
        if (appMaxRowsPerPage == null) {
            LOG.warn("Couldn't find application results per page for MV lookups.  Using default of 50");
            appMaxRowsPerPage = new Integer(50);
        }
        return appMaxRowsPerPage;
    }
}

