/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.displaytag.Messages;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.export.ExportView;
import org.displaytag.model.TableModel;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExportViewFactory {
    private static ExportViewFactory instance;
    private static Logger log;
    private final Map<MediaTypeEnum, Class<ExportView>> viewClasses = new HashMap<MediaTypeEnum, Class<ExportView>>();

    private ExportViewFactory() {
        TableProperties properties = TableProperties.getInstance(null);
        String[] exportTypes = properties.getExportTypes();
        if (log.isInfoEnabled()) {
            log.info(Messages.getString("ExportViewFactory.initializing", new Object[]{ArrayUtils.toString((Object)exportTypes)}));
        }
        for (String exportType : exportTypes) {
            String className = properties.getExportClass(exportType);
            this.registerExportView(exportType, className);
        }
    }

    public static synchronized ExportViewFactory getInstance() {
        if (instance == null) {
            instance = new ExportViewFactory();
        }
        return instance;
    }

    public void registerExportView(String name, String viewClassName) {
        Class<?> exportClass;
        try {
            exportClass = ReflectHelper.classForName(viewClassName);
        }
        catch (ClassNotFoundException e) {
            log.error(Messages.getString("ExportViewFactory.classnotfound", new Object[]{name, viewClassName}));
            return;
        }
        catch (NoClassDefFoundError e) {
            log.warn(Messages.getString("ExportViewFactory.noclassdef", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        try {
            exportClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error(Messages.getString("ExportViewFactory.instantiationexception", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        catch (IllegalAccessException e) {
            log.error(Messages.getString("ExportViewFactory.illegalaccess", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        catch (NoClassDefFoundError e) {
            log.warn(Messages.getString("ExportViewFactory.noclassdef", new Object[]{name, viewClassName, e.getMessage()}));
            return;
        }
        MediaTypeEnum media = MediaTypeEnum.registerMediaType(name);
        this.viewClasses.put(media, exportClass);
        if (log.isDebugEnabled()) {
            log.debug(Messages.getString("ExportViewFactory.added", new Object[]{media, viewClassName}));
        }
    }

    public ExportView getView(MediaTypeEnum exportType, TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        ExportView view;
        Class<ExportView> viewClass = this.viewClasses.get(exportType);
        try {
            view = viewClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new WrappedRuntimeException(this.getClass(), (Throwable)e);
        }
        view.setParameters(tableModel, exportFullList, includeHeader, decorateValues);
        return view;
    }

    static {
        log = LoggerFactory.getLogger(ExportViewFactory.class);
    }
}

