/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils2.NestedNullException;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.displaytag.exception.ObjectLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LookupUtil {
    private static Logger log = LoggerFactory.getLogger(LookupUtil.class);
    private static final char INDEXED_DELIM = '[';
    private static final char INDEXED_DELIM2 = ']';
    private static final char MAPPED_DELIM = '(';
    private static final char MAPPED_DELIM2 = ')';
    private static final char NESTED_DELIM = '.';

    private LookupUtil() {
    }

    public static Object getBeanValue(PageContext pageContext, String beanAndPropertyName, int scope) throws ObjectLookupException {
        if (beanAndPropertyName.indexOf(46) != -1) {
            Object beanObject;
            String objectName = StringUtils.substringBefore((String)beanAndPropertyName, (String)".");
            String beanProperty = StringUtils.substringAfter((String)beanAndPropertyName, (String)".");
            if (log.isDebugEnabled()) {
                log.debug("getBeanValue - bean: {}, property: {}", (Object)objectName, (Object)beanProperty);
            }
            if ((beanObject = pageContext.getAttribute(objectName, scope)) == null) {
                return null;
            }
            return LookupUtil.getBeanProperty(beanObject, beanProperty);
        }
        if (log.isDebugEnabled()) {
            log.debug("getBeanValue - bean: {}", (Object)beanAndPropertyName);
        }
        return pageContext.getAttribute(beanAndPropertyName, scope);
    }

    public static Object getBeanProperty(Object bean, String name) throws ObjectLookupException {
        Validate.notNull((Object)bean, (String)"No bean specified", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"No name specified", (Object[])new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("getProperty [{}] on bean {}", (Object)name, bean);
        }
        try {
            return LookupUtil.getProperty(bean, name);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ObjectLookupException(LookupUtil.class, bean, name, e);
        }
        catch (NestedNullException nne) {
            return null;
        }
        catch (IllegalArgumentException e) {
            log.debug("Caught IllegalArgumentException from beanutils while looking up " + name + " in bean " + String.valueOf(bean), (Throwable)e);
            return null;
        }
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug("getProperty [{}] on bean {}", (Object)name, bean);
        }
        Validate.notNull((Object)bean, (String)"No bean specified", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"No name specified", (Object[])new Object[0]);
        Object evalBean = bean;
        String evalName = name;
        int indexOfINDEXEDDELIM = -1;
        int indexOfMAPPEDDELIM = -1;
        int indexOfMAPPEDDELIM2 = -1;
        int indexOfNESTEDDELIM = -1;
        while (true) {
            indexOfNESTEDDELIM = evalName.indexOf(46);
            indexOfMAPPEDDELIM = evalName.indexOf(40);
            indexOfMAPPEDDELIM2 = evalName.indexOf(41);
            indexOfNESTEDDELIM = indexOfMAPPEDDELIM2 >= 0 && indexOfMAPPEDDELIM >= 0 && (indexOfNESTEDDELIM < 0 || indexOfNESTEDDELIM > indexOfMAPPEDDELIM) ? evalName.indexOf(46, indexOfMAPPEDDELIM2) : evalName.indexOf(46);
            if (indexOfNESTEDDELIM < 0) break;
            String next = evalName.substring(0, indexOfNESTEDDELIM);
            indexOfINDEXEDDELIM = next.indexOf(91);
            indexOfMAPPEDDELIM = next.indexOf(40);
            if ((evalBean = evalBean instanceof Map ? ((Map)evalBean).get(next) : (indexOfMAPPEDDELIM >= 0 ? PropertyUtils.getMappedProperty((Object)evalBean, (String)next) : (indexOfINDEXEDDELIM >= 0 ? LookupUtil.getIndexedProperty(evalBean, next) : PropertyUtils.getSimpleProperty((Object)evalBean, (String)next)))) == null) {
                log.debug("Null property value for '{}'", (Object)evalName.substring(0, indexOfNESTEDDELIM));
                return null;
            }
            evalName = evalName.substring(indexOfNESTEDDELIM + 1);
        }
        indexOfINDEXEDDELIM = evalName.indexOf(91);
        indexOfMAPPEDDELIM = evalName.indexOf(40);
        evalBean = evalBean instanceof Map ? ((Map)evalBean).get(evalName) : (indexOfMAPPEDDELIM >= 0 ? PropertyUtils.getMappedProperty((Object)evalBean, (String)evalName) : (indexOfINDEXEDDELIM >= 0 ? LookupUtil.getIndexedProperty(evalBean, evalName) : PropertyUtils.getSimpleProperty((Object)evalBean, (String)evalName)));
        return evalBean;
    }

    public static Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Validate.notNull((Object)bean, (String)"No bean specified", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"No name specified", (Object[])new Object[0]);
        String evalName = name;
        int delim = evalName.indexOf(91);
        int delim2 = evalName.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + evalName + "'");
        }
        int index = -1;
        try {
            String subscript = evalName.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + evalName + "'");
        }
        evalName = evalName.substring(0, delim);
        if (log.isDebugEnabled()) {
            log.debug("getIndexedProperty property name={} with index {}", (Object)evalName, (Object)index);
        }
        if (StringUtils.isEmpty((CharSequence)evalName)) {
            if (bean instanceof List) {
                return ((List)bean).get(index);
            }
            if (bean.getClass().isArray()) {
                return ((Object[])bean)[index];
            }
        }
        return PropertyUtils.getIndexedProperty((Object)bean, (String)evalName, (int)index);
    }
}

