/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.RepositoryPersistor;
import org.apache.ojb.broker.metadata.torque.TableDescriptor;
import org.apache.ojb.broker.metadata.torque.TorqueTableGenerator;
import org.apache.ojb.broker.metadata.torque.TorqueTablePreprocessor;

public class TorqueRepositoryGenerator {
    private TorqueTablePreprocessor tablePreprocessor;
    private TorqueTableGenerator tableGenerator;

    public TorqueRepositoryGenerator(String string, boolean bl) throws Exception {
        RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
        DescriptorRepository descriptorRepository = repositoryPersistor.readDescriptorRepository(string);
        this.tablePreprocessor = new TorqueTablePreprocessor(descriptorRepository);
        this.tablePreprocessor.buildStandardTables();
        this.tableGenerator = new TorqueTableGenerator(descriptorRepository, bl);
    }

    public void generateTorqueRepository(String string, String string2, String string3) throws Exception {
        Iterator iterator = this.tablePreprocessor.getStandardTables().values().iterator();
        StringBuffer stringBuffer = new StringBuffer(4096);
        this.generateDatabaseHeader(string2, string3, stringBuffer);
        while (iterator.hasNext()) {
            this.tableGenerator.generateStandardTable((TableDescriptor)iterator.next(), stringBuffer, string3);
        }
        this.tableGenerator.generateMappingTables(stringBuffer, string3);
        stringBuffer.append("</database>\n");
        this.generateOutputFile(string, stringBuffer);
    }

    private void generateDatabaseHeader(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\" ?>\n");
        stringBuffer.append("<!DOCTYPE database>\n\n");
        stringBuffer.append("<database name=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" indexTablespace=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\">\n");
    }

    private void generateOutputFile(String string, StringBuffer stringBuffer) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write(stringBuffer.toString());
        fileWriter.flush();
        fileWriter.close();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length >= 4 && stringArray.length <= 5) {
            boolean bl = stringArray.length == 5 && stringArray[4].equalsIgnoreCase("true");
            TorqueRepositoryGenerator torqueRepositoryGenerator = new TorqueRepositoryGenerator(stringArray[0], bl);
            torqueRepositoryGenerator.generateTorqueRepository(stringArray[1], stringArray[2], stringArray[3]);
        } else {
            System.out.println("[TorqueRepositoryGenerator] Usage: inputFile outputFile databaseName indexTablespaceName (ignoreAutoIncrement)");
        }
    }
}

