/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actiontaken;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.Boolean01Converter;

@Entity
@Table(name="KREW_ACTN_TKN_T")
@NamedQueries(value={@NamedQuery(name="ActionTakenValue.getLastActionTakenDate", query="SELECT max(a.actionDate) from ActionTakenValue a where a.documentId = :documentId and a.actionTaken=:actionTaken")})
public class ActionTakenValue
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = -81505450567067594L;
    @Id
    @GeneratedValue(generator="KREW_ACTN_TKN_S")
    @PortableSequenceGenerator(name="KREW_ACTN_TKN_S")
    @Column(name="ACTN_TKN_ID", nullable=false)
    private String actionTakenId;
    @Column(name="DOC_HDR_ID", nullable=false)
    private String documentId;
    @Column(name="ACTN_CD", nullable=false)
    private String actionTaken;
    @Column(name="ACTN_DT", nullable=false)
    private Timestamp actionDate;
    @Column(name="ANNOTN")
    private String annotation = "";
    @Column(name="DOC_VER_NBR", nullable=false)
    private Integer docVersion;
    @Column(name="PRNCPL_ID", nullable=false)
    private String principalId;
    @Column(name="DLGTR_PRNCPL_ID")
    private String delegatorPrincipalId;
    @Column(name="DLGTR_GRP_ID")
    private String delegatorGroupId;
    @Column(name="CUR_IND")
    @Convert(converter=Boolean01Converter.class)
    private Boolean currentIndicator = Boolean.TRUE;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @OneToMany(mappedBy="actionTaken")
    private Collection<ActionRequestValue> actionRequests;
    @Transient
    private String actionDateString;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Principal getPrincipal() {
        return this.getPrincipalForId(this._persistence_get_principalId());
    }

    public String getPrincipalDisplayName() {
        return KEWServiceLocator.getIdentityHelperService().getPerson(this.getPrincipalId()).getName();
    }

    public Principal getDelegatorPrincipal() {
        return this.getPrincipalForId(this._persistence_get_delegatorPrincipalId());
    }

    public Group getDelegatorGroup() {
        return KimApiServiceLocator.getGroupService().getGroup(String.valueOf(this._persistence_get_delegatorGroupId()));
    }

    public void setDelegator(Recipient recipient) {
        if (recipient instanceof KimPrincipalRecipient) {
            this.setDelegatorPrincipalId(((KimPrincipalRecipient)recipient).getPrincipalId());
        } else if (recipient instanceof KimGroupRecipient) {
            this.setDelegatorGroupId(((KimGroupRecipient)recipient).getGroup().getId());
        } else {
            this.setDelegatorPrincipalId(null);
            this.setDelegatorGroupId(null);
        }
    }

    public boolean isForDelegator() {
        return this.getDelegatorPrincipalId() != null || this.getDelegatorGroupId() != null || this.getDelegatorRoleId() != null;
    }

    public String getDelegatorDisplayName() {
        if (this.getDelegatorPrincipalId() != null) {
            return KEWServiceLocator.getIdentityHelperService().getPerson(this.getDelegatorPrincipalId()).getName();
        }
        if (this.getDelegatorGroupId() != null) {
            return this.getDelegatorGroup().getName();
        }
        String delegatorRoleId = this.getDelegatorRoleId();
        if (delegatorRoleId != null) {
            Role role = KimApiServiceLocator.getRoleService().getRole(delegatorRoleId);
            if (role != null) {
                return role.getName();
            }
            return "";
        }
        return "";
    }

    private Principal getPrincipalForId(String principalId) {
        Principal principal = null;
        if (!StringUtils.isBlank((String)principalId)) {
            principal = KEWServiceLocator.getIdentityHelperService().getPrincipal(principalId);
        }
        return principal;
    }

    public String getActionTakenLabel() {
        return CodeTranslator.getActionTakenLabel((String)this._persistence_get_actionTaken());
    }

    public Collection<ActionRequestValue> getActionRequests() {
        if (this._persistence_get_actionRequests() == null) {
            this.setActionRequests(new ArrayList<ActionRequestValue>());
        }
        return this._persistence_get_actionRequests();
    }

    public void setActionRequests(Collection<ActionRequestValue> actionRequests) {
        this._persistence_set_actionRequests(actionRequests);
    }

    public Timestamp getActionDate() {
        return this._persistence_get_actionDate();
    }

    public void setActionDate(Timestamp actionDate) {
        this._persistence_set_actionDate(actionDate);
    }

    public String getActionTaken() {
        return this._persistence_get_actionTaken();
    }

    public void setActionTaken(String actionTaken) {
        this._persistence_set_actionTaken(actionTaken);
    }

    public String getActionTakenId() {
        return this._persistence_get_actionTakenId();
    }

    public void setActionTakenId(String actionTakenId) {
        this._persistence_set_actionTakenId(actionTakenId);
    }

    public String getAnnotation() {
        return this._persistence_get_annotation();
    }

    public void setAnnotation(String annotation) {
        this._persistence_set_annotation(annotation);
    }

    public String getDelegatorPrincipalId() {
        return this._persistence_get_delegatorPrincipalId();
    }

    public void setDelegatorPrincipalId(String delegatorPrincipalId) {
        this._persistence_set_delegatorPrincipalId(delegatorPrincipalId);
    }

    public String getDelegatorGroupId() {
        return this._persistence_get_delegatorGroupId();
    }

    public void setDelegatorGroupId(String delegatorGroupId) {
        this._persistence_set_delegatorGroupId(delegatorGroupId);
    }

    public String getDelegatorRoleId() {
        if (this._persistence_get_actionTakenId() == null) {
            return null;
        }
        ActionRequestValue actionRequest = KEWServiceLocator.getActionRequestService().getActionRequestForRole(this._persistence_get_actionTakenId());
        if (actionRequest != null) {
            return actionRequest.getRoleName();
        }
        return null;
    }

    public Integer getDocVersion() {
        return this._persistence_get_docVersion();
    }

    public void setDocVersion(Integer docVersion) {
        this._persistence_set_docVersion(docVersion);
    }

    public Integer getLockVerNbr() {
        return this._persistence_get_lockVerNbr();
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this._persistence_set_lockVerNbr(lockVerNbr);
    }

    public String getDocumentId() {
        return this._persistence_get_documentId();
    }

    public void setDocumentId(String documentId) {
        this._persistence_set_documentId(documentId);
    }

    public String getPrincipalId() {
        return this._persistence_get_principalId();
    }

    public void setPrincipalId(String principalId) {
        this._persistence_set_principalId(principalId);
    }

    public Boolean getCurrentIndicator() {
        return this._persistence_get_currentIndicator();
    }

    public void setCurrentIndicator(Boolean currentIndicator) {
        this._persistence_set_currentIndicator(currentIndicator);
    }

    public String getActionDateString() {
        if (StringUtils.isBlank((String)this.actionDateString)) {
            return RiceConstants.getDefaultDateFormat().format(this.getActionDate());
        }
        return this.actionDateString;
    }

    public void setActionDateString(String actionDateString) {
        this.actionDateString = actionDateString;
    }

    public boolean isApproval() {
        return "A".equals(this.getActionTaken());
    }

    public boolean isCompletion() {
        return "C".equals(this.getActionTaken());
    }

    public ActionTakenValue deepCopy(Map<Object, Object> visited) {
        if (visited.containsKey(this)) {
            return (ActionTakenValue)visited.get(this);
        }
        ActionTakenValue copy = new ActionTakenValue();
        visited.put(this, copy);
        copy._persistence_set_actionTakenId(this._persistence_get_actionTakenId());
        copy._persistence_set_documentId(this._persistence_get_documentId());
        copy._persistence_set_actionTaken(this._persistence_get_actionTaken());
        if (this._persistence_get_actionDate() != null) {
            copy._persistence_set_actionDate(new Timestamp(this._persistence_get_actionDate().getTime()));
        }
        copy._persistence_set_annotation(this._persistence_get_annotation());
        copy._persistence_set_docVersion(this._persistence_get_docVersion());
        copy._persistence_set_principalId(this._persistence_get_principalId());
        copy._persistence_set_delegatorPrincipalId(this._persistence_get_delegatorPrincipalId());
        copy._persistence_set_delegatorGroupId(this._persistence_get_delegatorGroupId());
        copy._persistence_set_currentIndicator(this._persistence_get_currentIndicator());
        copy._persistence_set_lockVerNbr(this._persistence_get_lockVerNbr());
        if (this._persistence_get_actionRequests() != null) {
            ArrayList<ActionRequestValue> copies = new ArrayList<ActionRequestValue>();
            for (ActionRequestValue actionRequest : this._persistence_get_actionRequests()) {
                copies.add(actionRequest.deepCopy(visited));
            }
            copy._persistence_set_actionRequests(copies);
        }
        copy.actionDateString = this.actionDateString;
        return copy;
    }

    public static ActionTaken to(ActionTakenValue actionTakenBo) {
        if (actionTakenBo == null) {
            return null;
        }
        ActionTaken.Builder builder = ActionTaken.Builder.create((String)actionTakenBo.getActionTakenId(), (String)actionTakenBo.getDocumentId(), (String)actionTakenBo.getPrincipalId(), (ActionType)ActionType.fromCode((String)actionTakenBo.getActionTaken()));
        if (actionTakenBo.getActionDate() != null) {
            builder.setActionDate(new DateTime(actionTakenBo.getActionDate().getTime()));
        }
        builder.setAnnotation(actionTakenBo.getAnnotation());
        builder.setCurrent(actionTakenBo.getCurrentIndicator().booleanValue());
        builder.setDelegatorGroupId(actionTakenBo.getDelegatorGroupId());
        builder.setDelegatorPrincipalId(actionTakenBo.getDelegatorPrincipalId());
        return builder.build();
    }

    public boolean isSuperUserAction() {
        return "k".equals(this._persistence_get_actionTaken()) || "f".equals(this._persistence_get_actionTaken()) || "m".equals(this._persistence_get_actionTaken()) || "v".equals(this._persistence_get_actionTaken()) || "r".equals(this._persistence_get_actionTaken()) || "z".equals(this._persistence_get_actionTaken()) || "d".equals(this._persistence_get_actionTaken()) || "c".equals(this._persistence_get_actionTaken()) || "a".equals(this._persistence_get_actionTaken());
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ActionTakenValue();
    }

    public Object _persistence_get(String string) {
        if (string == "annotation") {
            return this.annotation;
        }
        if (string == "actionRequests") {
            return this.actionRequests;
        }
        if (string == "actionTaken") {
            return this.actionTaken;
        }
        if (string == "actionTakenId") {
            return this.actionTakenId;
        }
        if (string == "currentIndicator") {
            return this.currentIndicator;
        }
        if (string == "delegatorGroupId") {
            return this.delegatorGroupId;
        }
        if (string == "principalId") {
            return this.principalId;
        }
        if (string == "documentId") {
            return this.documentId;
        }
        if (string == "lockVerNbr") {
            return this.lockVerNbr;
        }
        if (string == "delegatorPrincipalId") {
            return this.delegatorPrincipalId;
        }
        if (string == "actionDate") {
            return this.actionDate;
        }
        if (string == "docVersion") {
            return this.docVersion;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "annotation") {
            this.annotation = (String)object;
            return;
        }
        if (string == "actionRequests") {
            this.actionRequests = (Collection)object;
            return;
        }
        if (string == "actionTaken") {
            this.actionTaken = (String)object;
            return;
        }
        if (string == "actionTakenId") {
            this.actionTakenId = (String)object;
            return;
        }
        if (string == "currentIndicator") {
            this.currentIndicator = (Boolean)object;
            return;
        }
        if (string == "delegatorGroupId") {
            this.delegatorGroupId = (String)object;
            return;
        }
        if (string == "principalId") {
            this.principalId = (String)object;
            return;
        }
        if (string == "documentId") {
            this.documentId = (String)object;
            return;
        }
        if (string == "lockVerNbr") {
            this.lockVerNbr = (Integer)object;
            return;
        }
        if (string == "delegatorPrincipalId") {
            this.delegatorPrincipalId = (String)object;
            return;
        }
        if (string == "actionDate") {
            this.actionDate = (Timestamp)object;
            return;
        }
        if (string == "docVersion") {
            this.docVersion = (Integer)object;
            return;
        }
    }

    public String _persistence_get_annotation() {
        this._persistence_checkFetched("annotation");
        return this.annotation;
    }

    public void _persistence_set_annotation(String string) {
        this._persistence_checkFetchedForSet("annotation");
        this._persistence_propertyChange("annotation", this.annotation, string);
        this.annotation = string;
    }

    public Collection _persistence_get_actionRequests() {
        this._persistence_checkFetched("actionRequests");
        return this.actionRequests;
    }

    public void _persistence_set_actionRequests(Collection collection) {
        this._persistence_checkFetchedForSet("actionRequests");
        this._persistence_propertyChange("actionRequests", this.actionRequests, collection);
        this.actionRequests = collection;
    }

    public String _persistence_get_actionTaken() {
        this._persistence_checkFetched("actionTaken");
        return this.actionTaken;
    }

    public void _persistence_set_actionTaken(String string) {
        this._persistence_checkFetchedForSet("actionTaken");
        this._persistence_propertyChange("actionTaken", this.actionTaken, string);
        this.actionTaken = string;
    }

    public String _persistence_get_actionTakenId() {
        this._persistence_checkFetched("actionTakenId");
        return this.actionTakenId;
    }

    public void _persistence_set_actionTakenId(String string) {
        this._persistence_checkFetchedForSet("actionTakenId");
        this._persistence_propertyChange("actionTakenId", this.actionTakenId, string);
        this.actionTakenId = string;
    }

    public Boolean _persistence_get_currentIndicator() {
        this._persistence_checkFetched("currentIndicator");
        return this.currentIndicator;
    }

    public void _persistence_set_currentIndicator(Boolean bl) {
        this._persistence_checkFetchedForSet("currentIndicator");
        this._persistence_propertyChange("currentIndicator", this.currentIndicator, bl);
        this.currentIndicator = bl;
    }

    public String _persistence_get_delegatorGroupId() {
        this._persistence_checkFetched("delegatorGroupId");
        return this.delegatorGroupId;
    }

    public void _persistence_set_delegatorGroupId(String string) {
        this._persistence_checkFetchedForSet("delegatorGroupId");
        this._persistence_propertyChange("delegatorGroupId", this.delegatorGroupId, string);
        this.delegatorGroupId = string;
    }

    public String _persistence_get_principalId() {
        this._persistence_checkFetched("principalId");
        return this.principalId;
    }

    public void _persistence_set_principalId(String string) {
        this._persistence_checkFetchedForSet("principalId");
        this._persistence_propertyChange("principalId", this.principalId, string);
        this.principalId = string;
    }

    public String _persistence_get_documentId() {
        this._persistence_checkFetched("documentId");
        return this.documentId;
    }

    public void _persistence_set_documentId(String string) {
        this._persistence_checkFetchedForSet("documentId");
        this._persistence_propertyChange("documentId", this.documentId, string);
        this.documentId = string;
    }

    public Integer _persistence_get_lockVerNbr() {
        this._persistence_checkFetched("lockVerNbr");
        return this.lockVerNbr;
    }

    public void _persistence_set_lockVerNbr(Integer n) {
        this._persistence_checkFetchedForSet("lockVerNbr");
        this._persistence_propertyChange("lockVerNbr", this.lockVerNbr, n);
        this.lockVerNbr = n;
    }

    public String _persistence_get_delegatorPrincipalId() {
        this._persistence_checkFetched("delegatorPrincipalId");
        return this.delegatorPrincipalId;
    }

    public void _persistence_set_delegatorPrincipalId(String string) {
        this._persistence_checkFetchedForSet("delegatorPrincipalId");
        this._persistence_propertyChange("delegatorPrincipalId", this.delegatorPrincipalId, string);
        this.delegatorPrincipalId = string;
    }

    public Timestamp _persistence_get_actionDate() {
        this._persistence_checkFetched("actionDate");
        return this.actionDate;
    }

    public void _persistence_set_actionDate(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("actionDate");
        this._persistence_propertyChange("actionDate", this.actionDate, timestamp);
        this.actionDate = timestamp;
    }

    public Integer _persistence_get_docVersion() {
        this._persistence_checkFetched("docVersion");
        return this.docVersion;
    }

    public void _persistence_set_docVersion(Integer n) {
        this._persistence_checkFetchedForSet("docVersion");
        this._persistence_propertyChange("docVersion", this.docVersion, n);
        this.docVersion = n;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

