/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.kuali.rice.core.api.impex.xml.XmlConstants;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimTypeAttribute;

public class GroupXmlParser {
    private static final Logger LOG = LogManager.getLogger(GroupXmlParser.class);
    private static final boolean DEFAULT_ACTIVE_VALUE = true;
    private static final String DEFAULT_GROUP_DESCRIPTION = "";
    private HashMap<String, List<String>> memberGroupIds = new HashMap();
    private HashMap<String, List<String>> memberGroupNames = new HashMap();
    private HashMap<String, List<String>> memberPrincipalIds = new HashMap();
    private Map<String, String> groupAttributes = new HashMap<String, String>();

    public List<Group> parseGroups(InputStream input) throws IOException, XmlException {
        try {
            Document doc = XmlHelper.trimSAXXml((InputStream)input);
            Element root = doc.getRootElement();
            return this.parseGroups(root);
        }
        catch (JDOMException e) {
            throw new XmlException("Parse error.", (Throwable)e);
        }
    }

    public List<Group> parseGroups(Element element) throws XmlException {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Element groupsElement : element.getChildren("groups", XmlConstants.GROUP_NAMESPACE)) {
            for (Element groupElement : groupsElement.getChildren("group", XmlConstants.GROUP_NAMESPACE)) {
                groups.add(this.parseGroup(groupElement));
            }
        }
        for (Group group : groups) {
            String key;
            GroupService groupService = KimApiServiceLocator.getGroupService();
            Group foundGroup = groupService.getGroupByNamespaceCodeAndName(group.getNamespaceCode(), group.getName());
            if (foundGroup == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Group named '" + group.getName() + "' not found, creating new group named '" + group.getName() + "'");
                }
                try {
                    Group newGroup = groupService.createGroup(group);
                    key = newGroup.getNamespaceCode().trim() + ":" + newGroup.getName().trim();
                    this.addGroupMembers(newGroup, key);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error creating group with name '" + group.getName() + "'", e);
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Group named '" + group.getName() + "' found, creating a new version");
            }
            try {
                Group.Builder builder = Group.Builder.create((GroupContract)foundGroup);
                builder.setActive(group.isActive());
                builder.setDescription(group.getDescription());
                builder.setKimTypeId(group.getKimTypeId());
                group = builder.build();
                groupService.updateGroup(foundGroup.getId(), group);
                groupService.removeAllMembers(foundGroup.getId());
                key = group.getNamespaceCode().trim() + ":" + group.getName().trim();
                this.addGroupMembers(group, key);
            }
            catch (Exception e) {
                throw new RuntimeException("Error updating group.", e);
            }
        }
        return groups;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Group parseGroup(Element element) throws XmlException {
        void var12_18;
        String active;
        String description;
        String typeId = null;
        List kimTypeAttributes = new ArrayList();
        if (element.getChild("type", XmlConstants.GROUP_NAMESPACE) != null) {
            Element typeElement = element.getChild("type", XmlConstants.GROUP_NAMESPACE);
            String typeNamespace = typeElement.getChildText("namespace", XmlConstants.GROUP_NAMESPACE);
            String typeName = typeElement.getChildText("name", XmlConstants.GROUP_NAMESPACE);
            kimTypeInfo = KimApiServiceLocator.getKimTypeInfoService().findKimTypeByNameAndNamespace(typeNamespace, typeName);
            if (kimTypeInfo == null) throw new XmlException("Invalid type name and namespace specified.");
            typeId = kimTypeInfo.getId();
            kimTypeAttributes = kimTypeInfo.getAttributeDefinitions();
        } else {
            kimTypeInfo = KimApiServiceLocator.getKimTypeInfoService().findKimTypeByNameAndNamespace("KUALI", "Default");
            if (kimTypeInfo == null) throw new RuntimeException("Failed to locate the 'Default' group type!  Please ensure that it's in your database.");
            typeId = kimTypeInfo.getId();
            kimTypeAttributes = kimTypeInfo.getAttributeDefinitions();
        }
        String groupNamespace = element.getChildText("namespace", XmlConstants.GROUP_NAMESPACE);
        if (groupNamespace == null) {
            throw new XmlException("Namespace must have a value.");
        }
        String groupName = element.getChildText("name", XmlConstants.GROUP_NAMESPACE);
        if (groupName == null) {
            throw new XmlException("Name must have a value.");
        }
        Group.Builder groupInfo = Group.Builder.create((String)groupNamespace, (String)groupName, (String)typeId);
        IdentityService identityService = KimApiServiceLocator.getIdentityService();
        String id = element.getChildText("id", XmlConstants.GROUP_NAMESPACE);
        if (id != null) {
            groupInfo.setId(id.trim());
        }
        if ((description = element.getChildText("description", XmlConstants.GROUP_NAMESPACE)) != null && !description.trim().equals(DEFAULT_GROUP_DESCRIPTION)) {
            groupInfo.setDescription(description);
        }
        groupInfo.setActive(true);
        if (element.getChildText("active", XmlConstants.GROUP_NAMESPACE) != null && ((active = element.getChildText("active", XmlConstants.GROUP_NAMESPACE).trim()).toUpperCase().equals("N") || active.toUpperCase().equals("FALSE"))) {
            groupInfo.setActive(false);
        }
        ArrayList<String> validAttributeKeys = new ArrayList<String>();
        for (KimTypeAttribute attribute : kimTypeAttributes) {
            validAttributeKeys.add(attribute.getKimAttribute().getAttributeName());
        }
        if (element.getChild("attributes", XmlConstants.GROUP_NAMESPACE) != null) {
            List list = element.getChild("attributes", XmlConstants.GROUP_NAMESPACE).getChildren();
            HashMap<String, String> attrMap = new HashMap<String, String>();
            for (Element attr : list) {
                attrMap.put(attr.getAttributeValue("key"), attr.getAttributeValue("value"));
                if (validAttributeKeys.contains(attr.getAttributeValue("key"))) continue;
                throw new XmlException("Invalid attribute specified.");
            }
            HashMap<String, String> groupAttributes = attrMap;
            if (!groupAttributes.isEmpty()) {
                groupInfo.setAttributes(groupAttributes);
            }
        }
        Object var12_15 = null;
        if (element.getChild("members", XmlConstants.GROUP_NAMESPACE) == null) {
            ArrayList arrayList = new ArrayList();
        } else {
            List list = element.getChild("members", XmlConstants.GROUP_NAMESPACE).getChildren();
        }
        for (Element member : var12_18) {
            Principal principal;
            String elementName = member.getName().trim();
            if (elementName.equals("principalName")) {
                String principalName = member.getText().trim();
                principal = identityService.getPrincipalByPrincipalName(principalName);
                if (principal == null) throw new XmlException("Principal Name " + principalName + " cannot be found.");
                this.addPrincipalToGroup(groupInfo.getNamespaceCode(), groupInfo.getName(), principal.getPrincipalId());
                continue;
            }
            if (elementName.equals("principalId")) {
                String xmlPrincipalId = member.getText().trim();
                principal = identityService.getPrincipal(xmlPrincipalId);
                if (principal == null) throw new XmlException("Principal Id " + xmlPrincipalId + " cannot be found.");
                this.addPrincipalToGroup(groupInfo.getNamespaceCode(), groupInfo.getName(), principal.getPrincipalId());
                continue;
            }
            if (elementName.equals("groupId")) {
                String xmlGroupId = member.getText().trim();
                this.addGroupToGroup(groupInfo.getNamespaceCode(), groupInfo.getName(), xmlGroupId);
                continue;
            }
            if (elementName.equals("groupName")) {
                String xmlGroupName = member.getChildText("name", XmlConstants.GROUP_NAMESPACE).trim();
                String xmlGroupNamespace = member.getChildText("namespace", XmlConstants.GROUP_NAMESPACE).trim();
                this.addGroupNameToGroup(groupInfo.getNamespaceCode(), groupInfo.getName(), xmlGroupNamespace, xmlGroupName);
                continue;
            }
            LOG.error("Unknown member element: " + elementName);
        }
        return groupInfo.build();
    }

    private void addPrincipalToGroup(String groupNamespace, String groupName, String principalId) {
        String key = groupNamespace.trim() + ":" + groupName.trim();
        List<String> principalIds = this.memberPrincipalIds.get(key);
        if (principalIds == null) {
            principalIds = new ArrayList<String>();
        }
        principalIds.add(principalId);
        this.memberPrincipalIds.put(key, principalIds);
    }

    private void addGroupToGroup(String groupNamespace, String groupName, String groupId) {
        String key = groupNamespace.trim() + ":" + groupName.trim();
        List<String> groupIds = this.memberGroupIds.get(key);
        if (groupIds == null) {
            groupIds = new ArrayList<String>();
        }
        groupIds.add(groupId);
        this.memberGroupIds.put(key, groupIds);
    }

    private void addGroupNameToGroup(String groupNamespace, String groupName, String memberGroupNamespace, String memberGroupName) {
        String key = groupNamespace.trim() + ":" + groupName.trim();
        List<String> groupNames = this.memberGroupNames.get(key);
        if (groupNames == null) {
            groupNames = new ArrayList<String>();
        }
        groupNames.add(memberGroupNamespace.trim() + ":" + memberGroupName.trim());
        this.memberGroupNames.put(key, groupNames);
    }

    private void addGroupMembers(Group groupInfo, String key) throws XmlException {
        List<String> list;
        List<String> groupNames;
        GroupService groupService = KimApiServiceLocator.getGroupService();
        List<String> groupIds = this.memberGroupIds.get(key);
        if (groupIds != null) {
            for (String string : groupIds) {
                Group group = groupService.getGroup(string);
                if (group != null) {
                    groupService.addGroupToGroup(group.getId(), groupInfo.getId());
                    continue;
                }
                throw new XmlException("Group Id " + string + " cannot be found.");
            }
        }
        if ((groupNames = this.memberGroupNames.get(key)) != null) {
            for (String groupName : groupNames) {
                Group group = groupService.getGroupByNamespaceCodeAndName(Utilities.parseGroupNamespaceCode(groupName), Utilities.parseGroupName(groupName));
                if (group != null) {
                    groupService.addGroupToGroup(group.getId(), groupInfo.getId());
                    continue;
                }
                throw new XmlException("Group " + groupName + " cannot be found.");
            }
        }
        if ((list = this.memberPrincipalIds.get(key)) != null) {
            for (String principalId : list) {
                groupService.addPrincipalToGroup(principalId, groupInfo.getId());
            }
        }
    }
}

