/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.lock;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.impl.PessimisticLockServiceImpl;
import org.springframework.orm.jpa.JpaOptimisticLockingFailureException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class KcRicePessimisticLockServiceImpl
extends PessimisticLockServiceImpl {
    private static final Logger LOG = LogManager.getLogger(KcRicePessimisticLockServiceImpl.class);

    public void releaseAllLocksForUser(List<PessimisticLock> locks, Person user) {
        for (PessimisticLock lock : locks) {
            if (!lock.isOwnedByUser(user)) continue;
            try {
                this.delete(lock);
            }
            catch (JpaOptimisticLockingFailureException ex) {
                LOG.warn("Suppressing Optimistic Lock Exception. Document Num: " + lock.getDocumentNumber());
            }
        }
    }

    public void releaseAllLocksForUser(List<PessimisticLock> locks, Person user, String lockDescriptor) {
        for (PessimisticLock lock : locks) {
            if (!lock.isOwnedByUser(user) || !lockDescriptor.equals(lock.getLockDescriptor())) continue;
            try {
                this.delete(lock);
            }
            catch (JpaOptimisticLockingFailureException ex) {
                LOG.warn("Suppressing Optimistic Lock Exception. Document Num: " + lock.getDocumentNumber());
            }
        }
    }

    private void delete(PessimisticLock lock) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting lock: " + String.valueOf(lock));
        }
        this.dataObjectService.delete((Object)lock);
    }
}

