/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.mq.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.coeus.sys.impl.mq.rest.RestDestinationRegistry;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component(value="projectMessageConsumer")
public class ProjectMessageConsumer {
    private static Logger LOG = LogManager.getLogger(ProjectMessageConsumer.class);
    @Autowired
    @Qualifier(value="restDestinationRegistry")
    private RestDestinationRegistry restDestinationRegistry;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations consumerRestOperations;
    @Autowired
    @Qualifier(value="jwtService")
    private JwtService jwtService;

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="${amqp.project.queue}", durable="true"), exchange=@Exchange(value="${amqp.project.exchange}", type="topic", ignoreDeclarationExceptions="true"), key={"${amqp.project.routing.key}"})})
    public void onMessage(Project project) {
        String projectJson;
        if (!this.restDestinationRegistry.isEnabled("amqp.project.consumer")) {
            LOG.debug("Not pushing message " + String.valueOf(project));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Consuming Message " + String.valueOf(project));
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            objectMapper.setDateFormat((DateFormat)format);
            projectJson = objectMapper.writeValueAsString((Object)project);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isBlank((CharSequence)projectJson)) {
            throw new IllegalStateException("Project json is empty!: " + String.valueOf(project));
        }
        String url = this.restDestinationRegistry.findUrl("coi.projects");
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalStateException("url not found for destination coi.projects");
        }
        Map<String, List<String>> params = Collections.emptyMap();
        HttpHeaders headers = new HttpHeaders();
        headers.put("Content-Type", Collections.singletonList("application/json"));
        headers.put("Authorization", Collections.singletonList("Bearer " + this.getJwtService().createToken()));
        HttpEntity entity = StringUtils.isNotBlank((CharSequence)projectJson) ? new HttpEntity((Object)projectJson, (MultiValueMap)headers) : HttpEntity.EMPTY;
        this.makeCall(url, params, entity, HttpMethod.POST);
    }

    protected void makeCall(String url, Map<String, List<String>> params, HttpEntity<?> entity, HttpMethod method) {
        try {
            ResponseEntity response = this.consumerRestOperations.exchange(url, method, entity, Void.class, params);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.createSentMsg(url, params, entity, method) + " status code " + String.valueOf(response.getStatusCode()));
            }
        }
        catch (UnknownHttpStatusCodeException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(this.createSentMsg(url, params, entity, method) + " status code " + e.getRawStatusCode());
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(this.createSentMsg(url, params, entity, method) + " in error " + e.getMessage());
            }
            throw e;
        }
    }

    protected String createSentMsg(String url, Map<String, List<String>> params, HttpEntity<?> entity, HttpMethod method) {
        return "REST request sent for url: " + url + " method " + String.valueOf(method) + " body " + String.valueOf(entity) + " parameters " + String.valueOf(params);
    }

    public RestDestinationRegistry getRestDestinationRegistry() {
        return this.restDestinationRegistry;
    }

    public void setRestDestinationRegistry(RestDestinationRegistry restDestinationRegistry) {
        this.restDestinationRegistry = restDestinationRegistry;
    }

    public RestOperations getConsumerRestOperations() {
        return this.consumerRestOperations;
    }

    public void setConsumerRestOperations(RestOperations consumerRestOperations) {
        this.consumerRestOperations = consumerRestOperations;
    }

    public JwtService getJwtService() {
        return this.jwtService;
    }

    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

