/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.Queue;
import java.util.Set;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhaseBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.RecycleUtils;

public class RenderComponentPhase
extends ViewLifecyclePhaseBase {
    private RenderComponentPhase renderParent;
    private Set<String> pendingChildren;

    @Override
    public void recycle() {
        super.recycle();
        this.renderParent = null;
        this.pendingChildren = null;
    }

    void prepareRenderPhase(RenderComponentPhase renderParent, Set<String> pendingChildren) {
        this.renderParent = renderParent;
        this.pendingChildren = pendingChildren;
    }

    @Override
    public String getViewPhase() {
        return "RENDER";
    }

    @Override
    public String getStartViewStatus() {
        return "F";
    }

    @Override
    public String getEndViewStatus() {
        return "R";
    }

    @Override
    public ViewLifecycle.LifecycleEvent getEventToNotify() {
        return null;
    }

    @Override
    protected void verifyCompleted() {
        if (this.pendingChildren != null) {
            ViewLifecycle.reportIllegalState("Render phase is not complete, children are still pending " + String.valueOf(this.pendingChildren) + "\n" + String.valueOf(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initializeSuccessors(Queue<ViewLifecyclePhase> successors) {
        if (this.renderParent == null || this.renderParent.pendingChildren == null) {
            this.trace(this.renderParent == null ? "no-parent" : "no-children");
            return;
        }
        RenderComponentPhase renderComponentPhase = this.renderParent;
        synchronized (renderComponentPhase) {
            if (!this.renderParent.pendingChildren.remove(this.getParentPath())) {
                ViewLifecycle.reportIllegalState("Render phase isn't a pending child\n" + String.valueOf(this) + "\nRender Parent: " + String.valueOf(this.renderParent));
            }
            this.trace("remove-child " + this.renderParent.getElement().getId() + " " + this.renderParent.getViewPath() + " " + this.getParentPath() + " " + String.valueOf(this.renderParent.pendingChildren));
            if (this.renderParent.pendingChildren.isEmpty()) {
                successors.add(this.renderParent);
                this.renderParent.trace("pend-rend");
                Set<String> toRecycle = this.renderParent.pendingChildren;
                this.renderParent.pendingChildren = null;
                RecycleUtils.recycle(toRecycle);
            }
        }
    }

    @Override
    protected ViewLifecyclePhase initializeSuccessor(LifecycleElement nestedElement, String nestedPath, Component parent) {
        return null;
    }
}

