/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.view.HtmlFormatter;

public class HtmlDiagramFormatter
extends HtmlFormatter {
    private static boolean printedNoDotWarning = false;
    private static boolean printedInvalidVersionWarning = false;

    protected HtmlDiagramFormatter() {
    }

    protected Dot getDot() {
        Dot dot = Dot.getInstance();
        if (!dot.exists()) {
            if (!printedNoDotWarning) {
                printedNoDotWarning = true;
                System.err.println();
                System.err.println("Warning: Failed to run dot.");
                System.err.println("   Download " + dot.getSupportedVersions());
                System.err.println("   from www.graphviz.org and make sure that dot is either in your path");
                System.err.println("   or point to where you installed Graphviz with the -gv option.");
                System.err.println("   Generated pages will not contain a diagramtic view of table relationships.");
            }
            return null;
        }
        if (!dot.isValid()) {
            if (!printedInvalidVersionWarning) {
                printedInvalidVersionWarning = true;
                System.err.println();
                System.err.println("Warning: Invalid version of Graphviz dot detected (" + String.valueOf(dot.getVersion()) + ").");
                System.err.println("   SchemaSpy requires " + dot.getSupportedVersions() + ". from www.graphviz.org.");
                System.err.println("   Generated pages will not contain a diagramatic view of table relationships.");
            }
            return null;
        }
        return dot;
    }
}

