/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.framework.engine.BasicExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.Context;
import org.kuali.rice.krms.framework.engine.ContextProvider;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.TermResolutionEngineImpl;
import org.kuali.rice.krms.framework.engine.result.TimingResult;

public class ProviderBasedEngine
implements Engine {
    private static final Term effectiveExecutionTimeTerm = new Term("effectiveExecutionTime", null);
    private static final Logger LOG = LogManager.getLogger(ProviderBasedEngine.class);
    private static final ResultLogger KLog = ResultLogger.getInstance();
    private ContextProvider contextProvider;

    public EngineResults execute(SelectionCriteria selectionCriteria, Map<String, Object> facts, ExecutionOptions executionOptions) {
        return this.execute(selectionCriteria, Facts.Builder.create().addFactsByName(facts).build(), executionOptions);
    }

    public EngineResults execute(SelectionCriteria selectionCriteria, Facts facts, ExecutionOptions executionOptions) {
        DateTime start = new DateTime();
        ExecutionEnvironment environment = this.establishExecutionEnvironment(selectionCriteria, facts.getFactMap(), executionOptions);
        Long effectiveExecutionTime = environment.getSelectionCriteria().getEffectiveExecutionTime();
        if (effectiveExecutionTime == null) {
            effectiveExecutionTime = System.currentTimeMillis();
        }
        environment.publishFact(effectiveExecutionTimeTerm, (Object)effectiveExecutionTime);
        Context context = this.selectContext(selectionCriteria, facts.getFactMap(), executionOptions);
        if (context == null) {
            LOG.info("Failed to locate a Context for the given qualifiers, skipping rule engine execution: " + String.valueOf(selectionCriteria.getContextQualifiers()));
            return null;
        }
        context.execute(environment);
        DateTime end = new DateTime();
        if (KLog.isEnabled(environment)) {
            KLog.logResult(new TimingResult("Timing Event", this, environment, start, end));
        }
        return environment.getEngineResults();
    }

    protected ExecutionEnvironment establishExecutionEnvironment(SelectionCriteria selectionCriteria, Map<Term, Object> facts, ExecutionOptions executionOptions) {
        return new BasicExecutionEnvironment(selectionCriteria, facts, executionOptions, new TermResolutionEngineImpl());
    }

    protected Context selectContext(SelectionCriteria selectionCriteria, Map<Term, Object> facts, ExecutionOptions executionOptions) {
        if (this.contextProvider == null) {
            throw new IllegalStateException("No ContextProvider was configured.");
        }
        return this.contextProvider.loadContext(selectionCriteria, facts, executionOptions);
    }

    public void setContextProvider(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }
}

