/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property.source;

import com.codiform.moo.MissingSourcePropertyException;
import com.codiform.moo.property.source.MvelSourceProperty;
import com.codiform.moo.property.source.SourceProperty;
import com.codiform.moo.property.source.SourcePropertyFactory;
import java.io.Serializable;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelSourcePropertyFactory
implements SourcePropertyFactory {
    private static final String SUPPORTED_PREFIX = "mvel";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public SourceProperty getSourceProperty(String expression) {
        try {
            return this.compileAndReturnProperty(expression);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            this.log.warn("Error while compiling expression {}", (Throwable)exception);
            return null;
        }
        catch (CompileException exception) {
            this.log.warn("Error while compiling expression {}", (Throwable)exception);
            return null;
        }
    }

    private MvelSourceProperty compileAndReturnProperty(String expression) {
        Serializable compiled = MVEL.compileExpression((String)expression);
        return new MvelSourceProperty(expression, compiled);
    }

    public SourceProperty getSourceProperty(String expressionPrefix, String unprefixedExpression) {
        try {
            return this.compileAndReturnProperty(unprefixedExpression);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            throw new MissingSourcePropertyException(expressionPrefix + ":" + unprefixedExpression, (Throwable)exception);
        }
        catch (CompileException exception) {
            throw new MissingSourcePropertyException(expressionPrefix + ":" + unprefixedExpression, (Throwable)exception);
        }
    }

    public boolean supportsPrefix(String prefix) {
        return SUPPORTED_PREFIX.equals(prefix);
    }
}

