/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils2.MappedPropertyDescriptor;
import org.apache.commons.beanutils2.PropertyUtils;
import org.displaytag.model.TableModel;

abstract class Decorator {
    private static final char CLASS_PROPERTY_SEPARATOR = '#';
    private static Map<String, Boolean> propertyMap = new ConcurrentHashMap<String, Boolean>();
    private PageContext pageContext;
    private Object decoratedObject;
    protected TableModel tableModel;

    Decorator() {
    }

    @Deprecated
    public void init(PageContext pageContext, Object decorated) {
        this.init(pageContext, decorated, null);
    }

    public void init(PageContext pageContext, Object decorated, TableModel tableModel) {
        this.pageContext = pageContext;
        this.decoratedObject = decorated;
        this.tableModel = tableModel;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public Object getDecoratedObject() {
        return this.decoratedObject;
    }

    public void finish() {
        this.pageContext = null;
        this.decoratedObject = null;
    }

    public boolean hasGetterFor(String propertyName) {
        Boolean cachedResult;
        String simpleProperty = propertyName;
        int indexOfDot = simpleProperty.indexOf(46);
        if (indexOfDot > 0) {
            simpleProperty = simpleProperty.substring(0, indexOfDot);
        }
        if ((cachedResult = propertyMap.get(this.getClass().getName() + "#" + simpleProperty)) != null) {
            return cachedResult;
        }
        boolean hasGetter = this.searchGetterFor(propertyName);
        propertyMap.put(this.getClass().getName() + "#" + simpleProperty, hasGetter);
        return hasGetter;
    }

    public boolean searchGetterFor(String propertyName) {
        boolean result = false;
        try {
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)this, (String)propertyName);
            if (pd != null) {
                result = pd instanceof MappedPropertyDescriptor ? ((MappedPropertyDescriptor)pd).getMappedReadMethod() != null : (pd instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)pd).getIndexedReadMethod() != null : pd.getReadMethod() != null);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return result;
    }
}

