/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.localization;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.displaytag.Messages;
import org.displaytag.localization.I18nResourceProvider;
import org.displaytag.localization.LocaleResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class I18nSpringAdapter
implements LocaleResolver,
I18nResourceProvider {
    public static final String UNDEFINED_KEY = "???";
    private static Logger log = LoggerFactory.getLogger(I18nSpringAdapter.class);

    @Override
    public Locale resolveLocale(PageContext pageContext) {
        return RequestContextUtils.getLocale((HttpServletRequest)((HttpServletRequest)pageContext.getRequest()));
    }

    @Override
    public String getResource(String resourceKey, String defaultValue, Tag tag, PageContext pageContext) {
        WebApplicationContext messageSource = RequestContextUtils.findWebApplicationContext((HttpServletRequest)((HttpServletRequest)pageContext.getRequest()));
        if (messageSource == null) {
            log.warn("messageSource not found");
            return null;
        }
        String key = resourceKey != null ? resourceKey : defaultValue;
        Object message = messageSource.getMessage(key, null, null, RequestContextUtils.getLocale((HttpServletRequest)((HttpServletRequest)pageContext.getRequest())));
        if (message == null && resourceKey != null) {
            log.debug(Messages.getString("Localization.missingkey", resourceKey));
            message = UNDEFINED_KEY + resourceKey + UNDEFINED_KEY;
        }
        return message;
    }
}

