/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.validator;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import org.bouncycastle.pkix.jcajce.CertPathReviewerException;
import org.bouncycastle.pkix.jcajce.PKIXCertPathReviewer;
import org.bouncycastle.pkix.util.ErrorBundle;
import org.bouncycastle.pkix.util.filter.TrustedInput;
import org.bouncycastle.pkix.util.filter.UntrustedInput;
import org.bouncycastle.util.Integers;

public class SignedMailValidator {
    private static final String RESOURCE_NAME = "org.bouncycastle.mail.smime.validator.SignedMailValidatorMessages";
    private static final Class DEFAULT_CERT_PATH_REVIEWER = PKIXCertPathReviewer.class;
    private static final int shortKeyLength = 512;
    private static final long THIRTY_YEARS_IN_MILLI_SEC = 946728000000L;
    private static final JcaX509CertSelectorConverter SELECTOR_CONVERTER = new JcaX509CertSelectorConverter();
    private static final int KU_DIGITAL_SIGNATURE = 0;
    private static final int KU_NON_REPUDIATION = 1;
    private static final Locale locale = Locale.getDefault();
    private CertStore certs;
    private SignerInformationStore signers;
    private Map results;
    private String[] fromAddresses;
    private Class certPathReviewerClass;

    public SignedMailValidator(MimeMessage mimeMessage, PKIXParameters pKIXParameters) throws SignedMailValidatorException {
        this(mimeMessage, pKIXParameters, DEFAULT_CERT_PATH_REVIEWER);
    }

    public SignedMailValidator(MimeMessage mimeMessage, PKIXParameters pKIXParameters, Class clazz) throws SignedMailValidatorException {
        this.certPathReviewerClass = clazz;
        boolean bl = DEFAULT_CERT_PATH_REVIEWER.isAssignableFrom(clazz);
        if (!bl) {
            throw new IllegalArgumentException("certPathReviewerClass is not a subclass of " + DEFAULT_CERT_PATH_REVIEWER.getName());
        }
        try {
            SMIMESigned sMIMESigned;
            Address[] addressArray;
            if (mimeMessage.isMimeType("multipart/signed")) {
                addressArray = (Address[])mimeMessage.getContent();
                sMIMESigned = new SMIMESigned((MimeMultipart)addressArray);
            } else if (mimeMessage.isMimeType("application/pkcs7-mime") || mimeMessage.isMimeType("application/x-pkcs7-mime")) {
                sMIMESigned = new SMIMESigned((Part)mimeMessage);
            } else {
                ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.noSignedMessage");
                throw new SignedMailValidatorException(errorBundle);
            }
            this.certs = new JcaCertStoreBuilder().addCertificates(sMIMESigned.getCertificates()).addCRLs(sMIMESigned.getCRLs()).setProvider("BC").build();
            this.signers = sMIMESigned.getSignerInfos();
            addressArray = mimeMessage.getFrom();
            InternetAddress internetAddress = null;
            try {
                if (mimeMessage.getHeader("Sender") != null) {
                    internetAddress = new InternetAddress(mimeMessage.getHeader("Sender")[0]);
                }
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            int n = addressArray != null ? addressArray.length : 0;
            this.fromAddresses = new String[n + (internetAddress != null ? 1 : 0)];
            for (int i = 0; i < n; ++i) {
                InternetAddress internetAddress2 = (InternetAddress)addressArray[i];
                this.fromAddresses[i] = internetAddress2.getAddress();
            }
            if (internetAddress != null) {
                this.fromAddresses[n] = internetAddress.getAddress();
            }
            this.results = new HashMap();
        }
        catch (Exception exception) {
            if (exception instanceof SignedMailValidatorException) {
                throw (SignedMailValidatorException)((Object)exception);
            }
            ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionReadingMessage", exception);
            throw new SignedMailValidatorException(errorBundle, exception);
        }
        this.validateSignatures(pKIXParameters);
    }

    protected void validateSignatures(PKIXParameters pKIXParameters) {
        JcaSimpleSignerInfoVerifierBuilder jcaSimpleSignerInfoVerifierBuilder = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC");
        this.validateSignatures(jcaSimpleSignerInfoVerifierBuilder, pKIXParameters);
    }

    protected void validateSignatures(JcaSimpleSignerInfoVerifierBuilder jcaSimpleSignerInfoVerifierBuilder, PKIXParameters pKIXParameters) {
        PKIXParameters pKIXParameters2 = (PKIXParameters)pKIXParameters.clone();
        pKIXParameters2.addCertStore(this.certs);
        Collection collection = this.signers.getSigners();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            Object object;
            Object object2;
            boolean bl;
            ErrorBundle errorBundle;
            X509CertSelector x509CertSelector;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<ErrorBundle> arrayList2 = new ArrayList<ErrorBundle>();
            SignerInformation signerInformation = (SignerInformation)iterator.next();
            X509Certificate x509Certificate = null;
            try {
                x509CertSelector = SELECTOR_CONVERTER.getCertSelector(signerInformation.getSID());
                x509Certificate = SignedMailValidator.findFirstCert(pKIXParameters2.getCertStores(), x509CertSelector, null);
            }
            catch (CertStoreException certStoreException) {
                errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionRetrievingSignerCert", certStoreException);
                arrayList.add(errorBundle);
            }
            if (x509Certificate == null) {
                x509CertSelector = SignedMailValidator.createErrorBundle("SignedMailValidator.noSignerCert");
                arrayList.add(x509CertSelector);
                this.results.put(signerInformation, new ValidationResult(null, false, arrayList, arrayList2, null));
                continue;
            }
            try {
                errorBundle = jcaSimpleSignerInfoVerifierBuilder.build(x509Certificate.getPublicKey());
                bl = SignedMailValidator.isValidSignature((SignerInformationVerifier)errorBundle, signerInformation, arrayList);
            }
            catch (Exception exception) {
                bl = false;
                object2 = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionVerifyingSignature", exception);
                arrayList.add(object2);
            }
            this.checkSignerCert(x509Certificate, arrayList, arrayList2);
            errorBundle = signerInformation.getSignedAttributes();
            if (errorBundle != null && (object2 = errorBundle.get(PKCSObjectIdentifiers.id_aa_receiptRequest)) != null) {
                object = SignedMailValidator.createErrorBundle("SignedMailValidator.signedReceiptRequest");
                arrayList2.add((ErrorBundle)object);
            }
            if ((object2 = SignedMailValidator.getSignatureTime(signerInformation)) == null) {
                object = SignedMailValidator.createErrorBundle("SignedMailValidator.noSigningTime");
                arrayList2.add((ErrorBundle)object);
                object2 = pKIXParameters.getDate();
                if (object2 == null) {
                    object2 = new Date();
                }
            } else {
                try {
                    x509Certificate.checkValidity((Date)object2);
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    objectArray = SignedMailValidator.createErrorBundle("SignedMailValidator.certExpired", new Object[]{new TrustedInput(object2), new TrustedInput((Object)x509Certificate.getNotAfter())});
                    arrayList.add(objectArray);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    objectArray = SignedMailValidator.createErrorBundle("SignedMailValidator.certNotYetValid", new Object[]{new TrustedInput(object2), new TrustedInput((Object)x509Certificate.getNotBefore())});
                    arrayList.add(objectArray);
                }
            }
            pKIXParameters2.setDate((Date)object2);
            try {
                PKIXCertPathReviewer pKIXCertPathReviewer;
                object = new ArrayList();
                ((ArrayList)object).add(this.certs);
                objectArray = SignedMailValidator.createCertPath(x509Certificate, pKIXParameters2.getTrustAnchors(), pKIXParameters.getCertStores(), (List)object);
                CertPath certPath = (CertPath)objectArray[0];
                List list = (List)objectArray[1];
                try {
                    pKIXCertPathReviewer = (PKIXCertPathReviewer)this.certPathReviewerClass.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + illegalAccessException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalArgumentException("Cannot instantiate object of type " + this.certPathReviewerClass.getName() + ": " + instantiationException.getMessage());
                }
                pKIXCertPathReviewer.init(certPath, pKIXParameters2);
                if (!pKIXCertPathReviewer.isValidCertPath()) {
                    ErrorBundle errorBundle2 = SignedMailValidator.createErrorBundle("SignedMailValidator.certPathInvalid");
                    arrayList.add(errorBundle2);
                }
                this.results.put(signerInformation, new ValidationResult(pKIXCertPathReviewer, bl, arrayList, arrayList2, list));
            }
            catch (GeneralSecurityException generalSecurityException) {
                objectArray = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionCreateCertPath", generalSecurityException);
                arrayList.add(objectArray);
                this.results.put(signerInformation, new ValidationResult(null, bl, arrayList, arrayList2, null));
            }
            catch (CertPathReviewerException certPathReviewerException) {
                arrayList.add(certPathReviewerException.getErrorMessage());
                this.results.put(signerInformation, new ValidationResult(null, bl, arrayList, arrayList2, null));
            }
        }
    }

    public static Set getEmailAddresses(X509Certificate x509Certificate) throws IOException, CertificateEncodingException {
        GeneralNames generalNames;
        HashSet<String> hashSet = new HashSet<String>();
        RDN[] rDNArray = JcaX500NameUtil.getSubject((X509Certificate)x509Certificate).getRDNs(PKCSObjectIdentifiers.pkcs_9_at_emailAddress);
        for (int i = 0; i < rDNArray.length; ++i) {
            generalNames = rDNArray[i].getTypesAndValues();
            for (int j = 0; j != ((AttributeTypeAndValue[])generalNames).length; ++j) {
                if (!PKCSObjectIdentifiers.pkcs_9_at_emailAddress.equals((ASN1Primitive)generalNames[j].getType())) continue;
                String string = ((ASN1String)generalNames[j].getValue()).getString().toLowerCase(locale);
                hashSet.add(string);
            }
        }
        byte[] byArray = x509Certificate.getExtensionValue(Extension.subjectAlternativeName.getId());
        if (byArray != null) {
            generalNames = GeneralNames.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray));
            GeneralName[] generalNameArray = generalNames.getNames();
            for (int i = 0; i < generalNameArray.length; ++i) {
                GeneralName generalName = generalNameArray[i];
                if (generalName.getTagNo() != 1) continue;
                String string = ASN1IA5String.getInstance((Object)generalName.getName()).getString().toLowerCase(locale);
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    protected void checkSignerCert(X509Certificate x509Certificate, List list, List list2) {
        ErrorBundle errorBundle;
        Object object;
        Object object2;
        long l;
        PublicKey publicKey = x509Certificate.getPublicKey();
        int n = -1;
        if (publicKey instanceof RSAPublicKey) {
            n = ((RSAPublicKey)publicKey).getModulus().bitLength();
        } else if (publicKey instanceof DSAPublicKey) {
            n = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (n != -1 && n <= 512) {
            ErrorBundle errorBundle2 = SignedMailValidator.createErrorBundle("SignedMailValidator.shortSigningKey", new Object[]{Integers.valueOf((int)n)});
            list2.add(errorBundle2);
        }
        if ((l = x509Certificate.getNotAfter().getTime() - x509Certificate.getNotBefore().getTime()) > 946728000000L) {
            object2 = SignedMailValidator.createErrorBundle("SignedMailValidator.longValidity", new Object[]{new TrustedInput((Object)x509Certificate.getNotBefore()), new TrustedInput((Object)x509Certificate.getNotAfter())});
            list2.add(object2);
        }
        if (!SignedMailValidator.supportsKeyUsage(object2 = x509Certificate.getKeyUsage(), 0) && !SignedMailValidator.supportsKeyUsage(object2, 1)) {
            object = SignedMailValidator.createErrorBundle("SignedMailValidator.signingNotPermitted");
            list.add(object);
        }
        try {
            object = x509Certificate.getExtensionValue(Extension.extendedKeyUsage.getId());
            if (object != null && !(errorBundle = ExtendedKeyUsage.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])object))).hasKeyPurposeId(KeyPurposeId.anyExtendedKeyUsage) && !errorBundle.hasKeyPurposeId(KeyPurposeId.id_kp_emailProtection)) {
                ErrorBundle errorBundle3 = SignedMailValidator.createErrorBundle("SignedMailValidator.extKeyUsageNotPermitted");
                list.add(errorBundle3);
            }
        }
        catch (Exception exception) {
            errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.extKeyUsageError", exception);
            list.add(errorBundle);
        }
        try {
            object = SignedMailValidator.getEmailAddresses(x509Certificate);
            if (object.isEmpty()) {
                errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.noEmailInCert");
                list.add(errorBundle);
            } else if (!SignedMailValidator.hasAnyFromAddress((Set)object, this.fromAddresses)) {
                errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.emailFromCertMismatch", new Object[]{new UntrustedInput((Object)SignedMailValidator.addressesToString(this.fromAddresses)), new UntrustedInput(object)});
                list.add(errorBundle);
            }
        }
        catch (Exception exception) {
            errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.certGetEmailError", exception);
            list.add(errorBundle);
        }
    }

    static boolean hasAnyFromAddress(Set set, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!set.contains(stringArray[i].toLowerCase(locale))) continue;
            return true;
        }
        return false;
    }

    static String addressesToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i != objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(String.valueOf(objectArray[i]));
        }
        return stringBuilder.append(']').toString();
    }

    public static Date getSignatureTime(SignerInformation signerInformation) {
        Attribute attribute;
        AttributeTable attributeTable = signerInformation.getSignedAttributes();
        if (attributeTable != null && (attribute = attributeTable.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
            return time.getDate();
        }
        return null;
    }

    public static CertPath createCertPath(X509Certificate x509Certificate, Set set, List list) throws GeneralSecurityException {
        Object[] objectArray = SignedMailValidator.createCertPath(x509Certificate, set, list, null);
        return (CertPath)objectArray[0];
    }

    public static Object[] createCertPath(X509Certificate x509Certificate, Set set, List list, List list2) throws GeneralSecurityException {
        Object object;
        if (x509Certificate == null) {
            throw new NullPointerException("'signerCert' cannot be null");
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        X509Certificate x509Certificate2 = x509Certificate;
        boolean bl = false;
        X509Certificate x509Certificate3 = SignedMailValidator.getProvidedCert(set, list, x509Certificate);
        if (x509Certificate3 != null) {
            x509Certificate2 = x509Certificate3;
            bl = true;
        }
        TrustAnchor trustAnchor = null;
        do {
            linkedHashSet.add(x509Certificate2);
            arrayList.add(!bl);
            trustAnchor = SignedMailValidator.findTrustAnchorForCert(x509Certificate2, set);
            if (trustAnchor != null) break;
            object = SignedMailValidator.createIssuerSelector(x509Certificate2);
            boolean bl2 = bl = (x509Certificate2 = SignedMailValidator.findFirstCert(list, (X509CertSelector)object, linkedHashSet)) != null;
            if (x509Certificate2 != null || list2 == null) continue;
            x509Certificate2 = SignedMailValidator.findFirstCert(list2, (X509CertSelector)object, linkedHashSet);
        } while (x509Certificate2 != null);
        if (trustAnchor != null) {
            object = trustAnchor.getTrustedCert();
            if (object != null && ((X509Certificate)object).getSubjectX500Principal().equals(((X509Certificate)object).getIssuerX500Principal())) {
                if (linkedHashSet.add(object)) {
                    arrayList.add(Boolean.FALSE);
                }
            } else {
                X509CertSelector x509CertSelector = new X509CertSelector();
                byte[] byArray = x509Certificate2.getIssuerX500Principal().getEncoded();
                try {
                    x509CertSelector.setSubject(byArray);
                    x509CertSelector.setIssuer(byArray);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException(iOException.toString());
                }
                x509Certificate2 = SignedMailValidator.findFirstCert(list, x509CertSelector, linkedHashSet);
                boolean bl3 = bl = x509Certificate2 != null;
                if (x509Certificate2 == null && list2 != null) {
                    x509Certificate2 = SignedMailValidator.findFirstCert(list2, x509CertSelector, linkedHashSet);
                }
                if (x509Certificate2 != null) {
                    try {
                        x509Certificate2.verify(x509Certificate2.getPublicKey(), "BC");
                        linkedHashSet.add(x509Certificate2);
                        arrayList.add(!bl);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        // empty catch block
                    }
                }
            }
        }
        object = CertificateFactory.getInstance("X.509", "BC").generateCertPath(new ArrayList(linkedHashSet));
        return new Object[]{object, arrayList};
    }

    public CertStore getCertsAndCRLs() {
        return this.certs;
    }

    public SignerInformationStore getSignerInformationStore() {
        return this.signers;
    }

    public ValidationResult getValidationResult(SignerInformation signerInformation) throws SignedMailValidatorException {
        if (this.signers.getSigners(signerInformation.getSID()).isEmpty()) {
            ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.wrongSigner");
            throw new SignedMailValidatorException(errorBundle);
        }
        return (ValidationResult)this.results.get(signerInformation);
    }

    private static ErrorBundle createErrorBundle(String string) {
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, string);
        errorBundle.setClassLoader(SignedMailValidator.class.getClassLoader());
        return errorBundle;
    }

    private static ErrorBundle createErrorBundle(String string, Object[] objectArray) {
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, string, objectArray);
        errorBundle.setClassLoader(SignedMailValidator.class.getClassLoader());
        return errorBundle;
    }

    private static ErrorBundle createErrorBundle(String string, Exception exception) {
        return SignedMailValidator.createErrorBundle(string, new Object[]{exception.getMessage(), exception, exception.getClass().getName()});
    }

    private static X509CertSelector createIssuerSelector(X509Certificate x509Certificate) {
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(x509Certificate.getIssuerX500Principal().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        byte[] byArray = x509Certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
        if (byArray != null) {
            try {
                AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])byArray));
                ASN1OctetString aSN1OctetString = authorityKeyIdentifier.getKeyIdentifierObject();
                if (aSN1OctetString != null) {
                    x509CertSelector.setSubjectKeyIdentifier(aSN1OctetString.getEncoded("DER"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return x509CertSelector;
    }

    private static X509Certificate findFirstCert(List list, X509CertSelector x509CertSelector, Set set) throws CertStoreException {
        X509CertSelector x509CertSelector2 = null;
        for (CertStore certStore : list) {
            Collection<? extends Certificate> collection = certStore.getCertificates(x509CertSelector);
            if (collection.isEmpty() && x509CertSelector.getSubjectKeyIdentifier() != null) {
                if (x509CertSelector2 == null) {
                    x509CertSelector2 = (X509CertSelector)x509CertSelector.clone();
                    x509CertSelector2.setSubjectKeyIdentifier(null);
                }
                collection = certStore.getCertificates(x509CertSelector2);
            }
            for (X509Certificate x509Certificate : collection) {
                if (set != null && set.contains(x509Certificate)) continue;
                return x509Certificate;
            }
        }
        return null;
    }

    private static TrustAnchor findTrustAnchorForCert(X509Certificate x509Certificate, Set set) {
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            do {
                TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
                try {
                    X509Certificate x509Certificate2 = trustAnchor.getTrustedCert();
                    if (x509Certificate2 != null) {
                        if (x500Principal.equals(x509Certificate2.getSubjectX500Principal())) {
                            x509Certificate.verify(x509Certificate2.getPublicKey(), "BC");
                            return trustAnchor;
                        }
                    } else if (x500Principal.getName().equals(trustAnchor.getCAName())) {
                        x509Certificate.verify(trustAnchor.getCAPublicKey(), "BC");
                        return trustAnchor;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (iterator.hasNext());
        }
        return null;
    }

    private static X509Certificate getProvidedCert(Set set, List list, X509Certificate x509Certificate) throws CertStoreException {
        Object object2;
        for (Object object2 : set) {
            X509Certificate x509Certificate2 = ((TrustAnchor)object2).getTrustedCert();
            if (x509Certificate2 == null || !x509Certificate2.equals(x509Certificate)) continue;
            return x509Certificate2;
        }
        object2 = new X509CertSelector();
        ((X509CertSelector)object2).setCertificate(x509Certificate);
        return SignedMailValidator.findFirstCert(list, (X509CertSelector)object2, null);
    }

    private static boolean isValidSignature(SignerInformationVerifier signerInformationVerifier, SignerInformation signerInformation, List list) {
        boolean bl = false;
        try {
            bl = signerInformation.verify(signerInformationVerifier);
            if (!bl) {
                ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.signatureNotVerified");
                list.add(errorBundle);
            }
        }
        catch (Exception exception) {
            ErrorBundle errorBundle = SignedMailValidator.createErrorBundle("SignedMailValidator.exceptionVerifyingSignature", exception);
            list.add(errorBundle);
        }
        return bl;
    }

    private static boolean supportsKeyUsage(boolean[] blArray, int n) {
        return null == blArray || blArray.length > n && blArray[n];
    }

    public static class ValidationResult {
        private PKIXCertPathReviewer review;
        private List errors;
        private List notifications;
        private List userProvidedCerts;
        private boolean signVerified;

        ValidationResult(PKIXCertPathReviewer pKIXCertPathReviewer, boolean bl, List list, List list2, List list3) {
            this.review = pKIXCertPathReviewer;
            this.errors = list;
            this.notifications = list2;
            this.signVerified = bl;
            this.userProvidedCerts = list3;
        }

        public List getErrors() {
            return this.errors;
        }

        public List getNotifications() {
            return this.notifications;
        }

        public PKIXCertPathReviewer getCertPathReview() {
            return this.review;
        }

        public CertPath getCertPath() {
            return this.review != null ? this.review.getCertPath() : null;
        }

        public List getUserProvidedCerts() {
            return this.userProvidedCerts;
        }

        public boolean isVerifiedSignature() {
            return this.signVerified;
        }

        public boolean isValidSignature() {
            return this.review != null && this.signVerified && this.review.isValidCertPath() && this.errors.isEmpty();
        }
    }
}

