/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeBoService;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinitionContract;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.ContextValidActionBo;
import org.kuali.rice.krms.impl.repository.ContextValidAgendaBo;
import org.kuali.rice.krms.impl.repository.ContextValidRuleBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsTypeBo;

public final class KrmsTypeBoServiceImpl
implements KrmsTypeBoService {
    private DataObjectService dataObjectService;

    public KrmsTypeDefinition createKrmsType(KrmsTypeDefinition krmsType) {
        if (krmsType == null) {
            throw new RiceIllegalArgumentException("krmsType is null");
        }
        String nameKey = krmsType.getName();
        String namespaceKey = krmsType.getNamespace();
        KrmsTypeDefinition existing = this.getTypeByName(namespaceKey, nameKey);
        if (existing != null && existing.getName().equals(nameKey) && existing.getNamespace().equals(namespaceKey)) {
            throw new RiceIllegalStateException("the KRMS Type to create already exists: " + String.valueOf(krmsType));
        }
        KrmsTypeBo bo = (KrmsTypeBo)this.dataObjectService.save((Object)KrmsTypeBo.from(krmsType), new PersistenceOption[]{PersistenceOption.FLUSH});
        return KrmsTypeBo.to(bo);
    }

    public KrmsTypeDefinition updateKrmsType(KrmsTypeDefinition krmsType) {
        KrmsTypeDefinition toUpdate;
        if (krmsType == null) {
            throw new RiceIllegalArgumentException("krmsType is null");
        }
        String idKey = krmsType.getId();
        KrmsTypeBo existing = (KrmsTypeBo)this.dataObjectService.find(KrmsTypeBo.class, (Object)idKey);
        if (existing == null) {
            throw new RiceIllegalStateException("the KRMS type does not exist: " + String.valueOf(krmsType));
        }
        if (!existing.getId().equals(krmsType.getId())) {
            KrmsTypeDefinition.Builder builder = KrmsTypeDefinition.Builder.create((KrmsTypeDefinitionContract)krmsType);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = krmsType;
        }
        return KrmsTypeBo.to((KrmsTypeBo)this.dataObjectService.save((Object)KrmsTypeBo.from(toUpdate), new PersistenceOption[]{PersistenceOption.FLUSH}));
    }

    public KrmsTypeDefinition getTypeById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new RiceIllegalArgumentException("id was a null or blank value");
        }
        KrmsTypeBo krmsTypeBo = (KrmsTypeBo)this.dataObjectService.find(KrmsTypeBo.class, (Object)id);
        return KrmsTypeBo.to(krmsTypeBo);
    }

    public KrmsTypeDefinition getTypeByName(String namespaceCode, String name) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("namespace", namespaceCode);
        map.put("name", name);
        KrmsTypeBo myType = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, KrmsTypeBo.class, Collections.unmodifiableMap(map));
        return KrmsTypeBo.to(myType);
    }

    public List<KrmsTypeDefinition> findAllTypesByNamespace(String namespaceCode) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", namespaceCode);
        map.put("active", Boolean.TRUE);
        List<KrmsTypeBo> krmsTypeBos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, KrmsTypeBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(krmsTypeBos);
    }

    public List<KrmsTypeDefinition> findAllTypesByServiceName(String serviceName) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)serviceName)) {
            throw new RiceIllegalArgumentException("serviceName was a null or blank value");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceName", serviceName);
        map.put("active", Boolean.TRUE);
        List<KrmsTypeBo> krmsTypeBos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, KrmsTypeBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(krmsTypeBos);
    }

    public List<KrmsTypeDefinition> findAllTypes() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("active", Boolean.TRUE);
        List<KrmsTypeBo> krmsTypeBos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, KrmsTypeBo.class, Collections.unmodifiableMap(map));
        return this.convertListOfBosToImmutables(krmsTypeBos);
    }

    public List<KrmsTypeDefinition> findAllAgendaTypesByContextId(String contextId) {
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextId);
        List<ContextValidAgendaBo> contextValidAgendaBos = BusinessObjectServiceMigrationUtils.findMatchingOrderBy(this.dataObjectService, ContextValidAgendaBo.class, Collections.unmodifiableMap(map), "agendaType.name", true);
        ArrayList<KrmsTypeDefinition> agendaTypes = new ArrayList<KrmsTypeDefinition>();
        for (ContextValidAgendaBo contextValidAgendaBo : contextValidAgendaBos) {
            agendaTypes.add(KrmsTypeBo.to(contextValidAgendaBo.getAgendaType()));
        }
        return agendaTypes;
    }

    public KrmsTypeDefinition getAgendaTypeByAgendaTypeIdAndContextId(String agendaTypeId, String contextId) {
        if (StringUtils.isBlank((String)agendaTypeId)) {
            throw new RiceIllegalArgumentException("agendaTypeId was a null or blank value");
        }
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("agendaTypeId", agendaTypeId);
        map.put("contextId", contextId);
        ContextValidAgendaBo contextValidAgendaBo = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, ContextValidAgendaBo.class, Collections.unmodifiableMap(map));
        return KrmsTypeBo.to(contextValidAgendaBo.getAgendaType());
    }

    public List<KrmsTypeDefinition> findAllRuleTypesByContextId(String contextId) {
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextId);
        List<ContextValidRuleBo> contextValidRuleBos = BusinessObjectServiceMigrationUtils.findMatchingOrderBy(this.dataObjectService, ContextValidRuleBo.class, Collections.unmodifiableMap(map), "ruleType.name", true);
        ArrayList<KrmsTypeDefinition> ruleTypes = new ArrayList<KrmsTypeDefinition>();
        for (ContextValidRuleBo contextValidRuleBo : contextValidRuleBos) {
            ruleTypes.add(KrmsTypeBo.to(contextValidRuleBo.getRuleType()));
        }
        return ruleTypes;
    }

    public KrmsTypeDefinition getRuleTypeByRuleTypeIdAndContextId(String ruleTypeId, String contextId) {
        if (StringUtils.isBlank((String)ruleTypeId)) {
            throw new RiceIllegalArgumentException("ruleTypeId was a null or blank value");
        }
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ruleTypeId", ruleTypeId);
        map.put("contextId", contextId);
        ContextValidRuleBo contextValidRuleBo = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, ContextValidRuleBo.class, Collections.unmodifiableMap(map));
        return KrmsTypeBo.to(contextValidRuleBo.getRuleType());
    }

    public List<KrmsTypeDefinition> findAllActionTypesByContextId(String contextId) {
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextId);
        List<ContextValidActionBo> contextValidActionBos = BusinessObjectServiceMigrationUtils.findMatchingOrderBy(this.dataObjectService, ContextValidActionBo.class, Collections.unmodifiableMap(map), "actionType.name", true);
        ArrayList<KrmsTypeDefinition> actionTypes = new ArrayList<KrmsTypeDefinition>();
        for (ContextValidActionBo contextValidActionBo : contextValidActionBos) {
            actionTypes.add(KrmsTypeBo.to(contextValidActionBo.getActionType()));
        }
        return actionTypes;
    }

    public KrmsTypeDefinition getActionTypeByActionTypeIdAndContextId(String actionTypeId, String contextId) {
        if (StringUtils.isBlank((String)actionTypeId)) {
            throw new RiceIllegalArgumentException("actionTypeId was a null or blank value");
        }
        if (StringUtils.isBlank((String)contextId)) {
            throw new RiceIllegalArgumentException("contextId was a null or blank value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("actionTypeId", actionTypeId);
        map.put("contextId", contextId);
        ContextValidActionBo contextValidActionBo = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, ContextValidActionBo.class, Collections.unmodifiableMap(map));
        return KrmsTypeBo.to(contextValidActionBo.getActionType());
    }

    public KrmsAttributeDefinition getAttributeDefinitionById(String attributeDefinitionId) {
        if (StringUtils.isBlank((String)attributeDefinitionId)) {
            throw new RiceIllegalArgumentException("attributeDefinitionId was a null or blank value");
        }
        KrmsAttributeDefinitionBo krmsAttributeDefinitionBo = (KrmsAttributeDefinitionBo)this.dataObjectService.find(KrmsAttributeDefinitionBo.class, (Object)attributeDefinitionId);
        return KrmsAttributeDefinitionBo.to(krmsAttributeDefinitionBo);
    }

    public KrmsAttributeDefinition getAttributeDefinitionByName(@WebParam(name="namespaceCode") String namespaceCode, @WebParam(name="name") String name) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was a null or blank value");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new RiceIllegalArgumentException("name was a null or blank value");
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("name", name);
        criteria.put("namespace", namespaceCode);
        List<KrmsAttributeDefinitionBo> attributeDefinitionBos = BusinessObjectServiceMigrationUtils.findMatching(this.dataObjectService, KrmsAttributeDefinitionBo.class, criteria);
        if (CollectionUtils.isEmpty(attributeDefinitionBos)) {
            return null;
        }
        return KrmsAttributeDefinitionBo.to((KrmsAttributeDefinitionBo)attributeDefinitionBos.iterator().next());
    }

    public KrmsTypeBo from(KrmsTypeDefinition krmsType) {
        if (krmsType == null) {
            return null;
        }
        KrmsTypeBo krmsTypeBo = new KrmsTypeBo();
        krmsTypeBo.setName(krmsType.getName());
        krmsTypeBo.setNamespace(krmsType.getNamespace());
        krmsTypeBo.setServiceName(krmsType.getServiceName());
        krmsTypeBo.setId(krmsType.getId());
        krmsTypeBo.setActive(krmsType.isActive());
        krmsTypeBo.setVersionNumber(krmsType.getVersionNumber());
        return krmsTypeBo;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    protected List<KrmsTypeDefinition> convertListOfBosToImmutables(Collection<KrmsTypeBo> krmsTypeBos) {
        ArrayList<KrmsTypeDefinition> krmsTypes = new ArrayList<KrmsTypeDefinition>();
        for (KrmsTypeBo bo : krmsTypeBos) {
            KrmsTypeDefinition krmsType = KrmsTypeBo.to(bo);
            krmsTypes.add(krmsType);
        }
        return Collections.unmodifiableList(krmsTypes);
    }
}

