-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DROP PROCEDURE IF EXISTS cleanup;

DELIMITER /

CREATE PROCEDURE cleanup()
BEGIN
    IF NOT EXISTS (
        SELECT 1
        FROM KRCR_PARM_T
        WHERE NMSPC_CD = 'KC-IP'
          AND CMPNT_CD = 'Document'
          AND PARM_NM = 'ShowSummaryView'
          AND APPL_ID = 'KC'
    ) THEN
        UPDATE KRCR_PARM_T
        SET PARM_NM = 'ShowSummaryView',
            PARM_DESC_TXT = 'Turn on/off summary view on institutional proposal',
            APPL_ID = 'KC'
        WHERE NMSPC_CD = 'KC-IP'
          AND CMPNT_CD = 'Document'
          AND PARM_NM = 'ShowNSFView'
          AND APPL_ID = 'KUALI';
    END IF;

    DELETE FROM KRCR_PARM_T
    WHERE NMSPC_CD = 'KC-IP'
      AND CMPNT_CD = 'Document'
      AND PARM_NM = 'ShowNSFView'
      AND APPL_ID = 'KUALI';
END
/

DELIMITER ;

call cleanup();

DROP PROCEDURE IF EXISTS cleanup;
