<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>


<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<!DOCTYPE HTML>
<html lang="en">
<head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
    <title>Kuali Portal Index</title>
<c:forEach items="${fn:split(ConfigProperties.portal.css.files, ',')}" var="cssFile">
	<c:if test="${fn:length(fn:trim(cssFile)) > 0}">
        <link href="${pageContext.request.contextPath}/${fn:trim(cssFile)}" rel="stylesheet" type="text/css" />
	</c:if>
</c:forEach>
<c:forEach items="${fn:split(ConfigProperties.portal.javascript.files, ',')}" var="javascriptFile">
	<c:if test="${fn:length(fn:trim(javascriptFile)) > 0}">
        <script type="text/javascript" src="${ConfigProperties.application.url}/${fn:trim(javascriptFile)}"></script>
	</c:if>
</c:forEach> 

<script type="text/javascript" >
<c:set var="dashboardMode" value="${krafn:getParameterValueAsBoolean('KC-GEN', 'All', 'Dashboard_Mode_Enabled')}" />

<c:if test="${dashboardMode}">

    <c:set var="dashboardBaseUrl" value="${krafn:getConfigValue('dashboard.standalone.base.url')}" />
    <c:set var="allowedRegex" value="${krafn:getConfigValue('rice.backLocation.allowed.regex')}" />

    var rlMatches = /^.*[?&]returnLocation=([^&]*|.*).*$/.exec(window.location.search);
    var returnLocation = rlMatches && decodeURIComponent(rlMatches[1]);
    var blMatches = /^.*[?&]backLocation=([^&]*|.*).*$/.exec(window.location.search);
    var backLocation = blMatches && decodeURIComponent(blMatches[1]);
    var allowedRegex = new RegExp('${allowedRegex}');

    if (returnLocation && allowedRegex.test(returnLocation)) {
        top.location = returnLocation;
    } else if (backLocation && allowedRegex.test(backLocation)) {
        top.location = backLocation;
    } else {
        <c:if test="${not empty dashboardBaseUrl}">
            top.location = "${dashboardBaseUrl}/dashboard";
        </c:if>

        <c:if test="${empty dashboardBaseUrl}">
            top.location = window.location.origin + "/dashboard";
        </c:if>
    }
</c:if>

<c:if test="${not dashboardMode}">
    if (top.location !== self.location) {
        top.location = self.location;
    }
</c:if>
</script>

</head>
<body>
<portal:portalTabs selectedTab="${sessionScope.selectedTab}" channelTitle="${param.channelTitle}" />
