<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<c:set var="institutionalProposalAttributes" value="${DataDictionary.InstitutionalProposal.attributes}" />
<c:set var="institutionalProposalCommentAttributes" value="${DataDictionary.InstitutionalProposalComment.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="institutionalProposalHome" />

<kul:tab tabTitle="Institutional Proposal" defaultOpen="true"
		 tabErrorKey="document.institutionalProposalList[0].statusCode,document.institutionalProposalList[0].activityTypeCode,document.institutionalProposalList[0].proposalTypeCode,document.institutionalProposalList[0].title,document.institutionalProposalList[0].currentAwardNumber,document.institutionalProposalList[0].unitNumber"
		 auditCluster="institutionalProposalKrmsAuditErrors,institutionalProposalKrmsAuditWarnings"
		 tabAuditKey="document.institutionalProposalList[0].fiscalYear"
		 useRiceAuditMode="true">
	<%-- Institution --%>
<div class="tab-container" align="center">

<h3>
	<span class="subhead-left">Institutional Proposal</span>
	<span class="subhead-right"><kul:help businessObjectClassName="org.kuali.kra.institutionalproposal.home.InstitutionalProposal" altText="help"/></span>
</h3>
<table cellpAdding="0" cellspacing="0" summary="">
  	<tr>
    	<th width="400">
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.proposalNumber}" labelFor="document.institutionalProposalList[0].proposalNumber" /></div>
    	</th>
    	<td>
			<kul:htmlControlAttribute property="document.institutionalProposalList[0].proposalNumber" attributeEntry="${institutionalProposalAttributes.proposalNumber}" readOnly="true"/>
    	</td>
    	<th width="400">
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.sequenceNumber}" labelFor="document.institutionalProposalList[0].sequenceNumber" /></div>
		</th>
    	<td>
			<kul:htmlControlAttribute property="document.institutionalProposalList[0].sequenceNumber" attributeEntry="${institutionalProposalAttributes.sequenceNumber}" readOnly="true"/>
		</td>
  	</tr>
  	<tr>
    	<th width="400">
    		<div align="right">Fiscal Month/Year:</div>
    	</th>
    	<td>
    		${KualiForm.institutionalProposalDocument.institutionalProposal.fiscalMonth}/${KualiForm.institutionalProposalDocument.institutionalProposal.fiscalYear}&nbsp;
    	</td>
    	<th width="400">
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.instProposalNumber}" labelFor="document.institutionalProposalList[0].instProposalNumber"/></div>
    	</th>
    	<td>
			<kul:htmlControlAttribute property="document.institutionalProposalList[0].instProposalNumber" attributeEntry="${institutionalProposalAttributes.instProposalNumber}" readOnly="true"/>
    	</td>
  	</tr>
  	<tr>
    	<th width="400">
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.currentAwardNumber}" labelFor="document.institutionalProposalList[0].currentAwardNumber"/></div>
		</th>
    	<td>
    		<div align="left"> 
				<kul:htmlControlAttribute property="document.institutionalProposalList[0].currentAwardNumber" attributeEntry="${institutionalProposalAttributes.currentAwardNumber}"/>
				<c:if test="${!readOnly}">
			         <kul:lookup boClassName="org.kuali.kra.award.home.Award" fieldConversions="awardNumber:document.institutionalProposal.currentAwardNumber" anchor="${tabKey}"/>
			    </c:if>
			</div>
    	</td>
		<c:set var="docInSavedState" value="${KualiForm.institutionalProposalDocument.saved}" />
		<th width="400">
			<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.unitNumber}" skipHelpUrl="true" labelFor="document.institutionalProposalList[0].unitNumber"/></div>
		</th>
		<td align="left">
			<kul:htmlControlAttribute property="document.institutionalProposalList[0].unitNumber"
									  attributeEntry="${institutionalProposalAttributes.unitNumber}" readOnly="${readOnly or docInSavedState}" />
			<c:if test="${!docInSavedState}">
				<c:if test="${!readOnly}">
					<kul:lookup boClassName="org.kuali.coeus.common.framework.unit.Unit" fieldConversions="unitNumber:document.institutionalProposalList[0].unitNumber"
								anchor="${tabKey}" lookupParameters="document.institutionalProposalList[0].unitNumber:unitNumber"/>
				</c:if>
			</c:if>
			<c:if test="${docInSavedState or readOnly}">
				<html:hidden property="document.institutionalProposalList[0].unitNumber" />
				-
				<kul:htmlControlAttribute property="document.institutionalProposalList[0].unitName" attributeEntry="${institutionalProposalAttributes['leadUnit.unitName']}" readOnly="true" />
			</c:if>
			<kul:directInquiry boClassName="org.kuali.coeus.common.framework.unit.Unit" inquiryParameters="document.institutionalProposalList[0].unitNumber:unitNumber" anchor="${tabKey}" />
		</td>
  	</tr>
  	<tr>
    	<th>
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.proposalTypeCode}" labelFor="document.institutionalProposalList[0].proposalTypeCode"/></div>
    	</th>
    	<td>
    		<kul:htmlControlAttribute property="document.institutionalProposalList[0].proposalTypeCode" attributeEntry="${institutionalProposalAttributes.proposalTypeCode}" />
		</td>
		<th>
			<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.statusCode}" labelFor="document.institutionalProposal.statusCode"/></div>
		</th>
		<c:choose>
			<c:when test="${KualiForm.institutionalProposalDocument.institutionalProposal.statusCode == 2}">
				<td>
					Funded
				</td>
			</c:when>
			<c:otherwise>
				<td>
					<kul:htmlControlAttribute property="document.institutionalProposal.statusCode" attributeEntry="${institutionalProposalAttributes.statusCode}" />
				</td>
			</c:otherwise>
		</c:choose>
  	</tr>
  	<tr>
    	<th>
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.initialContractAdmin}" /></div>
    	</th>
    	<td>
    	    <kul:inquiry boClassName="org.kuali.coeus.common.framework.person.KcPerson" keyValues="personId=${KualiForm.institutionalProposalDocument.institutionalProposal.initialContractAdmin}" render="true">
    	       <c:out value="${KualiForm.institutionalProposalDocument.institutionalProposal.initialContractAdminUser.userName}" />
    	   </kul:inquiry>&nbsp;
		</td>
		<th>
			<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.activityTypeCode}" labelFor="document.institutionalProposalList[0].activityTypeCode"/></div>
		</th>
		<td>
			<kul:htmlControlAttribute property="document.institutionalProposalList[0].activityTypeCode" attributeEntry="${institutionalProposalAttributes.activityTypeCode}" />
		</td>
  	</tr>
  	<tr>
    	<th>
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.updateUser}" /></div>
    	</th>
    	<td>
    		${KualiForm.institutionalProposalDocument.institutionalProposal.updateUser}&nbsp;
		</td>
		<th>
			<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.createTimestamp}" /></div>
		</th>
		<td>
				${KualiForm.institutionalProposalDocument.institutionalProposal.createTimestamp}&nbsp;
		</td>
  	</tr>
  	<tr>
    	<th>
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.title}" labelFor="document.institutionalProposalList[0].title"/>
      		</div>
      	</th>
    	<td>
        	<table style="border:none; width:100%;">
        		<tr>
            		<td style="border:none; width:100%;">
            			<kul:htmlControlAttribute property="document.institutionalProposalList[0].title" attributeEntry="${institutionalProposalAttributes.title}" />
        			</td>
            	</tr>
        	</table>
    	</td>
		<th>
			<div align="right"><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.updateTimestamp}" /></div>
		</th>
		<td>
				${KualiForm.institutionalProposalDocument.institutionalProposal.updateTimestamp}&nbsp;
		</td>
  	</tr>
</table>
</div>
<div class="tab-container" align="center">
    <h3>
        <span class="subhead-left">Summary Comments</span>
    </h3>
    <table>
        <th width="100" align="right" scope="row"><div align="center">Add:</div></th>
        <td class="infoline">
             <div align="left">
                 <kul:htmlControlAttribute property="document.institutionalProposalList[0].summaryComment.comments" attributeEntry="${institutionalProposalCommentAttributes.comments}"/>
             </div>
        </td>
    </table>
</div>
</kul:tab>
