<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<%@ attribute name="institutionalProposalObject" required="true" type="org.kuali.kra.institutionalproposal.home.InstitutionalProposal" %>
<%@ attribute name="institutionalProposalPath" required="true" type="java.lang.String" %>
<%@ attribute name="tabSuffix" required="true" type="java.lang.String" %>

<%-- odd namespace for this parameter--%>
<c:set var="schoolAcronym" value="${krafn:getParameterValue('KC-PD', 'Document', 'SCHOOL_ACRONYM', 'Institution')}"/>

<kul:tab tabTitle="Team ${tabSuffix}" defaultOpen="false" useRiceAuditMode="false">
    <div class="tab-container" align="center">
        <h3>
            <span class="subhead-left"><c:out value="${schoolAcronym}" /> Team Members</span>
        </h3>
        <table>
            <thead>
            <tr>
                <th>Name</th>
                <th>Lab/Division/Program</th>
                <th>Role</th>
            </tr>
            </thead>
            </thead>
            <tbody>
            <c:forEach var="institutionalProposalContact"
                       items="${krafn:copy(institutionalProposalObject.employeeProjectPersons)}"
                       varStatus="institutionalProposalContactRowStatus">
                <tr>
                    <td><c:out value="${institutionalProposalContact.fullName}"/></td>
                    <td><c:out value="${institutionalProposalContact.contactOrganizationName}"/></td>
                    <td><c:out value="${institutionalProposalContact.investigatorRoleDescription}"/></td>
                </tr>

            </c:forEach>
            </tbody>
        </table>

    </div>
    <c:if test="${institutionalProposalObject.nonEmployeeProjectPersons.size() > 0}">
        <div class="tab-container">
            <h3>
                <span class="subhead-left">Non-<c:out value="${schoolAcronym}" /> Team Members</span>
            </h3>
            <table>
                <thead>
                <tr>
                    <th>Name</th>
                    <th>Organization</th>
                    <th>Role</th>
                </tr>
                </thead>
                <tbody>
                <c:forEach var="institutionalProposalContact"
                           items="${krafn:copy(institutionalProposalObject.nonEmployeeProjectPersons)}"
                           varStatus="institutionalProposalContactRowStatus">
                    <tr>
                        <td><c:out value="${institutionalProposalContact.fullName}"/></td>
                        <td><c:out value="${institutionalProposalContact.contactOrganizationName}"/></td>
                        <td><c:out value="${institutionalProposalContact.investigatorRoleDescription}"/></td>
                    </tr>

                </c:forEach>
                </tbody>
            </table>
        </div>
    </c:if>
</kul:tab>
