<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<c:set var="awardPostHistory" value="${KualiForm.awardPostsByAwardId}" />
<c:set var="awardPostRestIntegrationActive" value="${KualiForm.isAwardPostRestIntegrationOn()}"/>

<kul:tab tabTitle="Award Post History" tabItemCount="${fn:length(awardPostHistory)}"  defaultOpen="${param.command eq 'displayDocSearchView' ? true : false}" >
	<div class="tab-container" align="left">
    	<h3> 
    		<span class="subhead-left">Award Post History</span>
        </h3>
        <table cellpadding=0 cellspacing=0 summary="">
                <tr>
                    <c:if test="${!awardPostRestIntegrationActive}">
                    <th>
                        <div align="center">
                            Data retrieved
                        </div>
                    </th>
                    </c:if>
                    <c:if test="${awardPostRestIntegrationActive}">
                    <th>
                        <div align="center">
                            Posted to Account
                        </div>
                    </th>
                    <th>
                        <div align="center">
                            Post Status
                        </div>
                    </th>
                    <th>
                        <div align="center">
                            Post Details
                        </div>
                    </th>
                    </c:if>
                    <th>
                        <div align="center"	>
                            Posted date
                        </div>
                    </th>
                    <th>
                        <div align="center"	>
                            Username
                        </div>
                    </th>
                    <th>
                        <div align="center"	>
                            Name
                        </div>
                    </th>
                    <th>
                        <div align="center"	>
                            Document
                        </div>
                    </th>
                    <c:if test="${awardPostRestIntegrationActive}">
                    <th>
                        <div align="center"	>
                            Actions
                        </div>
                    </th>
                    </c:if>
                </tr>
            <c:set var="fieldCount" value="0" />
            <c:forEach items="${awardPostHistory}" var="postHistory">
                <c:set var="fieldCount" value="${fieldCount + 1}" />

                <tr>
                    <c:if test="${!awardPostRestIntegrationActive}">
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${!postHistory.active}" />
                        </div>
                    </td>
                    </c:if>
                    <c:if test="${awardPostRestIntegrationActive}">
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${postHistory.accountNumber}" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${postHistory.postStatus}" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${postHistory.postDetails}" />
                        </div>
                    </td>
                    </c:if>
                    <td class="infoline">
                        <div align="center">
                            <fmt:formatDate value="${postHistory.updateTimestamp}" pattern="MM/dd/yyyy HH:mm:ss" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${postHistory.updateUser}" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${postHistory.lastName}, ${postHistory.firstName}" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <a href="${ConfigProperties.application.url}/kew/DocHandler.do?command=displayDocSearchView&amp;docId=${postHistory.documentNumber}"
                               target="_self" style="color:#068acd;" title="open award">${postHistory.documentNumber}</a>
                        </div>
                    </td>
                    <c:if test = "${awardPostRestIntegrationActive && fieldCount==1}" >
                        <kra:section permission="createAwardAccount">

                        <%--  need an onclick yes/no dialog if last post was successful and award is unchanged since then ... --%>
                    <td class="infoline">
                        <div align="center">
                            <html:image property="methodToCall.resendAwardPost" src="${ConfigProperties.kra.externalizable.images.url}tinybutton-repost-1.gif" title="resend award account" alt="retry award account create/update" styleClass="tinybutton"/>
                        </div>
                    </td>
                        </kra:section>
                    </c:if>
                </tr>
            </c:forEach>
        </table>
	</div>
</kul:tab>

