<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<%@ attribute name="boClassName" required="true" description="The class of the business object to create the inquiry for." %>
<%@ attribute name="inquiryParameters" required="false" description="The keys of the business object to display." %>
<%@ attribute name="anchor" required="false" description="The HTML named anchor of the button rendered." %>
<%@ attribute name="tabindexOverride" required="false" description="The overridden tab index of the button rendered." %>
<%@ attribute name="fieldLabel" required="false" description="Label text of the associated field for accessibility (used to compose the button's accessible name)." %>
<%@ attribute name="fieldLabelElementId" required="false" description="Id of the label element associated with the field (used for aria-labelledby)." %>

<c:choose>
  <c:when test="${!empty tabindexOverride}">
    <c:set var="tabindex" value="${tabindexOverride}"/>
  </c:when>
  <c:otherwise>
    <c:set var="tabindex" value="0"/>
  </c:otherwise>
</c:choose>

<c:choose>
  <c:when test="${!empty fieldLabel}">
    <c:set var="directInquiryTitle" value="Direct Inquiry: ${fieldLabel}:"/>
  </c:when>
  <c:otherwise>
    <c:set var="directInquiryTitle" value="Direct Inquiry"/>
  </c:otherwise>
</c:choose>

<c:set var="epMethodToCallAttribute" value="methodToCall.performInquiry.(!!${boClassName}!!).((`${inquiryParameters}`)).anchor${anchor}"/>
${kfunc:registerEditableProperty(KualiForm, epMethodToCallAttribute)} 
<input type="image" tabindex="${tabindex}" name="${epMethodToCallAttribute}"
   onclick="javascript: inquiryPop('${boClassName}','${inquiryParameters}'); return false"
   src="${ConfigProperties.kr.externalizable.images.url}book_open.png" class="tinybutton"
   title="${directInquiryTitle}" alt="${directInquiryTitle}"
   aria-label="${directInquiryTitle}"
/>
<script type="text/javascript">
  (function(){
    if (window.__kcDiFixApplied) { return; }
    window.__kcDiFixApplied = true;

    function textOf(el){ return (el && (el.textContent || el.innerText) || '').replace(/\s+/g,' ').trim(); }
    function normalizeLabelText(text){
      if (!text) return '';
      text = text.replace(/^\*\s*/, '');
      text = text.replace(/:$/, '').trim();
      return text;
    }
    function closestTr(node){
      var n = node; while (n && n !== document) { if (n.tagName === 'TR') return n; n = n.parentNode; } return null;
    }
    function pushUnique(arr, el){ for (var i=0;i<arr.length;i++){ if (arr[i]===el) return; } arr.push(el); }

    function gatherDirectInquiryInputs(){
      var list = [];
      var a = document.querySelectorAll('input[type="image"][name^="methodToCall.performInquiry."]');
      var b = document.querySelectorAll('input[type="image"][onclick*="inquiryPop("]');
      var c = document.querySelectorAll('input[type="image"][src$="book_open.png"]');
      for (var i=0;i<a.length;i++) pushUnique(list, a[i]);
      for (var j=0;j<b.length;j++) pushUnique(list, b[j]);
      for (var k=0;k<c.length;k++) pushUnique(list, c[k]);
      return list;
    }

    function getHeaderTextFromTr(tr){
      if (!tr) return '';
      var labelEl = tr.querySelector('label');
      if (labelEl) return normalizeLabelText(textOf(labelEl));
      var th = tr.querySelector('th');
      if (th) return normalizeLabelText(textOf(th));
      return '';
    }

    function getSiblingFieldText(btn, tr){
      tr = tr || closestTr(btn);
      if (!tr) return '';
      var fields = tr.querySelectorAll('input,textarea,select');
      var candidate = null;
      for (var i=0;i<fields.length;i++){
        if (fields[i] === btn) break; // stop before the DI button
        candidate = fields[i];
      }
      if (!candidate) return '';
      var t = candidate.getAttribute('aria-label') || candidate.getAttribute('title') || candidate.getAttribute('placeholder') || '';
      return normalizeLabelText(t);
    }

    function extractFieldIdFromName(btn){
      var name = btn && btn.getAttribute('name');
      if (!name) return '';
      var bt = name.indexOf('`');
      if (bt !== -1) {
        var colon = name.indexOf(':', bt + 1);
        if (colon !== -1) return name.substring(bt + 1, colon);
      }
      var m = name.match(/\(\([^)]*?([A-Za-z0-9_\.\[\]]+):[^)]*\)\)/);
      return (m && m[1]) ? m[1] : '';
    }

    function extractFieldIdFromOnclick(btn){
      var oc = btn && btn.getAttribute('onclick');
      if (!oc) return '';
      var parts = oc.split("'");
      if (parts.length >= 4) {
        var map = parts[3];
        var idx = map.indexOf(':');
        if (idx > 0) return map.substring(0, idx);
      }
      return '';
    }

    function findLabelForFieldId(fieldId, scopeTr){
      if (!fieldId) return null;
      // Prefer getElementById(fieldId) then search labels by [for]
      var labels = document.getElementsByTagName('label');
      for (var i=0;i<labels.length;i++){
        var f = labels[i].getAttribute('for');
        if (f === fieldId) return labels[i];
      }
      if (scopeTr) {
        var scopedLabels = scopeTr.getElementsByTagName('label');
        for (var j=0;j<scopedLabels.length;j++){
          var ff = scopedLabels[j].getAttribute('for');
          if (ff === fieldId) return scopedLabels[j];
        }
      }
      return null;
    }

    function applyAccessibleNames(){
      try {
        var inputs = gatherDirectInquiryInputs();
        for (var i=0;i<inputs.length;i++){
          var btn = inputs[i];
          if (btn.hasAttribute('aria-labelledby')) continue;

          var tr = closestTr(btn);
          var fieldId = extractFieldIdFromName(btn) || extractFieldIdFromOnclick(btn);
          var labelEl = findLabelForFieldId(fieldId, tr);

          var text = labelEl ? normalizeLabelText(textOf(labelEl)) : '';
          if (!text) text = getHeaderTextFromTr(tr);
          if (!text) text = getSiblingFieldText(btn, tr);
          if (!text) continue;

          var composed = 'Direct Inquiry: ' + text + ':';
          btn.setAttribute('title', composed);
          btn.setAttribute('alt', composed);
          btn.setAttribute('aria-label', composed); // fallback name
        }
      } catch(e) { /* no-op */ }
    }

    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', applyAccessibleNames);
    } else {
      applyAccessibleNames();
    }
  })();
</script>
