/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */



/**
 * KULRICE-7339. A patch to disable validation on all required fields, except document header description,
 * when the Action Requested select control for Ad Hoc Recipients has a value of COMPLETE.
 *
 * @returns {boolean} true if all fields requiring validation are valid, false otherwise
 */
function isRouteToComplete(kradRequest) {

    var $fieldsToSkip = jQuery(".required").not("input[name='document.documentHeader.documentDescription']");
    var valid = validatePartialForm($fieldsToSkip, isAdHocComplete);

    if (!valid) {
        clearHiddens();
    }

    return valid;
}

/**
 * Determines if the Action Requested select control for Ad Hoc Recipients has a value of COMPLETE.
 *
 * @returns {boolean} true if the above condition exists, false otherwise.
 */
function isAdHocComplete() {

    var adHocRoutes = jQuery("select[name^='document.adHocRouteWorkgroups['],[name^='document.adHocRoutePersons[']");
    var complete = false;

    adHocRoutes.each(function isSetToComplete(index, selectControl) {
        if (jQuery(selectControl).val() === "C") {
            complete = true;
            return false;
        }
    });

    return complete;
}
