<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="exconProjectAttributes" value="${DataDictionary.ExconProject.attributes}" />
<c:set var="RPSEntityAttributes" value="${DataDictionary.ExconProjectRPSEntity.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectContacts" />
<c:set var="rpsEntitySaved" value="${KualiForm.exconProjectRPSEntitiesBean.savedRPSEntity != null}" />

<kul:tab tabTitle="Restricted Party Screening" defaultOpen="true" useRiceAuditMode="true">
	
	<div class="tab-container" align="center">
	<h3>
		<span class="subhead-left">Person/Company Information</span>  		
		<span class="subhead-right"><kul:help parameterNamespace="KC-EXCON" parameterDetailType="Document" parameterName="exconProjectContactsHelpUrl" altText="help"/></span>
	</h3>
<table cellpAdding="0" cellspacing="0" summary="">
  	<tr>
    	<th width="25%">
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.firstName}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.firstName"/>
      		</div>
      	</th>
    	<td width="25%">
            <kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.firstName" attributeEntry="${RPSEntityAttributes.firstName}" readOnly="${readOnly || rpsEntitySaved}"/>
    	</td>
    	<th width="25%">
    		<div align="right">
    			<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.lastName}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.lastName"/>
    		</div>
    	</th>
    	<td width="25%">
    		<kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.lastName" attributeEntry="${RPSEntityAttributes.lastName}"  readOnly="${readOnly || rpsEntitySaved}"/>
		</td>
  	</tr>
  	<tr>
    	<th width="25%">
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.otherNames}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.otherNames"/>
      		</div>
      	</th>
    	<td width="25%">
            <kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.otherNames" attributeEntry="${RPSEntityAttributes.otherNames}"  readOnly="${readOnly || rpsEntitySaved}"/>
    	</td>
    	<th width="25%">
    		<div align="right">
    			<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.birthdate}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.birthdate"/>
    		</div>
    	</th>
    	<td width="25%">
    		<kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.birthdate" attributeEntry="${RPSEntityAttributes.birthdate}"  readOnly="${readOnly || rpsEntitySaved}"/>
		</td>
  	</tr>
  	<tr>
    	<th width="25%">
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.companyName}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.companyName"/>
      		</div>
      	</th>
    	<td width="25%">
            <kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.companyName" attributeEntry="${RPSEntityAttributes.companyName}"  readOnly="${readOnly || rpsEntitySaved}"/>
    	</td>
    	<th width="25%">
    		<div align="right">
    			<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.otherInfo}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.otherInfo"/>
    		</div>
    	</th>
    	<td width="25%">
    		<kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.otherInfo" attributeEntry="${RPSEntityAttributes.otherInfo}"  readOnly="${readOnly || rpsEntitySaved}"/>
		</td>
  	</tr>
  	<tr>
    	<th width="25%">
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.streetAddress}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.streetAddress"/>
      		</div>
      	</th>
    	<td width="25%">
            <kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.streetAddress" attributeEntry="${RPSEntityAttributes.streetAddress}"  readOnly="${readOnly || rpsEntitySaved}"/>
    	</td>
    	<th width="25%">
    		<div align="right">
    			<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.city}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.city"/>
    		</div>
    	</th>
    	<td width="25%">
    		<kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.city" attributeEntry="${RPSEntityAttributes.city}"  readOnly="${readOnly || rpsEntitySaved}"/>
		</td>
  	</tr>
  	<tr>
    	<th width="25%">
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.state}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.state"/>
      		</div>
      	</th>
    	<td width="25%">
            <kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.state" attributeEntry="${RPSEntityAttributes.state}"  readOnly="${readOnly || rpsEntitySaved}"/>
    	</td>
    	<th width="25%">
    		<div align="right">
    			<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.countryCode}" labelFor="exconProjectRPSEntitiesBean.rpsEntity.countryCode"/>
    		</div>
    	</th>
    	<td width="25%">
    		<kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.rpsEntity.countryCode" attributeEntry="${RPSEntityAttributes.countryCode}"  readOnly="${readOnly || rpsEntitySaved}"/>
		</td>
  	</tr>
  	<c:if test="${!rpsEntitySaved}">
  	<tr>
    	<th colspan="2">
    		&nbsp;
      	</th>
    	<th width="25%" colspan="2">
    		<div align="center">
    		<c:if test="${!readOnly}">
				<kul:kualiButton property="methodToCall.addRPSEntity"
								 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
								 label="Add" title="Add RPS Entity" styleClass="tinybutton addButton small outline" />
			</c:if>
    	</th>
  	</tr>
  	</c:if>
	<c:if test="${rpsEntitySaved}">
  	<tr>
    	<th width="25%">
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${RPSEntityAttributes.rpsMatchCode}" labelFor="exconProjectRPSEntitiesBean.savedRPSEntity.rpsMatchCode"/>
      		</div>
      	</th>
    	<td width="25%">
            <kul:htmlControlAttribute property="exconProjectRPSEntitiesBean.savedRPSEntity.rpsMatchCode" attributeEntry="${RPSEntityAttributes.rpsMatchCode}" />
    	</td>
    	<th width="25%" colspan="2">
    		<div align="center">
    		<c:if test="${!readOnly}">
				<kul:kualiButton property="methodToCall.deleteRPSEntity.line${projectEventRowStatus.index}.anchor${currentTabIndex}"
								 src="${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif"
								 label="Delete" title="Delete RPS Entity" styleClass="tinybutton small outline" />
				<kul:kualiButton property="methodToCall.editRPSEntity.line${projectEventRowStatus.index}.anchor${currentTabIndex}"
								 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-edit1.gif"
								 label="Edit" title="Edit RPS Entity" styleClass="tinybutton small outline" />
				<kul:kualiButton property="methodToCall.performRPS"
								 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-search.gif"
								 label="Search" title="Perform RPS Entity Search" styleClass="tinybutton small outline" />

			</c:if>
    		</div>
    	</th>
  	</tr>
  	</c:if>
</table>

</kul:tab>
