<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<%@ attribute name="institutionalProposalObject" required="true" type="org.kuali.kra.institutionalproposal.home.InstitutionalProposal" %>
<%@ attribute name="institutionalProposalPath" required="true" type="java.lang.String" %>
<%@ attribute name="tabSuffix" required="true" type="java.lang.String" %>
<%@ attribute name="filterPreproposalApplicationIds" required="false" type="java.util.Collection" %>

<kul:tab tabTitle="Systems ${tabSuffix}" defaultOpen="false" useRiceAuditMode="false">
    <div class="tab-container" align="center">
        <h3>
            <span class="subhead-left">Linked Systems</span>
        </h3>
        <table>
            <c:if test="${KualiForm.standaloneBudgetEnabled and not empty institutionalProposalObject.budgetId}" >
                <tr>
                    <th>Budget:</th>
                    <td><a target="_blank" href = "<c:url value = "${KualiForm.standaloneBudgetViewUrl}/${institutionalProposalObject.budgetId}"/>">View</a></td>
                </tr>
            </c:if>
            <c:forEach var="preproposalForm" items="${institutionalProposalObject.preproposalForms}">
                <c:if test="${filterPreproposalApplicationIds == null or empty filterPreproposalApplicationIds or fn:contains(filterPreproposalApplicationIds, preproposalForm.appId)}">
                    <tr>
                        <th><c:out value="${preproposalForm.appName}"/>:</th>
                        <td><a target="_blank" href = "<c:url value = "${KualiForm.preproposalFormViewUrl}/${preproposalForm.docId}"/>">View</a></td>
                    </tr>
                </c:if>
            </c:forEach>
        </table>
    </div>
</kul:tab>
