<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<%@ attribute name="institutionalProposalObject" required="true" type="org.kuali.kra.institutionalproposal.home.InstitutionalProposal" %>
<%@ attribute name="institutionalProposalPath" required="true" type="java.lang.String" %>
<%@ attribute name="tabSuffix" required="true" type="java.lang.String" %>

<c:set var="institutionalProposalAttributes"  value="${DataDictionary.InstitutionalProposal.attributes}"/>
<c:set var="sponsorAttributes"  value="${DataDictionary.Sponsor.attributes}"/>

<kul:tab tabTitle="Proposal Summary ${tabSuffix}" defaultOpen="true" useRiceAuditMode="false">
    <div class="tab-container" align="center">
        <h3>
            <span class="subhead-left">Proposal Summary</span>
        </h3>
        <table>
            <tr>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr>
                <th><label for="${institutionalProposalPath}.unitName">Lead Lab/Division/Program:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.unitName"
                        attributeEntry="${institutionalProposalAttributes['leadUnit.unitName']}"
                        readOnly="true"/></td>
                <th><label for="${institutionalProposalPath}.sponsorProposalNumber">Sponsor Assigned Proposal #:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.sponsorProposalNumber"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.sponsorProposalNumber}"/></td>
            </tr>
            <tr>
                <th><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.proposalNumber}" labelFor="${institutionalProposalPath}.proposalNumber"/></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.proposalNumber"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.proposalNumber}"/></td>
                <th><label for="${institutionalProposalPath}.sequenceNumber">Sequence #:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.sequenceNumber"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.sequenceNumber}"/></td>
            </tr>
            <tr>
                <th><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.title}" labelFor="${institutionalProposalPath}.title"/></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.title"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.title}"/></td>
                <th><label>Proposal Development Number (Original):</label></th>
                <td><c:out value="${institutionalProposalObject.originalProposalNumber}"/></td>
            </tr>
            <tr>
                <th><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes['principalInvestigator.fullName']}" labelFor="${institutionalProposalPath}.title"/></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.principalInvestigator.fullName"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes['principalInvestigator.fullName']}"/>
                <th><label for="${institutionalProposalPath}.proposalStatus.description">Proposal State:</label></th>
                <td>
                    <kul:htmlControlAttribute
                            property="${institutionalProposalPath}.proposalStatus.description"
                            attributeEntry="${institutionalProposalAttributes.statusCode}"
                            readOnly="true"/>
                </td>
            </tr>
            <tr>
                <th><label>Direct Sponsor:</label></th>
                <td><c:out value="${institutionalProposalObject.sponsor.sponsorName}" /></td>
                <th><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.proposalTypeCode}" labelFor="${institutionalProposalPath}.proposalTypeCode"/></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.proposalTypeCode"
                        attributeEntry="${institutionalProposalAttributes.proposalTypeCode}"
                        readOnly="true"/></td>
            </tr>
            <tr>
                <th style="padding-left: 24px;"><kul:htmlAttributeLabel attributeEntry="${sponsorAttributes['sponsorType.description']}" /></th>
                <td colspan="3"><c:out value="${institutionalProposalObject.sponsor.sponsorType.description}" /></td>
            </tr>
            <tr>
                <th style="padding-left: 24px;"><label>Sponsor Country:</label></th>
                <td><c:out value="${institutionalProposalObject.sponsor.countryCode}"/></td>
                <td colspan="2">&nbsp;</td>
            </tr>
            <tr>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr>
                <th><label>Originating (Prime) Sponsor:</label></th>
                <td colspan="3"><c:out value="${institutionalProposalObject.primeSponsor.sponsorName}" /></td>
            </tr>
            <tr>
                <th style="padding-left: 24px;"><kul:htmlAttributeLabel attributeEntry="${sponsorAttributes['sponsorType.description']}" /></th>
                <td colspan="3"><c:out value="${institutionalProposalObject.primeSponsor.sponsorType.description}" /></td>
            </tr>
            <tr>
                <th style="padding-left: 24px;"><label>Sponsor Country:</label></th>
                <td><c:out value="${institutionalProposalObject.primeSponsor.countryCode}"/></td>
                <td colspan="2">&nbsp;</td>
            </tr>
            <tr>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr>
                <td colspan="2">&nbsp;</td>
                <th><label>Total Budget:</label></th>
                <td><fmt:formatNumber
                        value="${institutionalProposalObject.totalCost}"
                        type="currency" currencySymbol="$" maxFractionDigits="2"/></td>
            </tr>
            <tr>
                <th><label>Project Start and End:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.requestedStartDateTotal"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.requestedStartDateTotal}"/> - <kul:htmlControlAttribute
                        property="${institutionalProposalPath}.requestedEndDateTotal"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.requestedEndDateTotal}"/></td>
                <th>&nbsp;</th>
                <td>&nbsp;</td>
            </tr>
            <tr>
                <td colspan="2">&nbsp;</td>
                <th><label>Total Co-sponsorship:</label></th>
                <td><fmt:formatNumber
                        value="${institutionalProposalObject.coSponsorTotal}"
                        type="currency" currencySymbol="$" maxFractionDigits="2"/></td>
            </tr>
            <tr>
                <th><label for="${institutionalProposalPath}.noticeOfOpportunityCode">Funding Opportunity Type:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.noticeOfOpportunityCode"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.noticeOfOpportunityCode}"/></td>
                <th><label for="${institutionalProposalPath}.coSponsorRatio">Leverage Ratio:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.coSponsorRatio"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.coSponsorRatio}"/></td>
            </tr>
            <tr>
                <td colspan="2">&nbsp;</td>
                <th><label for="${institutionalProposalPath}.hpcCoreHours">Total Co-sponsored HPC Core Hours:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.hpcCoreHours"
                        readOnly="true"
                        attributeEntry="${institutionalProposalAttributes.hpcCoreHours}"/></td>
            </tr>
            <tr>
                <th><label for="${institutionalProposalPath}.opportunity">Funding Opportunity Number:</label></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.opportunity"
                        attributeEntry="${institutionalProposalAttributes.opportunity}"
                        readOnly="true"/></td>
                <th><label>Cost Share:</label></th>
                <td><fmt:formatNumber
                        value="${institutionalProposalObject.costShareTotal}"
                        type="currency" currencySymbol="$" maxFractionDigits="2"/></td>
            </tr>
            <tr>
                <td colspan="4">&nbsp;</td>
            </tr>
            <tr>
                <th><label>Submission Date:</label></th>
                <td><c:out value="${institutionalProposalObject.createTimestamp}"/></td>
                <th><kul:htmlAttributeLabel attributeEntry="${institutionalProposalAttributes.awardTypeCode}" labelFor="${institutionalProposalPath}.awardTypeCode"/></th>
                <td><kul:htmlControlAttribute
                        property="${institutionalProposalPath}.awardTypeCode"
                        attributeEntry="${institutionalProposalAttributes.awardTypeCode}"
                        readOnly="true"/></td>
            </tr>
        </table>

    </div>
</kul:tab>
