<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>
<script type='text/javascript' src='dwr/interface/KraPersonService.js'></script>
<script type='text/javascript' src='dwr/interface/PersonService.js'></script>
<script type='text/javascript' src='dwr/util.js'></script>

<c:set var="exconProjectAttributes" value="${DataDictionary.ExconProject.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectAgreements" />

<kul:tabTop tabTitle="Basic Agreement Info" defaultOpen="true" tabErrorKey="document.exconProjectList[0].agreementRole,document.exconProjectList[0].respPartyUsername">

<div class="tab-container" align="center">

<h3>
	<span class="subhead-left">&nbsp;</span>
	<span class="subhead-right"><kul:help businessObjectClassName="org.kuali.kra.excon.project.ExconProject" altText="help"/></span>
</h3>
<table cellpAdding="0" cellspacing="0" summary="">
  	<tr>
    	<th width="25%">
    		<div align="right">
        		<kul:htmlAttributeLabel attributeEntry="${exconProjectAttributes.agreementRole}" labelFor="document.exconProjectList[0].agreementRole"/>
      		</div>
      	</th>
    	<td width="25%">
            <kul:htmlControlAttribute property="document.exconProjectList[0].agreementRole" attributeEntry="${exconProjectAttributes.agreementRole}" />
    	</td>
    	<th width="25%">
    		<div align="right"><kul:htmlAttributeLabel attributeEntry="${exconProjectAttributes.responsibleParty}" labelFor="document.exconProjectList[0].respPartyUsername"/></div>
    	</th>

		<td id="responsibleParty" class="grid" class="infoline">
			<c:if test="${!readOnly}">
				<kul:htmlControlAttribute
					property="document.exconProjectList[0].respPartyUsername"
					attributeEntry="${exconProjectAttributes.respPartyUsername}"
					onblur="loadContactPersonName('document.exconProjectList[0].respPartyUsername',
												'respPartyPerson.fullname',
												'na',
												'na',
												'na',
												'responsibleParty.div');"
					readOnly="${readOnly}" />
			</c:if>
			<c:if test="${readOnly}">${KualiForm.document.exconProjectList[0].respPartyUsername}</c:if>

			<c:if test="${!readOnly}">
				<kul:lookup boClassName="org.kuali.coeus.common.framework.person.KcPerson"
					fieldConversions="personId:userName:document.exconProjectList[0].responsibleParty,fullName:document.exconProjectList[0].respPartyName,userName:document.exconProjectList[0].respPartyUsername"
					lookupParameters="document.exconProjectList[0].respPartyUsername:userName"
					anchor="${tabKey}" />

			</c:if>
			<kul:directInquiry boClassName="org.kuali.coeus.common.framework.person.KcPerson" inquiryParameters="document.exconProjectList[0].responsibleParty:personId" anchor="${tabKey}" />
			<br/><span id="respPartyPerson.fullname"><c:out value="${KualiForm.document.exconProjectList[0].respPartyName}"/>&nbsp;</span>
			<html:hidden styleId ="responsibleParty.div" property="document.exconProjectList[0].responsibleParty" />
			${kfunc:registerEditableProperty(KualiForm, "document.exconProjectList[0].responsibleParty")}
		</td>
  	</tr>

</table>
</div>
</kul:tabTop>
