/*-
 * #%L
 * %%
 * Copyright (C) 2019 - 2020 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.research.gg.fetcher.fetch

import org.kuali.research.gg.fetcher.fetch.search.SearchParams
import org.kuali.research.gg.fetcher.fetch.search.SearchResults
import org.kuali.research.gg.fetcher.fetch.status.StatusResults
import org.springframework.core.io.Resource

interface GrantsGovFetchService {

    fun search(params: SearchParams): SearchResults
    fun status(): StatusResults

    // these apis return Maps because occasionally the formName or formVersion is a csv representing multiple files
    fun fetchPdf(formName: String, formVersion: String, formId: String): Map<String, Resource>
    fun fetchPdf(resourceName: String): Pair<String, Resource?>

    fun fetchDat(formName: String, formVersion: String, formId: String): Map<String, Resource>
    fun fetchDat(resourceName: String): Pair<String, Resource?>

    fun fetchInstructions(formName: String, formVersion: String, formId: String): Map<String, Resource>
    fun fetchInstructions(resourceName: String): Pair<String, Resource?>

    fun fetchSchema(formName: String, formVersion: String, formId: String): Map<String, Resource>
    fun fetchSchema(resourceName: String): Pair<String, Resource?>

    fun fetchNihXsl(formName: String, formVersion: String, formId: String): Map<String, Resource>
    fun fetchNihXsl(resourceName: String): Pair<String, Resource?>

    fun fetchXsl(formName: String, formVersion: String, formId: String): Map<String, Resource>
    fun fetchXsl(resourceName: String): Pair<String, Resource?>
}
