/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.gg.fetcher.fetch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.gg.fetcher.fetch.GrantsGovFetchService;
import org.kuali.research.gg.fetcher.fetch.GrantsGovFetchServiceImpl;
import org.kuali.research.gg.fetcher.fetch.search.SearchParams;
import org.kuali.research.gg.fetcher.fetch.search.SearchResults;
import org.kuali.research.gg.fetcher.fetch.status.StatusResults;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u000f\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J6\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0012J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0012J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0012J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0012J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0012J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0012J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0012J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0012J\u001e\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001e\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J,\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001e\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J,\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001e\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J,\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J,\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J0\u0010%\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\t0\n2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0012J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J0\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001f2\u001a\u0010-\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\n0.H\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00060"}, d2={"Lorg/kuali/research/gg/fetcher/fetch/GrantsGovFetchServiceImpl;", "Lorg/kuali/research/gg/fetcher/fetch/GrantsGovFetchService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Lorg/springframework/web/client/RestTemplate;)V", "getRestTemplate", "()Lorg/springframework/web/client/RestTemplate;", "cartesianProduct", "", "Lkotlin/Pair;", "", "names", "versions", "cleanSplit", "string", "delim", "createDatName", "formName", "formVersion", "formId", "createInstructionsName", "createNihXslName", "createPdfName", "createSchemaName", "createXslName", "fetch", "Lorg/springframework/core/io/Resource;", "url", "fetchDat", "resourceName", "", "fetchInstructions", "fetchNihXsl", "fetchPdf", "fetchSchema", "fetchXsl", "getNamesVersions", "search", "Lorg/kuali/research/gg/fetcher/fetch/search/SearchResults;", "params", "Lorg/kuali/research/gg/fetcher/fetch/search/SearchParams;", "status", "Lorg/kuali/research/gg/fetcher/fetch/status/StatusResults;", "toMap", "l", "", "Companion", "gg-fetcher"})
public class GrantsGovFetchServiceImpl
implements GrantsGovFetchService,
Logging {
    @NotNull
    private final RestTemplate restTemplate;
    private static final String FORMS_SEARCH_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/search/";
    private static final String FORMS_STATUS_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/report/status/";
    private static final String PDF_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/pdf/";
    private static final String INSTRUCTIONS_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/instructions/";
    private static final String SCHEMA_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/schema/";
    private static final String DAT_DOWNLOAD_ENDPOINT = "https://www.grants.gov/grantsws/rest/forms/download/dat/";
    private static final String PDF_BASE_URL = "https://apply07.grants.gov/apply/forms/sample/";
    private static final String DAT_BASE_URL = "https://apply07.grants.gov/apply/forms/sample/";
    private static final String INSTRUCTIONS_BASE_URL = "https://apply07.grants.gov/apply/forms/instructions/";
    private static final String SCHEMA_BASE_URL = "https://apply07.grants.gov/apply/forms/schemas/";
    private static final String NIH_XSL_BASE_URL = "https://grants.nih.gov/grants/ElectronicReceipt/files/";
    private static final String XSL_BASE_URL = "https://apply07.grants.gov/apply/forms/fo/";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public SearchResults search(@NotNull SearchParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        ResponseEntity responseEntity = this.getRestTemplate().postForEntity(FORMS_SEARCH_ENDPOINT, (Object)params, SearchResults.class, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"restTemplate.postForEnti\u2026earchResults::class.java)");
        Object object = responseEntity.getBody();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (SearchResults)object;
    }

    @NotNull
    public StatusResults status() {
        ResponseEntity responseEntity = this.getRestTemplate().getForEntity(FORMS_STATUS_ENDPOINT, StatusResults.class, new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"restTemplate.getForEntit\u2026tatusResults::class.java)");
        Object object = responseEntity.getBody();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (StatusResults)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Resource> fetchPdf(@NotNull String formName, @NotNull String formVersion, @NotNull String formId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair pair;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void names;
        Intrinsics.checkParameterIsNotNull((Object)formName, (String)"formName");
        Intrinsics.checkParameterIsNotNull((Object)formVersion, (String)"formVersion");
        Intrinsics.checkParameterIsNotNull((Object)formId, (String)"formId");
        Pair pair2 = this.getNamesVersions(formName, formVersion);
        Set set = (Set)pair2.component1();
        Set versions = (Set)pair2.component2();
        Set cp = this.cartesianProduct((Set)names, versions);
        Resource restResource = this.fetch(PDF_DOWNLOAD_ENDPOINT + formId);
        Iterable iterable = cp;
        GrantsGovFetchServiceImpl grantsGovFetchServiceImpl = this;
        boolean $i$f$map22 = false;
        void var11_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $dstr$name$version;
            Pair pair3 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = TuplesKt.to((Object)this.createPdfName(name, version), (Object)restResource);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Map restResources = grantsGovFetchServiceImpl.toMap((List)collection);
        Iterable $i$f$map22 = cp;
        grantsGovFetchServiceImpl = this;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$version;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = this.fetchPdf(this.createPdfName(name, version));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv2;
        Map pathResources = grantsGovFetchServiceImpl.toMap(collection);
        return MapsKt.plus((Map)restResources, (Map)pathResources);
    }

    @NotNull
    public Pair<String, Resource> fetchPdf(@NotNull String resourceName) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        return TuplesKt.to((Object)resourceName, (Object)this.fetch("https://apply07.grants.gov/apply/forms/sample/" + resourceName));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Resource> fetchDat(@NotNull String formName, @NotNull String formVersion, @NotNull String formId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair pair;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void names;
        Intrinsics.checkParameterIsNotNull((Object)formName, (String)"formName");
        Intrinsics.checkParameterIsNotNull((Object)formVersion, (String)"formVersion");
        Intrinsics.checkParameterIsNotNull((Object)formId, (String)"formId");
        Pair pair2 = this.getNamesVersions(formName, formVersion);
        Set set = (Set)pair2.component1();
        Set versions = (Set)pair2.component2();
        Set cp = this.cartesianProduct((Set)names, versions);
        Resource restResource = this.fetch(DAT_DOWNLOAD_ENDPOINT + formId);
        Iterable iterable = cp;
        GrantsGovFetchServiceImpl grantsGovFetchServiceImpl = this;
        boolean $i$f$map22 = false;
        void var11_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $dstr$name$version;
            Pair pair3 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = TuplesKt.to((Object)this.createDatName(name, version, formId), (Object)restResource);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Map restResources = grantsGovFetchServiceImpl.toMap((List)collection);
        Iterable $i$f$map22 = cp;
        grantsGovFetchServiceImpl = this;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$version;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = this.fetchDat(this.createDatName(name, version, formId));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv2;
        Map pathResources = grantsGovFetchServiceImpl.toMap(collection);
        return MapsKt.plus((Map)restResources, (Map)pathResources);
    }

    @NotNull
    public Pair<String, Resource> fetchDat(@NotNull String resourceName) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        return TuplesKt.to((Object)resourceName, (Object)this.fetch("https://apply07.grants.gov/apply/forms/sample/" + resourceName));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Resource> fetchInstructions(@NotNull String formName, @NotNull String formVersion, @NotNull String formId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair pair;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void names;
        Intrinsics.checkParameterIsNotNull((Object)formName, (String)"formName");
        Intrinsics.checkParameterIsNotNull((Object)formVersion, (String)"formVersion");
        Intrinsics.checkParameterIsNotNull((Object)formId, (String)"formId");
        Pair pair2 = this.getNamesVersions(formName, formVersion);
        Set set = (Set)pair2.component1();
        Set versions = (Set)pair2.component2();
        Set cp = this.cartesianProduct((Set)names, versions);
        Resource restResource = this.fetch(INSTRUCTIONS_DOWNLOAD_ENDPOINT + formId);
        Iterable iterable = cp;
        GrantsGovFetchServiceImpl grantsGovFetchServiceImpl = this;
        boolean $i$f$map22 = false;
        void var11_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $dstr$name$version;
            Pair pair3 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = TuplesKt.to((Object)this.createInstructionsName(name, version), (Object)restResource);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Map restResources = grantsGovFetchServiceImpl.toMap((List)collection);
        Iterable $i$f$map22 = cp;
        grantsGovFetchServiceImpl = this;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$version;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = this.fetchInstructions(this.createInstructionsName(name, version));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv2;
        Map pathResources = grantsGovFetchServiceImpl.toMap(collection);
        return MapsKt.plus((Map)restResources, (Map)pathResources);
    }

    @NotNull
    public Pair<String, Resource> fetchInstructions(@NotNull String resourceName) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        return TuplesKt.to((Object)resourceName, (Object)this.fetch(INSTRUCTIONS_BASE_URL + resourceName));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Resource> fetchSchema(@NotNull String formName, @NotNull String formVersion, @NotNull String formId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair pair;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void names;
        Intrinsics.checkParameterIsNotNull((Object)formName, (String)"formName");
        Intrinsics.checkParameterIsNotNull((Object)formVersion, (String)"formVersion");
        Intrinsics.checkParameterIsNotNull((Object)formId, (String)"formId");
        Pair pair2 = this.getNamesVersions(formName, formVersion);
        Set set = (Set)pair2.component1();
        Set versions = (Set)pair2.component2();
        Set cp = this.cartesianProduct((Set)names, versions);
        Resource restResource = this.fetch(SCHEMA_DOWNLOAD_ENDPOINT + formId);
        Iterable iterable = cp;
        GrantsGovFetchServiceImpl grantsGovFetchServiceImpl = this;
        boolean $i$f$map22 = false;
        void var11_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $dstr$name$version;
            Pair pair3 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = TuplesKt.to((Object)this.createSchemaName(name, version), (Object)restResource);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Map restResources = grantsGovFetchServiceImpl.toMap((List)collection);
        Iterable $i$f$map22 = cp;
        grantsGovFetchServiceImpl = this;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$version;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            pair = this.fetchSchema(this.createSchemaName(name, version));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv2;
        Map pathResources = grantsGovFetchServiceImpl.toMap(collection);
        return MapsKt.plus((Map)restResources, (Map)pathResources);
    }

    @NotNull
    public Pair<String, Resource> fetchSchema(@NotNull String resourceName) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        return TuplesKt.to((Object)resourceName, (Object)this.fetch(SCHEMA_BASE_URL + resourceName));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Resource> fetchNihXsl(@NotNull String formName, @NotNull String formVersion, @NotNull String formId) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void names;
        Intrinsics.checkParameterIsNotNull((Object)formName, (String)"formName");
        Intrinsics.checkParameterIsNotNull((Object)formVersion, (String)"formVersion");
        Intrinsics.checkParameterIsNotNull((Object)formId, (String)"formId");
        Pair pair = this.getNamesVersions(formName, formVersion);
        Set set = (Set)pair.component1();
        Set versions = (Set)pair.component2();
        Set cp = this.cartesianProduct((Set)names, versions);
        Iterable iterable = cp;
        GrantsGovFetchServiceImpl grantsGovFetchServiceImpl = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$version;
            Pair pair2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            Pair pair3 = this.fetchNihXsl(this.createNihXslName(name, version));
            collection.add(pair3);
        }
        collection = (List)destination$iv$iv;
        return grantsGovFetchServiceImpl.toMap((List)collection);
    }

    @NotNull
    public Pair<String, Resource> fetchNihXsl(@NotNull String resourceName) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        return TuplesKt.to((Object)resourceName, (Object)this.fetch(NIH_XSL_BASE_URL + resourceName));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, Resource> fetchXsl(@NotNull String formName, @NotNull String formVersion, @NotNull String formId) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void names;
        Intrinsics.checkParameterIsNotNull((Object)formName, (String)"formName");
        Intrinsics.checkParameterIsNotNull((Object)formVersion, (String)"formVersion");
        Intrinsics.checkParameterIsNotNull((Object)formId, (String)"formId");
        Pair pair = this.getNamesVersions(formName, formVersion);
        Set set = (Set)pair.component1();
        Set versions = (Set)pair.component2();
        Set cp = this.cartesianProduct((Set)names, versions);
        Iterable iterable = cp;
        GrantsGovFetchServiceImpl grantsGovFetchServiceImpl = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$name$version;
            Pair pair2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)$dstr$name$version.component1();
            String version = (String)$dstr$name$version.component2();
            Pair pair3 = this.fetchXsl(this.createXslName(name, version));
            collection.add(pair3);
        }
        collection = (List)destination$iv$iv;
        return grantsGovFetchServiceImpl.toMap((List)collection);
    }

    @NotNull
    public Pair<String, Resource> fetchXsl(@NotNull String resourceName) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        return TuplesKt.to((Object)resourceName, (Object)this.fetch(XSL_BASE_URL + resourceName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Resource fetch(String url) {
        try {
            boolean bl;
            byte[] contents;
            Resource $receiver;
            block8: {
                block7: {
                    ResponseEntity responseEntity = this.getRestTemplate().getForEntity(url, Resource.class, new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"restTemplate.getForEntit\u2026rl, Resource::class.java)");
                    Object object = responseEntity.getBody();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    $receiver = (Resource)object;
                    boolean bl4 = false;
                    if ($receiver == null || !$receiver.exists() || $receiver.contentLength() <= 0L) {
                        this.getLogger().info((CharSequence)("Resource not found at: " + url));
                        return null;
                    }
                    contents = $receiver.getInputStream().readAllBytes();
                    if (contents == null) break block7;
                    byte[] byArray = contents;
                    bl = false;
                    if (!(byArray.length == 0)) break block8;
                }
                this.getLogger().info((CharSequence)("Resource not found at: " + url));
                return null;
            }
            bl = false;
            String contentsStr = new String(contents, Charsets.UTF_8);
            if (StringsKt.contains$default((CharSequence)contentsStr, (CharSequence)"<!DOCTYPE html>", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)contentsStr, (CharSequence)"ErrorDetail.jsp", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)contentsStr, (CharSequence)"FormNamespaceRDDL.jsp", (boolean)false, (int)2, null)) {
                this.getLogger().info((CharSequence)("Resource not found at: " + url));
                return null;
            }
            this.getLogger().info((CharSequence)("Resource found at: " + url));
            Resource resource = $receiver;
            return resource;
        }
        catch (Exception e) {
            this.getLogger().info((CharSequence)("Resource not found at: " + url));
            Object var2_3 = null;
            return var2_3;
        }
    }

    @NotNull
    public Set<Pair<String, String>> cartesianProduct(@NotNull Set<String> names, @NotNull Set<String> versions) {
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        Intrinsics.checkParameterIsNotNull(versions, (String)"versions");
        boolean bl = false;
        Set product = new LinkedHashSet();
        Iterable $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name = (String)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = versions;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String version = (String)element$iv2;
                boolean bl3 = false;
                Collection collection = product;
                Pair pair = TuplesKt.to((Object)name, (Object)version);
                boolean bl4 = false;
                collection.add(pair);
            }
        }
        return product;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Resource> toMap(List<? extends Pair<String, ? extends Resource>> l) {
        void $this$mapTo$iv$iv;
        Pair $dstr$_u24__u24$v;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = l;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            $dstr$_u24__u24$v = (Pair)element$iv$iv;
            boolean bl = false;
            Resource v = (Resource)$dstr$_u24__u24$v.component2();
            if (v == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Resource v;
            void $dstr$k$v;
            $dstr$_u24__u24$v = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)$dstr$k$v.component1();
            Resource resource = v = (Resource)$dstr$k$v.component2();
            if (resource == null) {
                Intrinsics.throwNpe();
            }
            Pair pair = TuplesKt.to((Object)k, (Object)resource);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private Pair<Set<String>, Set<String>> getNamesVersions(String formName, String formVersion) {
        return TuplesKt.to((Object)this.cleanSplit(formName, ","), (Object)this.cleanSplit(formVersion, ","));
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> cleanSplit(String string, String delim) {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        CharSequence charSequence = string;
        String string2 = delim;
        int n = 0;
        string2 = new Regex(string2);
        n = 0;
        boolean bl = false;
        Iterable $this$map$iv = string2.split(charSequence, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_15 = it;
            boolean bl3 = false;
            void v0 = var12_15;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v0))).toString();
            collection.add(string4);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl4 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private String createPdfName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".pdf";
    }

    private String createDatName(String formName, String formVersion, String formId) {
        return formName + "-V" + formVersion + "_F" + formId + ".xls";
    }

    private String createInstructionsName(String formName, String formVersion) {
        return formName + "-V" + formVersion + "-Instructions.pdf";
    }

    private String createSchemaName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".xsd";
    }

    private String createNihXslName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".xsl";
    }

    private String createXslName(String formName, String formVersion) {
        return formName + "-V" + formVersion + ".fo.xsl";
    }

    @NotNull
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public GrantsGovFetchServiceImpl(@Autowired @NotNull RestTemplate restTemplate) {
        Intrinsics.checkParameterIsNotNull((Object)restTemplate, (String)"restTemplate");
        this.restTemplate = restTemplate;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

