<?xml version="1.0" encoding="UTF-8"?><!-- $Revision:   1.2  $ -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:COPS_Budget="http://apply.grants.gov/forms/COPS_Budget-V1.1">
   <xsl:output method="xml" indent="yes"/>
   <xsl:template match="/">
      <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0">
         <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in" margin-right="0.2in">
               <fo:region-body margin-top="0.2in" margin-bottom="0.4in"/>
               <fo:region-after extent="0.3in"/>
            </fo:simple-page-master>
         </fo:layout-master-set>
          
         <!-- page 1 -->
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.666666666666667px" hyphenate="true" language="en" keep-together="always" top="84.24242424242425px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_officers_requested-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="77.57575757575758px" hyphenate="true" language="en" keep-together="always" top="481.21212121212125px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_officers_requested) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_officers_requested = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_officers_requested, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named ProgramName_COPSInSchools-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="81.21212121212122px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:ProgramName"/>
                              <xsl:with-param name="schemaChoice">COPSInSchools</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named ProgramName_TribalPrograms-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="81.21212121212122px" hyphenate="true" language="en" keep-together="always" top="224.24242424242425px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:ProgramName"/>
                              <xsl:with-param name="schemaChoice">TribalPrograms</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named ProgramName_UniversalHiringProgram-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="81.21212121212122px" hyphenate="true" language="en" keep-together="always" top="240.60606060606062px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:ProgramName"/>
                              <xsl:with-param name="schemaChoice">UniversalHiringProgram</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named ProgramName_CommunityPolicingDevelopmentPrograms-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="81.21212121212122px" hyphenate="true" language="en" keep-together="always" top="256.969696969697px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:ProgramName"/>
                              <xsl:with-param name="schemaChoice">CommunityPolicingDevelopmentPrograms</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
              <!--Block below is for the field named part_time_officers_requested-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="178.1818181818182px" hyphenate="true" language="en" keep-together="always" top="481.21212121212125px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_officers_requested) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_officers_requested = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_officers_requested, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named ProgramName_TargetedPrograms-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="279.39393939393943px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:ProgramName"/>
                              <xsl:with-param name="schemaChoice">TargetedPrograms</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named ProgramName_InteroperableCommunicationsTechnologyProgram-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="279.39393939393943px" hyphenate="true" language="en" keep-together="always" top="224.24242424242425px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:ProgramName"/>
                              <xsl:with-param name="schemaChoice">InteroperableCommunicationsTechnologyProgram</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named ProgramName_SecureOurSchools-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="279.39393939393943px" hyphenate="true" language="en" keep-together="always" top="240.60606060606062px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:ProgramName"/>
                              <xsl:with-param name="schemaChoice">SecureOurSchools</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named pt_avg_hrs_per_wk-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="373.33333333333337px" hyphenate="true" language="en" keep-together="always" top="574.5454545454546px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:pt_avg_hrs_per_wk) or //COPS_Budget:COPS_Budget/COPS_Budget:pt_avg_hrs_per_wk = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:pt_avg_hrs_per_wk, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named pt_hours_fulltime-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="373.33333333333337px" hyphenate="true" language="en" keep-together="always" top="590.909090909091px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:pt_hours_fulltime) or //COPS_Budget:COPS_Budget/COPS_Budget:pt_hours_fulltime = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:pt_hours_fulltime, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named pt_hours_per_yr-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="373.33333333333337px" hyphenate="true" language="en" keep-together="always" top="607.8787878787879px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:pt_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:pt_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:pt_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named pt_hourly_rate-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="373.33333333333337px" hyphenate="true" language="en" keep-together="always" top="625.4545454545455px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:pt_hourly_rate) or //COPS_Budget:COPS_Budget/COPS_Budget:pt_hourly_rate = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:pt_hourly_rate, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="498.7878787878788px" hyphenate="true" language="en" keep-together="always" top="84.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named no_officer_personnel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="552.1212121212121px" hyphenate="true" language="en" keep-together="always" top="303.03030303030306px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="552.1212121212121px" hyphenate="true" language="en" keep-together="always" top="300px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:no_officer_personnel) or //COPS_Budget:COPS_Budget/COPS_Budget:no_officer_personnel = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:no_officer_personnel"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named ApplicantOrganization_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.666666666666667px" hyphenate="true" language="en" keep-together="always" top="67.87878787878788px" height="13.333333333333334px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named SwornOfficerPositionsSectionTitle-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.666666666666667px" hyphenate="true" language="en" keep-together="always" top="302px" height="15.757575757575758px" width="138.1818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">A. Sworn Officer Positions</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeHoursInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.363636363636363px" hyphenate="true" language="en" keep-together="always" top="659.3939393939394px" height="23.03030303030303px" width="535.7575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">To calculate the base salary amount for part-time officers, multiply the hourly rate by the average number of hours per year that the part-time COPS-funded officer will work. You will enter this base salary on page 4.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="17.575757575757578px" hyphenate="true" language="en" keep-together="always" top="686.0606060606061px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">Note: </fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeHoursNote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="17.575757575757578px" hyphenate="true" language="en" keep-together="always" top="696.969696969697px" height="42.42424242424243px" width="527.2727272727273px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">particular COPS hiring program.  For example, "COPS in Schools" has a maximum federal share of $125,000.  The part-time federal funding cap would be calculated as follows: 20 hours/40 hour week = .5 full-time equivalent; part-time federal share cap = .5 X $125,000 (maximum allowed) = $62,500.  "The Universal Hiring Program" has a maximum federal share of $75,000.  The part-time federal funding cap would be calculated as follows: 20 hours/40 hour week = .5 full-time equivalent; part-time federal share cap = .5 X $75,000 (maximum allowed) = $37,500.</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeHoursSectionInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.212121212121215px" hyphenate="true" language="en" keep-together="always" top="538.1818181818182px" height="13.333333333333334px" width="247.27272727272728px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Please complete if your agency is requesting part-time officers:</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeHoursLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.212121212121215px" hyphenate="true" language="en" keep-together="always" top="558.7878787878789px" height="13.333333333333334px" width="75.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part-Time Hours:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.81818181818182px" hyphenate="true" language="en" keep-together="always" top="321.21212121212125px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL9-->
                <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.81818181818182px" hyphenate="true" language="en" keep-together="always" top="331.51515151515156px" height="12.121212121212121px" width="120px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">thirty-six (36) months. </fo:block>
               </fo:block-container><fo:block-container background-color="transparent" border-style="none" position="absolute" left="22.424242424242426px" hyphenate="true" language="en" keep-together="always" top="341.8181818181818px" height="12.121212121212121px" width="323.6363636363636px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">This worksheet will assist your agency in properly organizing your</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="22.424242424242426px" hyphenate="true" language="en" keep-together="always" top="352.1212121212121px" height="12.121212121212121px" width="527.2727272727273px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">financial details for review by the COPS Office. Please list the entry-level base salary and fringe benefits</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
              <!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.81818181818182px" hyphenate="true" language="en" keep-together="always" top="418.7878787878788px" height="23.03030303030303px" width="536.969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">Complete part 1 if you are requesting funds for full-time officer positions; part 2 if you are requesting part-time officer positions; and both parts 1 and 2 if you are requesting full and part-time officer positions.</fo:block>
               </fo:block-container><!--Block below is for the label named OfficerPositionsRequestedLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.81818181818182px" hyphenate="true" language="en" keep-together="always" top="460px" height="13.333333333333334px" width="131.51515151515153px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Officer Positions Requested:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
             <!--Block below is for the label named SwornOfficerPositionsSectionInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="22.424242424242426px" hyphenate="true" language="en" keep-together="always" top="363.03030303030306px" height="32.72727272727273px" width="541.8181818181819px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">for one sworn officer position within your agency. COPS hiring funds may also be used to pay for entry-level salaries and benefits of newly-hired, additional officers who will backfill the positions of locally-funded veteran officers that will be deployed into community policing specialty areas (i.e., School Resource Officers).</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_officers_requested_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="26.666666666666668px" hyphenate="true" language="en" keep-together="always" top="481.21212121212125px" height="13.333333333333334px" width="49.09090909090909px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Full-time:</fo:block>
               </fo:block-container><!--Block below is for the label named OfficerPositionsRequestedInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="26.666666666666668px" hyphenate="true" language="en" keep-together="always" top="496.3636363636364px" height="32.72727272727273px" width="531.5151515151515px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">Enter the number of new, entry-level full-time and/or part-time officer positions that are being requested. Do not include any officers already funded (or for which funding has been requested) under any other COPS grants or any positions otherwise funded with state, local, tribal, or BIA funds. Your request should be consistent with your agency's law enforcement needs. Do not request more positions than your agency can support and retain.</fo:block>
               </fo:block-container><!--Block below is for the label named pt_hours_per_yr_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="36.36363636363637px" hyphenate="true" language="en" keep-together="always" top="607.8787878787879px" height="13.333333333333334px" width="333.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* What is the average number of hours per year that your part-time COPS officer will work?</fo:block>
               </fo:block-container><!--Block below is for the label named pt_hourly_rate_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="36.36363636363637px" hyphenate="true" language="en" keep-together="always" top="625.4545454545455px" height="13.333333333333334px" width="215.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* What is the hourly rate for the part-time COPS officer?</fo:block>
               </fo:block-container><!--Block below is for the label named pt_avg_hrs_per_wk_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="36.96969696969697px" hyphenate="true" language="en" keep-together="always" top="574.5454545454546px" height="13.333333333333334px" width="331.51515151515156px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* What is the average number of hours per week that your part-time COPS officer will work?</fo:block>
               </fo:block-container><!--Block below is for the label named pt_hours_fulltime_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="36.96969696969697px" hyphenate="true" language="en" keep-together="always" top="590.909090909091px" height="13.333333333333334px" width="240px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* How many hours per week is considered full-time employment?</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="41.21212121212121px" hyphenate="true" language="en" keep-together="always" top="686.0606060606061px" height="13.333333333333334px" width="502.42424242424244px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">There is a funding cap for part-time officers in proportion to the number of hours worked and the maximum federal funding allowed under a</fo:block>
               </fo:block-container>
<fo:block-container background-color="transparent" border-style="none" position="absolute" left="95px" hyphenate="true" language="en" keep-together="always" top="381.5px" height="13.333333333333334px" width="170.9090909090909px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Do not include employee contributions.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="72.12121212121212px" hyphenate="true" language="en" keep-together="always" top="321.21212121212125px" height="13.333333333333334px" width="492.1212121212121px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">COPS hiring grant programs pay for entry-level salaries and benefits of newly hired, additional sworn law enforcement officers for a period of</fo:block>
               </fo:block-container><!--Block below is for the label named ProgramName_COPSInSchools_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="92.12121212121212px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="90.30303030303031px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">COPS in Schools</fo:block>
               </fo:block-container><!--Block below is for the label named ProgramName_TribalPrograms_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="92.12121212121212px" hyphenate="true" language="en" keep-together="always" top="224.24242424242425px" height="13.333333333333334px" width="89.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Tribal Programs</fo:block>
               </fo:block-container><!--Block below is for the label named ProgramName_UniversalHiringProgram_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="92.12121212121212px" hyphenate="true" language="en" keep-together="always" top="240.60606060606062px" height="13.333333333333334px" width="117.57575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Universal Hiring Program</fo:block>
               </fo:block-container><!--Block below is for the label named ProgramName_CommunityPolicingDevelopmentPrograms_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="92.12121212121212px" hyphenate="true" language="en" keep-together="always" top="256.969696969697px" height="13.333333333333334px" width="188.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Community Policing Development Programs</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="104.24242424242425px" hyphenate="true" language="en" keep-together="always" top="177.5757575757576px" height="12.121212121212121px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">* Please select the funding category that was selected on the COPS Application Attachment to SF-424.</fo:block>
               </fo:block-container><!--Block below is for the label named COPSFundingRequestInstruction-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="104.84848484848486px" hyphenate="true" language="en" keep-together="always" top="153.93939393939394px" height="13.333333333333334px" width="360.6060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Federal assistance is being requested under the following COPS Office funding category:</fo:block>
               </fo:block-container><!--Block below is for the label named part_time_officers_requested_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="129.69696969696972px" hyphenate="true" language="en" keep-together="always" top="481.21212121212125px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Part-time:</fo:block>
               </fo:block-container><!--Block below is for the label named title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="173.93939393939394px" hyphenate="true" language="en" keep-together="always" top="30.90909090909091px" height="20.606060606060606px" width="222.42424242424244px">
                  <fo:block background-color="transparent" color="#000000" font-size="14pt" font-style="normal" font-family="Helvetica" font-weight="bold">BUDGET DETAIL WORKSHEETS</fo:block>
               </fo:block-container><!--Block below is for the label named COPSFundingRequestSection-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="231.51515151515153px" hyphenate="true" language="en" keep-together="always" top="134.54545454545456px" height="13.333333333333334px" width="107.87878787878789px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">COPS FUNDING REQUEST</fo:block>
               </fo:block-container><!--Block below is for the label named ProgramName_TargetedPrograms_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="290.3030303030303px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="90.30303030303031px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Targeted Programs</fo:block>
               </fo:block-container><!--Block below is for the label named ProgramName_InteroperableCommunicationsTechnologyProgram_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="290.3030303030303px" hyphenate="true" language="en" keep-together="always" top="224.24242424242425px" height="13.333333333333334px" width="209.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Interoperable Communications Technology Program</fo:block>
               </fo:block-container><!--Block below is for the label named ProgramName_SecureOurSchools_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="290.3030303030303px" hyphenate="true" language="en" keep-together="always" top="240.60606060606062px" height="13.333333333333334px" width="94.54545454545455px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Secure our Schools</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="255.75757575757578px" hyphenate="true" language="en" keep-together="always" top="341.8181818181818px" height="12.121212121212121px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">maximum estimated</fo:block>
               </fo:block-container><!--Block below is for the label named no_officer_personnel_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="397.5757575757576px" hyphenate="true" language="en" keep-together="always" top="303.030303030303065px" height="13.333333333333334px" width="151.51515151515153px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No Sworn Officer Positions Requested</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="335.1515151515152px" hyphenate="true" language="en" keep-together="always" top="341.8181818181818px" height="13.333333333333334px" width="190.3030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">salary and benefit costs and providing the necessary </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="392px" hyphenate="true" language="en" keep-together="always" top="352.1212121212121px" height="13.333333333333334px" width="139.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">rounded to the nearest whole dollar</fo:block>
               </fo:block-container>


<!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="450.90909090909093px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named omb_number-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="498.7878787878788px" hyphenate="true" language="en" keep-together="always" top="67.87878787878788px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
          
         <!-- page 2 -->
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named full_time_total_fringe_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="98.7878787878788px" hyphenate="true" language="en" keep-together="always" top="398.7878787878788px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_total_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_base_salary_amount_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="175.15151515151516px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_base_salary_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_social_security_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_social_security_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_medicare_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_health_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_health_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_life_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="258.1818181818182px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_life_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_vacation_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_sick_leave_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_retirement_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_retirement_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_workers_comp_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_unemployment_ins_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_unemployment_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_other1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other1_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_other2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other2_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_base_salary_amount_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="471.51515151515156px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_base_salary_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_social_security_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="510.90909090909093px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_social_security_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_medicare_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="527.2727272727273px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_health_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="543.6363636363636px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_health_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_life_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="560px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_life_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_vacation_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="576.3636363636364px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_sick_leave_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="592.7272727272727px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_retirement_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="609.0909090909091px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_retirement_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_workers_comp_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="625.4545454545455px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_unemployment_ins_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="641.8181818181819px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_unemployment_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_other1_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="658.1818181818182px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other1_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_other2_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="684.2424242424242px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other2_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_total_fringe_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="700.6060606060606px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_total_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_total_base_salary_and_fringe_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="143.63636363636365px" hyphenate="true" language="en" keep-together="always" top="718.7878787878789px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_total_base_salary_and_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_total_base_salary_and_fringe_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="147.87878787878788px" hyphenate="true" language="en" keep-together="always" top="416.969696969697px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_total_base_salary_and_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_other2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other2_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_social_security_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="510.90909090909093px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_social_security_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_medicare_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="527.2727272727273px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_health_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="543.6363636363636px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_life_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="560px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_vacation_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="576.3636363636364px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_sick_leave_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="592.7272727272727px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_retirement_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="609.0909090909091px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_retirement_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_workers_comp_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="625.4545454545455px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_unemployment_ins_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="641.8181818181819px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_other1_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="658.1818181818182px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other1_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_other2_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="684.2424242424242px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other2_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_medicare_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_health_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_life_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="258.1818181818182px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_vacation_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_sick_leave_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_retirement_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_retirement_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_workers_comp_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_unemployment_ins_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_other1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other1_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_social_security_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.6666666666667px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_social_security_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_full_time_fringe_other1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="361.21212121212125px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_description_fringe_other1) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_full_time_fringe_other2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="361.21212121212125px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_description_fringe_other2) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_full_time_fringe_other2_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="361.8181818181818px" hyphenate="true" language="en" keep-together="always" top="658.1818181818182px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_description_fringe_other1) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_full_time_fringe_other1_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="362.42424242424244px" hyphenate="true" language="en" keep-together="always" top="685.4545454545455px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_description_fringe_other2) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named full_time_family_coverage_yes_2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="417.5757575757576px" hyphenate="true" language="en" keep-together="always" top="542.4242424242425px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named full_time_family_coverage_yes_1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_vacation_hours_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_hours) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_sick_leave_hours_per_yr_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.93939393939394px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_vacation_hours_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="575.1515151515151px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_hours) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_sick_leave_hours_per_yr_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="590.3030303030304px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named full_time_family_coverage_no_1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="476.3636363636364px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named full_time_family_coverage_no_2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="476.3636363636364px" hyphenate="true" language="en" keep-together="always" top="544.2424242424242px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named full_time_medicare_exempt_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.06060606060606px" hyphenate="true" language="en" keep-together="always" top="527.2727272727273px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.06060606060606px" hyphenate="true" language="en" keep-together="always" top="524.2424242424242px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named full_time_soc_sec_exempt_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.6666666666667px" hyphenate="true" language="en" keep-together="always" top="510.90909090909093px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.6666666666667px" hyphenate="true" language="en" keep-together="always" top="507.87878787878793px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_soc_sec_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[2]/COPS_Budget:full_time_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named full_time_soc_sec_exempt_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_soc_sec_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named full_time_medicare_exempt_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="222.42424242424244px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[1]/COPS_Budget:full_time_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="100.60606060606061px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.484848484848484px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="12.121212121212121px" width="66.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_other2_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="398.7878787878788px" height="13.333333333333334px" width="87.27272727272728px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_2_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="416.969696969697px" height="13.333333333333334px" width="136.36363636363637px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Year 1 Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerYear2Title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="452.1212121212121px" height="13.333333333333334px" width="338.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 2: Current Annual Entry-Level 2nd Year Base Salary and Annual Fringe Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="471.51515151515156px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="510.90909090909093px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="527.2727272727273px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="543.6363636363636px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="560px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="576.3636363636364px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="592.7272727272727px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="609.0909090909091px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="625.4545454545455px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="641.8181818181819px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="658.1818181818182px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="684.2424242424242px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_2_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="700.6060606060606px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_3_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="718.7878787878789px" height="13.333333333333334px" width="132.12121212121212px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Year 2 Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerYear1Title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="153.93939393939394px" height="13.333333333333334px" width="328.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 1: Current Annual Entry-Level 1st Year Base Salary and Annual Fringe Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_base_salary_amount_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="175.15151515151516px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_social_security_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="209.0909090909091px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_medicare_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_health_insurance_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_life_insurance_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="258.1818181818182px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_vacation_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_sick_leave_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_retirement_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_workers_comp_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_unemployment_ins_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_other1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_FringeBenefitColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="495.7575757575758px" height="13.333333333333334px" width="66.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL29-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="17.575757575757578px" hyphenate="true" language="en" keep-together="always" top="193.93939393939394px" height="13.333333333333334px" width="65.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionFootnote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.72727272727273px" hyphenate="true" language="en" keep-together="always" top="750px" height="13.333333333333334px" width="478.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">If no funds are budgeted for Social Security, Medicare, Workers Compensation or Unemployment please see Part 3 number 2.</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="58.78787878787879px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="307.2727272727273px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Please indicate the law enforcement agency's cost for each of the following categories.</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_CostColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="495.7575757575758px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL30-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="166.06060606060606px" hyphenate="true" language="en" keep-together="always" top="193.93939393939394px" height="13.333333333333334px" width="35.151515151515156px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionTitle-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="215.75757575757578px" hyphenate="true" language="en" keep-together="always" top="122.42424242424244px" height="15.757575757575758px" width="175.75757575757578px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part 1: Full-Time Officer Information</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_BaseColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="264.24242424242425px" hyphenate="true" language="en" keep-together="always" top="495.7575757575758px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="193.93939393939394px" height="13.333333333333334px" width="41.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base</fo:block>
               </fo:block-container><!--Block below is for the label named description_full_time_fringe_other1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="315.75757575757575px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="43.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named description_full_time_fringe_other2_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="315.75757575757575px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="13.333333333333334px" width="43.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL28-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="315.75757575757575px" hyphenate="true" language="en" keep-together="always" top="684.2424242424242px" height="13.333333333333334px" width="44.24242424242424px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL27-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.3636363636364px" hyphenate="true" language="en" keep-together="always" top="658.1818181818182px" height="13.333333333333334px" width="43.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL33-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="13.333333333333334px" width="95.75757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL34-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="95.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named FLABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_vacation_hours_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_sick_leave_hours_per_yr_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_SocialSecurityPctBaseExceedLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="510.90909090909093px" height="13.333333333333334px" width="95.75757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_MedicarePctBaseExceedLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="527.2727272727273px" height="13.333333333333334px" width="93.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL24-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="543.6363636363636px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL25-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="576.3636363636364px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL26-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="592.7272727272727px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="368px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="197.5757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Please do not include employee contribution costs.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="384.8484848484849px" hyphenate="true" language="en" keep-together="always" top="193.33333333333334px" height="13.333333333333334px" width="92.12121212121212px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_AdditionalInformationColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="388.4848484848485px" hyphenate="true" language="en" keep-together="always" top="495.1515151515152px" height="13.333333333333334px" width="120px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_soc_sec_exempt_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_medicare_exempt_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL20-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="510.90909090909093px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL21-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="527.2727272727273px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_family_coverage_yes_1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.8787878787879px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL22-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.8787878787879px" hyphenate="true" language="en" keep-together="always" top="543.6363636363636px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="450.90909090909093px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_family_coverage_no_1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="486.06060606060606px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL23-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="486.06060606060606px" hyphenate="true" language="en" keep-together="always" top="543.6363636363636px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                   <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
          
         <!-- page 3 -->
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named full_time_base_salary_amount_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="192.72727272727275px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_base_salary_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_social_security_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="233.33333333333334px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_social_security_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_medicare_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="249.69696969696972px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_health_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_health_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_life_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="282.42424242424244px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_life_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_vacation_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="298.7878787878788px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_sick_leave_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="315.1515151515152px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_retirement_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="331.51515151515156px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_retirement_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_workers_comp_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="347.8787878787879px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_unemployment_ins_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="364.24242424242425px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_unemployment_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_other1_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="380.6060606060606px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other1_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_benefit_amount_other2_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="406.6666666666667px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other2_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_total_fringe_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="423.03030303030306px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_total_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_total_base_salary_and_fringe_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="143.03030303030303px" hyphenate="true" language="en" keep-together="always" top="443.03030303030306px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_total_base_salary_and_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_medicare_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="249.69696969696972px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_health_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_life_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="282.42424242424244px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_vacation_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="298.7878787878788px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_sick_leave_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="315.1515151515152px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_retirement_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="331.51515151515156px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_retirement_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_workers_comp_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="347.2727272727273px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_unemployment_ins_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="364.24242424242425px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_other1_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="380.6060606060606px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other1_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_other2_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="406.06060606060606px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other2_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_fringe_pct_base_salary_social_security_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="270.3030303030303px" hyphenate="true" language="en" keep-together="always" top="233.33333333333334px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_social_security_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_full_time_fringe_other1_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.06060606060606px" hyphenate="true" language="en" keep-together="always" top="380.6060606060606px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_description_fringe_other1) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_full_time_fringe_other2_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.06060606060606px" hyphenate="true" language="en" keep-together="always" top="406.6666666666667px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_description_fringe_other2) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named full_time_family_coverage_yes_3_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_vacation_hours_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="423.6363636363637px" hyphenate="true" language="en" keep-together="always" top="298.7878787878788px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_hours) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named full_time_sick_leave_hours_per_yr_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="423.6363636363637px" hyphenate="true" language="en" keep-together="always" top="315.1515151515152px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named full_time_family_coverage_no_3_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="480.6060606060606px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named full_time_soc_sec_exempt_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="233.33333333333334px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="230.3030303030303px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_soc_sec_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named full_time_medicare_exempt_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="249.69696969696972px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="246.66666666666669px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:full_time_bsalary_fbenefits[3]/COPS_Budget:full_time_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="99.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                 <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.484848484848484px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="12.121212121212121px" width="66.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerYear3Title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="171.51515151515153px" height="13.93939393939394px" width="332.72727272727275px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 3: Current Annual Entry-Level 3rd Year Base Salary and Annual Fringe Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="443.03030303030306px" height="13.333333333333334px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Year 3 Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="192.72727272727275px" height="13.333333333333334px" width="64.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="233.33333333333334px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="249.69696969696972px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="282.42424242424244px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="298.7878787878788px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="315.1515151515152px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="331.51515151515156px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="347.8787878787879px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="364.24242424242425px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL20-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="380.6060606060606px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL21-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="406.6666666666667px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_2_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="423.03030303030306px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.212121212121215px" hyphenate="true" language="en" keep-together="always" top="216.96969696969697px" height="13.333333333333334px" width="63.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionFootnote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.72727272727273px" hyphenate="true" language="en" keep-together="always" top="750px" height="13.333333333333334px" width="478.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">If no funds are budgeted for Social Security, Medicare, Workers Compensation or Unemployment please see Part 3 number 2.</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="58.18181818181819px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="309.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Please indicate the law enforcement agency's cost for each of the following categories.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="169.69696969696972px" hyphenate="true" language="en" keep-together="always" top="216.96969696969697px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="194.54545454545456px" hyphenate="true" language="en" keep-together="always" top="124.24242424242425px" height="15.757575757575758px" width="214.54545454545456px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part 1: Full-Time Officer Information (cont'd)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="216.96969696969697px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL30-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="320px" hyphenate="true" language="en" keep-together="always" top="406.6666666666667px" height="13.333333333333334px" width="43.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL29-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="320.6060606060606px" hyphenate="true" language="en" keep-together="always" top="380.6060606060606px" height="13.333333333333334px" width="44.24242424242424px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="233.33333333333334px" height="13.333333333333334px" width="90.90909090909092px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="249.69696969696972px" height="13.333333333333334px" width="92.12121212121212px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL26-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL27-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="298.7878787878788px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL28-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="315.1515151515152px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL36-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="367px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="197.5757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Please do not include employee contribution costs.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="392.72727272727275px" hyphenate="true" language="en" keep-together="always" top="216.36363636363637px" height="13.333333333333334px" width="116.36363636363637px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL22-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="233.33333333333334px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL23-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="249.69696969696972px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL24-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="432.1212121212121px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="450.90909090909093px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL25-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="490.3030303030303px" hyphenate="true" language="en" keep-together="always" top="266.06060606060606px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
          
         <!-- page 4 -->
        
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named part_time_total_fringe_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="98.7878787878788px" hyphenate="true" language="en" keep-together="always" top="398.7878787878788px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_total_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_base_salary_amount_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="175.15151515151516px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_base_salary_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_social_security_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_social_security_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_medicare_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_health_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_health_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_life_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="258.1818181818182px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_life_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_vacation_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_sick_leave_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_retirement_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_retirement_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_workers_comp_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_unemployment_ins_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_unemployment_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_other1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="164.24242424242425px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other1_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_other2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other2_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_base_salary_amount_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="468.4848484848485px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_base_salary_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_social_security_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="507.87878787878793px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_social_security_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_medicare_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="524.2424242424242px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_health_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="540.6060606060606px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_health_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_life_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="556.969696969697px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_life_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_vacation_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="573.3333333333334px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_sick_leave_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="589.6969696969697px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_retirement_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="606.0606060606061px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_retirement_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_workers_comp_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="622.4242424242425px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_unemployment_ins_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="638.7878787878789px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_unemployment_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_other1_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="655.1515151515152px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other1_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_other2_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="681.2121212121212px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other2_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_total_fringe_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="99.3939393939394px" hyphenate="true" language="en" keep-together="always" top="697.5757575757576px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_total_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_total_base_salary_and_fringe_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="143.63636363636365px" hyphenate="true" language="en" keep-together="always" top="715.7575757575758px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_total_base_salary_and_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_total_base_salary_and_fringe_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="147.87878787878788px" hyphenate="true" language="en" keep-together="always" top="416.969696969697px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_total_base_salary_and_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_other2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other2_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_social_security_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="507.87878787878793px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_social_security_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_medicare_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="524.2424242424242px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_health_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="540.6060606060606px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_life_insurance_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="556.969696969697px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_vacation_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="573.3333333333334px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_sick_leave_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="589.6969696969697px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_retirement_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="606.0606060606061px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_retirement_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_workers_comp_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="622.4242424242425px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_unemployment_ins_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="638.7878787878789px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_other1_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="655.1515151515152px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other1_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_other2_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="681.2121212121212px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other2_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_medicare_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_health_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_life_insurance_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="258.1818181818182px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_vacation_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_sick_leave_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_retirement_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_retirement_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_workers_comp_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_unemployment_ins_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_other1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other1_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_social_security_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.6666666666667px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_social_security_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_part_time_fringe_other2_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="362.42424242424244px" hyphenate="true" language="en" keep-together="always" top="653.939393939394px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_description_fringe_other1) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_part_time_fringe_other1_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="362.42424242424244px" hyphenate="true" language="en" keep-together="always" top="680px" height="23.03030303030303px" width="207.8787878787879px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_description_fringe_other2) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_part_time_fringe_other1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="363.6363636363637px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_description_fringe_other1) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_part_time_fringe_other2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="363.6363636363637px" hyphenate="true" language="en" keep-together="always" top="382.42424242424244px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_description_fringe_other2) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named part_time_family_coverage_yes_2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="417.5757575757576px" hyphenate="true" language="en" keep-together="always" top="539.3939393939394px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named part_time_family_coverage_yes_1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_vacation_hours_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_hours) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_sick_leave_hours_per_yr_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.93939393939394px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_vacation_hours_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="572.1212121212121px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_hours) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_sick_leave_hours_per_yr_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="587.2727272727273px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named part_time_family_coverage_no_1_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="476.3636363636364px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named part_time_family_coverage_no_2_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="476.3636363636364px" hyphenate="true" language="en" keep-together="always" top="540px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named part_time_medicare_exempt_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.06060606060606px" hyphenate="true" language="en" keep-together="always" top="523.6363636363636px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.06060606060606px" hyphenate="true" language="en" keep-together="always" top="520.6060606060606px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named part_time_soc_sec_exempt_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.6666666666667px" hyphenate="true" language="en" keep-together="always" top="507.2727272727273px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="506.6666666666667px" hyphenate="true" language="en" keep-together="always" top="504.24242424242425px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_soc_sec_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[2]/COPS_Budget:part_time_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named part_time_soc_sec_exempt_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="208.4848484848485px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="205.45454545454547px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_soc_sec_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named part_time_medicare_exempt_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="511.51515151515156px" hyphenate="true" language="en" keep-together="always" top="222.42424242424244px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[1]/COPS_Budget:part_time_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="103.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.484848484848484px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="12.121212121212121px" width="66.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="398.7878787878788px" height="13.333333333333334px" width="87.27272727272728px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_2_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="416.969696969697px" height="13.333333333333334px" width="136.36363636363637px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Year 1 Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerYear2Title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="448.4848484848485px" height="13.333333333333334px" width="334.54545454545456px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 2: Current Annual Entry-Level 2nd Year Base Salary and Annual Fringe Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="467.87878787878793px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="507.2727272727273px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="523.6363636363636px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="540px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="556.3636363636364px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="572.7272727272727px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="589.0909090909091px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="605.4545454545455px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="621.8181818181819px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="638.1818181818182px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="654.5454545454546px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="680.6060606060606px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_2_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="696.969696969697px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_3_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="715.1515151515152px" height="13.333333333333334px" width="132.12121212121212px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Year 2 Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerYear1Title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="153.93939393939394px" height="13.333333333333334px" width="343.03030303030306px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 1: Current Annual Entry-Level 1st Year Base Salary and Annual Fringe Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_base_salary_amount_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="175.15151515151516px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_social_security_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="209.0909090909091px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_medicare_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_health_insurance_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_life_insurance_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="258.1818181818182px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_vacation_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_sick_leave_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_retirement_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_workers_comp_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_unemployment_ins_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_other1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_fringe_benefit_amount_other2_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.696969696969697px" hyphenate="true" language="en" keep-together="always" top="381.8181818181818px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_FringeBenefitColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="492.1212121212121px" height="13.333333333333334px" width="60px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL29-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="17.575757575757578px" hyphenate="true" language="en" keep-together="always" top="193.93939393939394px" height="13.333333333333334px" width="66.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionFootnote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.72727272727273px" hyphenate="true" language="en" keep-together="always" top="750px" height="13.333333333333334px" width="478.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">If no funds are budgeted for Social Security, Medicare, Workers Compensation or Unemployment please see Part 3 number 2.</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="58.18181818181819px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="309.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Please indicate the law enforcement agency's cost for each of the following categories.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL30-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="163.63636363636365px" hyphenate="true" language="en" keep-together="always" top="192.72727272727275px" height="13.333333333333334px" width="36.96969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_CostColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="492.1212121212121px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named Part_TimeOfficerSectionTitle-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="212.72727272727275px" hyphenate="true" language="en" keep-together="always" top="122.42424242424244px" height="15.757575757575758px" width="184.84848484848487px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part 2: Part-Time Officer Information</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_BaseColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="264.24242424242425px" hyphenate="true" language="en" keep-together="always" top="492.1212121212121px" height="13.333333333333334px" width="42.42424242424243px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="265.4545454545455px" hyphenate="true" language="en" keep-together="always" top="193.93939393939394px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base</fo:block>
               </fo:block-container><!--Block below is for the label named description_full_time_fringe_other1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="315.75757575757575px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="45.45454545454546px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named description_full_time_fringe_other2_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="315.75757575757575px" hyphenate="true" language="en" keep-together="always" top="381.8181818181818px" height="13.333333333333334px" width="44.24242424242424px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL28-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="315.75757575757575px" hyphenate="true" language="en" keep-together="always" top="680.6060606060606px" height="13.333333333333334px" width="44.24242424242424px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL27-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.3636363636364px" hyphenate="true" language="en" keep-together="always" top="654.5454545454546px" height="13.333333333333334px" width="43.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="209.0909090909091px" height="13.333333333333334px" width="76.36363636363637px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named FLABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_vacation_hours_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="274.54545454545456px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_sick_leave_hours_per_yr_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_SocialSecurityPctBaseExceedLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="507.2727272727273px" height="13.333333333333334px" width="88.48484848484848px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_MedicarePctBaseExceedLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="523.6363636363636px" height="13.333333333333334px" width="80px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL24-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="540px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL25-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="572.7272727272727px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL26-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.969696969697px" hyphenate="true" language="en" keep-together="always" top="589.0909090909091px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL36-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="367px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="197.5757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Please do not include employee contribution costs.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="384.8484848484849px" hyphenate="true" language="en" keep-together="always" top="193.33333333333334px" height="13.333333333333334px" width="100.60606060606061px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_AdditionalInformationColumnLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="388.4848484848485px" hyphenate="true" language="en" keep-together="always" top="491.51515151515156px" height="13.333333333333334px" width="104.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_soc_sec_exempt_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="209.0909090909091px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_medicare_exempt_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="225.45454545454547px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL20-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="507.2727272727273px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL21-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="523.6363636363636px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_family_coverage_yes_1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.8787878787879px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL22-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="427.8787878787879px" hyphenate="true" language="en" keep-together="always" top="540px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="450.90909090909093px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_family_coverage_no_1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="486.06060606060606px" hyphenate="true" language="en" keep-together="always" top="241.81818181818184px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL23-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="486.06060606060606px" hyphenate="true" language="en" keep-together="always" top="540px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
 
         <!-- page 5 -->
                  
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named part_time_base_salary_amount_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="188.4848484848485px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_base_salary_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_social_security_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="229.0909090909091px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_social_security_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_medicare_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="245.45454545454547px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_health_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_health_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_life_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="278.1818181818182px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_life_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_vacation_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="294.54545454545456px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_sick_leave_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="310.90909090909093px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_retirement_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="327.2727272727273px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_retirement_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_workers_comp_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="343.6363636363637px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_unemployment_ins_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="360px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_unemployment_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_other1_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="376.3636363636364px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other1_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_benefit_amount_other2_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="402.42424242424244px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other2_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_total_fringe_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="103.63636363636364px" hyphenate="true" language="en" keep-together="always" top="418.7878787878788px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_total_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_total_base_salary_and_fringe_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="143.03030303030303px" hyphenate="true" language="en" keep-together="always" top="438.7878787878788px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_total_base_salary_and_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_medicare_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="245.45454545454547px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_health_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_life_insurance_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="278.1818181818182px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_vacation_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="294.54545454545456px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_sick_leave_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="310.90909090909093px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_retirement_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="327.2727272727273px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_retirement_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_workers_comp_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="343.03030303030306px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_unemployment_ins_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="360px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_other1_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="376.3636363636364px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other1_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_other2_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.6969696969697px" hyphenate="true" language="en" keep-together="always" top="401.8181818181818px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other2_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_fringe_pct_base_salary_social_security_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="270.3030303030303px" hyphenate="true" language="en" keep-together="always" top="229.0909090909091px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_social_security_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_part_time_fringe_other1_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="376.3636363636364px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_description_fringe_other1) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_part_time_fringe_other2_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="402.42424242424244px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_description_fringe_other2) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named part_time_family_coverage_yes_3_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_vacation_hours_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="423.6363636363637px" hyphenate="true" language="en" keep-together="always" top="294.54545454545456px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_hours) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named part_time_sick_leave_hours_per_yr_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="423.6363636363637px" hyphenate="true" language="en" keep-together="always" top="310.90909090909093px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named part_time_family_coverage_no_3_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="480.6060606060606px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named part_time_soc_sec_exempt_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="229.0909090909091px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="226.06060606060606px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_soc_sec_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named part_time_medicare_exempt_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="245.45454545454547px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="509.69696969696975px" hyphenate="true" language="en" keep-together="always" top="242.42424242424244px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:part_time_bsalary_fbenefits[3]/COPS_Budget:part_time_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                 <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.484848484848484px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="12.121212121212121px" width="66.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerYear3Title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="167.27272727272728px" height="13.333333333333334px" width="343.03030303030306px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 3: Current Annual Entry-Level 3rd Year Base Salary and Annual Fringe Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="438.7878787878788px" height="13.333333333333334px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Year 3 Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="188.4848484848485px" height="13.333333333333334px" width="64.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="229.0909090909091px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="245.45454545454547px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="278.1818181818182px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="294.54545454545456px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="310.90909090909093px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="327.2727272727273px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="343.6363636363637px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="360px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL20-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="376.3636363636364px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL21-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="402.42424242424244px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_2_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="418.7878787878788px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="21.212121212121215px" hyphenate="true" language="en" keep-together="always" top="212.72727272727275px" height="13.333333333333334px" width="66.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionFootnote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.72727272727273px" hyphenate="true" language="en" keep-together="always" top="750px" height="13.333333333333334px" width="478.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">If no funds are budgeted for Social Security, Medicare, Workers Compensation or Unemployment please see Part 3 number 2.</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeOfficerSectionInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="61.21212121212122px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="307.8787878787879px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Please indicate the law enforcement agency's cost for each of the following categories.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="169.69696969696972px" hyphenate="true" language="en" keep-together="always" top="212.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="194.54545454545456px" hyphenate="true" language="en" keep-together="always" top="122.42424242424244px" height="15.757575757575758px" width="218.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part 2: Part-Time Officer Information (cont'd)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="212.72727272727275px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL30-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="320px" hyphenate="true" language="en" keep-together="always" top="402.42424242424244px" height="13.333333333333334px" width="45.45454545454546px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL29-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="320.6060606060606px" hyphenate="true" language="en" keep-together="always" top="376.3636363636364px" height="13.333333333333334px" width="43.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="229.0909090909091px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="245.45454545454547px" height="13.333333333333334px" width="86.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL26-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL27-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="294.54545454545456px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL28-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="321.21212121212125px" hyphenate="true" language="en" keep-together="always" top="310.90909090909093px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL36-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="370px" hyphenate="true" language="en" keep-together="always" top="102.42424242424244px" height="13.333333333333334px" width="197.5757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Please do not include employee contribution costs.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="392.72727272727275px" hyphenate="true" language="en" keep-together="always" top="212.12121212121212px" height="13.333333333333334px" width="99.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL22-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="229.0909090909091px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL23-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="422.42424242424244px" hyphenate="true" language="en" keep-together="always" top="245.45454545454547px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL24-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="432.1212121212121px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="450.90909090909093px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL25-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="490.3030303030303px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
          
         <!-- page 6 -->
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the check named sal_incr_cola-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="183.03030303030303px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="180px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_cola) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_cola = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_cola"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named sal_incr_other-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="199.3939393939394px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="196.36363636363637px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_other) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_other = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_other"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named reason_not_budgeted_social_security-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="346.6666666666667px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_social_security) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_social_security = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_social_security"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named reason_not_budgeted_medicare-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="445.4545454545455px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_medicare) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_medicare = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_medicare"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named reason_not_budgeted_workers_comp-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="543.030303030303px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_workers_comp) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_workers_comp = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_workers_comp"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named reason_not_budgeted_unemployment_ins-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="641.2121212121212px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_unemployment_ins) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_unemployment_ins = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_reasons/COPS_Budget:reason_unemployment_ins"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sal_incr_other_reason-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="213.33333333333334px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_other_reason) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_other_reason = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_other_reason"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named sal_incr_step_raise-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="181.21212121212122px" hyphenate="true" language="en" keep-together="always" top="183.03030303030303px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="181.21212121212122px" hyphenate="true" language="en" keep-together="always" top="180px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_step_raise) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_step_raise = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_step_raise"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named sal_incr_change_benefits-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="273.33333333333337px" hyphenate="true" language="en" keep-together="always" top="183.03030303030303px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="273.33333333333337px" hyphenate="true" language="en" keep-together="always" top="180px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_change_benefits) or //COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_change_benefits = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:sal_incr/COPS_Budget:sal_incr_change_benefits"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named sal_incr_mandatory_yellow-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="4.242424242424242px" hyphenate="true" language="en" keep-together="always" top="126.06060606060606px" height="21.81818181818182px" width="570.909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal"/>
               </fo:block-container>
<fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.666666666666667px" hyphenate="true" language="en" keep-together="always" top="155.15151515151516px" height="23.03030303030303px" width="561.2121212121212px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* 1. If your agency's second and third-year costs for salaries and/or fringe benefits are greater than the first year, check the reason(s) why in the space below.  You must check at least one.</fo:block>
					</fo:block-container><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="103.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named SwornOfficerPositionBudgetInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="125.45454545454547px" height="23.03030303030303px" width="564.8484848484849px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">After completing Part 1 and/or Part 2 of this form, answer the following questions. If necessary, attach an explanation of how you computed salaries and benefits for this worksheet. Be sure to answer EVERY question. Missing or erroneous information could significantly delay the review of your agency's request.</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named ReasonNotBudgetedQuestionLabel-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="306.6666666666667px" height="13.333333333333334px" width="536.969696969697px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">2. If no funds were budgeted for 1) Social Security, 2) Medicare, 3) Worker's Compensation, and/or 4) Unemployment Insurance, your </fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL3-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.121212121212121px" hyphenate="true" language="en" keep-together="always" top="317.5757575757576px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">agency must provide an explanation</fo:block>
					</fo:block-container><fo:block-container background-color="transparent" border-style="none" position="absolute" left="155.75757575757578px" hyphenate="true" language="en" keep-together="always" top="317.5757575757576px" height="13.333333333333334px" width="38.18181818181819px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">for each</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL5-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="190.3030303030303px" hyphenate="true" language="en" keep-together="always" top="317.5757575757576px" height="13.333333333333334px" width="78.18181818181819px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">omission below:</fo:block>
					</fo:block-container><!--Block below is for the label named reason_not_budgeted_social_security_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="332.72727272727275px" height="13.333333333333334px" width="75px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">1) Social Security :</fo:block>
               </fo:block-container><!--Block below is for the label named reason_not_budgeted_medicare_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="431.51515151515156px" height="13.333333333333334px" width="50px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">2) Medicare :</fo:block>
               </fo:block-container><!--Block below is for the label named reason_not_budgeted_workers_comp_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="529.0909090909091px" height="13.333333333333334px" width="105px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">3) Worker's Compensation :</fo:block>
               </fo:block-container><!--Block below is for the label named reason_not_budgeted_unemployment_ins_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="25.454545454545457px" hyphenate="true" language="en" keep-together="always" top="627.2727272727273px" height="13.333333333333334px" width="110px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">4) Unemployment Insurance :</fo:block>
               </fo:block-container><!--Block below is for the label named sal_incr_cola_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="183.03030303030303px" height="13.333333333333334px" width="125.45454545454547px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Cost of living adjustment (COLA)</fo:block>
               </fo:block-container><!--Block below is for the label named sal_incr_other_reason_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="199.3939393939394px" height="13.333333333333334px" width="113.93939393939395px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other- * please explain briefly:</fo:block>
               </fo:block-container><!--Block below is for the label named SwornOfficerPositionBudgetTitle-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78.18181818181819px" hyphenate="true" language="en" keep-together="always" top="98.7878787878788px" height="15.757575757575758px" width="436.969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part 3: Sworn Officer Position Budget Summary (all applicants must complete this section)</fo:block>
               </fo:block-container><!--Block below is for the label named sal_incr_step_raise_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="193.33333333333334px" hyphenate="true" language="en" keep-together="always" top="183.03030303030303px" height="13.333333333333334px" width="48.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Step Raises</fo:block>
               </fo:block-container><!--Block below is for the label named sal_incr_change_benefits_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="285.4545454545455px" hyphenate="true" language="en" keep-together="always" top="183.03030303030303px" height="13.333333333333334px" width="89.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Change in benefit costs</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="450.90909090909093px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
          
         <!-- page 7 -->
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named grantee_ft_fed_year1_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="293.33333333333337px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year1_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year1_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year1_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_local_year1_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="319.39393939393943px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year1_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year1_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year1_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_total_year1_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="345.4545454545455px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year1_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year1_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year1_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_fed_year1_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="463.03030303030306px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year1_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year1_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year1_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_local_year1_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="489.0909090909091px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year1_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year1_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year1_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_total_year1_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="515.1515151515151px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year1_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year1_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year1_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_fed_year2_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.93939393939397px" hyphenate="true" language="en" keep-together="always" top="293.33333333333337px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year2_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year2_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year2_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_local_year2_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.93939393939397px" hyphenate="true" language="en" keep-together="always" top="319.39393939393943px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year2_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year2_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year2_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_total_year2_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.93939393939397px" hyphenate="true" language="en" keep-together="always" top="345.4545454545455px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year2_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year2_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year2_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_fed_year2_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.93939393939397px" hyphenate="true" language="en" keep-together="always" top="463.03030303030306px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year2_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year2_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year2_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_local_year2_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.93939393939397px" hyphenate="true" language="en" keep-together="always" top="489.0909090909091px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year2_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year2_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year2_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_total_year2_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="253.93939393939397px" hyphenate="true" language="en" keep-together="always" top="515.1515151515151px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year2_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year2_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year2_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_fed_year3_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="341.21212121212125px" hyphenate="true" language="en" keep-together="always" top="293.33333333333337px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year3_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year3_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_year3_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_local_year3_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="341.21212121212125px" hyphenate="true" language="en" keep-together="always" top="319.39393939393943px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year3_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year3_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_year3_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_total_year3_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="341.21212121212125px" hyphenate="true" language="en" keep-together="always" top="345.4545454545455px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year3_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year3_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_total_year3_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_fed_year3_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="341.21212121212125px" hyphenate="true" language="en" keep-together="always" top="463.03030303030306px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year3_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year3_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_year3_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_local_year3_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="341.21212121212125px" hyphenate="true" language="en" keep-together="always" top="489.0909090909091px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year3_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year3_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_year3_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_total_year3_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="341.21212121212125px" hyphenate="true" language="en" keep-together="always" top="515.1515151515151px" height="13.333333333333334px" width="81.21212121212122px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year3_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year3_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_total_year3_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_fed_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="428.4848484848485px" hyphenate="true" language="en" keep-together="always" top="293.33333333333337px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_fed/COPS_Budget:grantee_ft_fed_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_local_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="428.4848484848485px" hyphenate="true" language="en" keep-together="always" top="319.39393939393943px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_local/COPS_Budget:grantee_ft_local_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_ft_grand_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="428.4848484848485px" hyphenate="true" language="en" keep-together="always" top="345.4545454545455px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_grand_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_grand_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:full_time_three_yr_projection/COPS_Budget:grantee_ft_total/COPS_Budget:grantee_ft_grand_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_fed_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="428.4848484848485px" hyphenate="true" language="en" keep-together="always" top="463.03030303030306px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_fed/COPS_Budget:grantee_pt_fed_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_local_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="428.4848484848485px" hyphenate="true" language="en" keep-together="always" top="489.0909090909091px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_local/COPS_Budget:grantee_pt_local_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named grantee_pt_grand_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="428.4848484848485px" hyphenate="true" language="en" keep-together="always" top="515.1515151515151px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_grand_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_grand_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:part_time_three_yr_projection/COPS_Budget:grantee_pt_total/COPS_Budget:grantee_pt_grand_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="101.81818181818183px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named ThreeYearSalaryBenefitFullTimePositionLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="250.3030303030303px" height="13.333333333333334px" width="142.42424242424244px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Three-year salary and benefit costs</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="260px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">per full-time</fo:block>
               </fo:block-container><!--Block below is for the label named grantee_ft_fed_year1_amt_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="283.6363636363636px" height="13.333333333333334px" width="139.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Federal Share Amount</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="293.33333333333337px" height="13.333333333333334px" width="144.24242424242425px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Percentage must decrease each year)</fo:block>
               </fo:block-container><!--Block below is for the label named grantee_ft_local_year1_amt_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="309.6969696969697px" height="13.333333333333334px" width="139.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Local Share Amount (If applicable)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="319.39393939393943px" height="13.333333333333334px" width="148.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Percentage must increase each year)</fo:block>
               </fo:block-container><!--Block below is for the label named grantee_ft_total_year1_amt_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="335.75757575757575px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Salary &amp; Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="345.4545454545455px" height="13.333333333333334px" width="149.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Federal Share plus Local Share)</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeComputationLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="390.90909090909093px" height="13.333333333333334px" width="100.60606060606061px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part-Time Computation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="420px" height="13.333333333333334px" width="149.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Three-year salary and benefit costs</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="429.69696969696975px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">per part-time</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="453.33333333333337px" height="13.333333333333334px" width="139.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Federal Share Amount</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="462.42424242424244px" height="13.333333333333334px" width="145.45454545454547px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Percentage must decrease each year)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="479.39393939393943px" height="13.333333333333334px" width="139.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Local Share Amount (If applicable)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="489.0909090909091px" height="13.333333333333334px" width="139.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Percentage must increase each year)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="505.4545454545455px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Salary &amp; Benefits</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="515.1515151515151px" height="13.333333333333334px" width="124.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Federal Share plus Local Share)</fo:block>
               </fo:block-container><!--Block below is for the label named ThreeYearProjectionLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="124.24242424242425px" height="13.333333333333334px" width="115.75757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">3. Three-Year Projection</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="138.1818181818182px" height="12.121212121212121px" width="735.7575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Please complete the following three-year projection, showing how the federal share percentage and your local matching share percentage (if applicable) </fo:block>
               </fo:block-container><!--Block below is for the label named ThreeYearProjectionInstruction-->
                <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="160px" height="32.72727272727273px" width="536.969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">long as the local share percentage (if applicable) increases each year as the federal share percentage decreases. The percentage of one officer's salary and benefits paid with federal funds must be less in Year 2 than in Year 1, and less in Year 3 than in Year 2. In contrast, the percentage of total officer's salaries and benefits paid with local funds (if applicable) must be more in Year 2 than in Year 1, and more in Year 3 than in Year 2.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL21-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="187px" height="13.333333333333334px" width="348.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">the Application Guide for additional program-specific information and for sample budget examples.</fo:block>
               </fo:block-container>
<fo:block-container background-color="transparent" border-style="none" position="absolute" left="508px" hyphenate="true" language="en" keep-together="always" top="178px" height="13.333333333333334px" width="60px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">Please refer to</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeComputationLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="223.03030303030303px" height="13.333333333333334px" width="95.75757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Full-Time Computation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.93939393939394px" hyphenate="true" language="en" keep-together="always" top="149.0909090909091px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">will change year by year for </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="61.21212121212122px" hyphenate="true" language="en" keep-together="always" top="260px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">position</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="64.24242424242425px" hyphenate="true" language="en" keep-together="always" top="429.69696969696975px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">position</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="113.33333333333334px" hyphenate="true" language="en" keep-together="always" top="149.0909090909091px" height="13.333333333333334px" width="70.30303030303031px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic"  text-decoration="underline" font-family="Helvetica" font-weight="normal">one officer position</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="181.81818181818184px" hyphenate="true" language="en" keep-together="always" top="149.0909090909091px" height="13.333333333333334px" width="364.8484848484849px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">. These figures are projections only and may be adjusted by the grantee throughout the grant period as </fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeComputationYear1Label-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="186.66666666666669px" hyphenate="true" language="en" keep-together="always" top="260px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 1 ($)</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeComputationYear1Label-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="186.66666666666669px" hyphenate="true" language="en" keep-together="always" top="429.69696969696975px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 1 ($)</fo:block>
               </fo:block-container><!--Block below is for the label named Part3ContinuedLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="225.45454545454547px" hyphenate="true" language="en" keep-together="always" top="104.84848484848486px" height="15.757575757575758px" width="98.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">Part 3 (Continued):</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeComputationYear2Label-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="275.1515151515152px" hyphenate="true" language="en" keep-together="always" top="260px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 2 ($)</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeComputationYear2Label-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="275.1515151515152px" hyphenate="true" language="en" keep-together="always" top="429.69696969696975px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 2 ($)</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeComputationYear3Label-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="362.42424242424244px" hyphenate="true" language="en" keep-together="always" top="260px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 3 ($)</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeComputationYear3Label-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="362.42424242424244px" hyphenate="true" language="en" keep-together="always" top="429.69696969696975px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Year 3 ($)</fo:block>
               </fo:block-container><!--Block below is for the label named FullTimeComputationTotalYearLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="439.39393939393943px" hyphenate="true" language="en" keep-together="always" top="260px" height="13.333333333333334px" width="76.36363636363637px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total - 3 Years ($)</fo:block>
               </fo:block-container><!--Block below is for the label named PartTimeComputationTotalYearLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="439.39393939393943px" hyphenate="true" language="en" keep-together="always" top="429.69696969696975px" height="13.333333333333334px" width="76.36363636363637px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total - 3 Years ($)</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="450.90909090909093px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="455.1515151515152px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named line1aLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="531.5151515151515px" hyphenate="true" language="en" keep-together="always" top="293.33333333333337px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">(line 1 a)</fo:block>
               </fo:block-container><!--Block below is for the label named line1bLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="531.5151515151515px" hyphenate="true" language="en" keep-together="always" top="319.39393939393943px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">(line 1 b)</fo:block>
               </fo:block-container><!--Block below is for the label named line2aLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="531.5151515151515px" hyphenate="true" language="en" keep-together="always" top="463.03030303030306px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">(line 2 a)</fo:block>
               </fo:block-container><!--Block below is for the label named line2bLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="531.5151515151515px" hyphenate="true" language="en" keep-together="always" top="489.0909090909091px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">(line 2 b)</fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
          
         <!-- page 8 -->
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named sworn_officer_ft_local_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78.18181818181819px" hyphenate="true" language="en" keep-together="always" top="337.5757575757576px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_ft_local_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_ft_local_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_ft_local_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_officer_ft_fed_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78.7878787878788px" hyphenate="true" language="en" keep-together="always" top="163.63636363636365px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_ft_fed_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_ft_fed_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_ft_fed_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_officer_pt_fed_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78.7878787878788px" hyphenate="true" language="en" keep-together="always" top="222.42424242424244px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_pt_fed_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_pt_fed_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_pt_fed_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_officer_pt_local_total_amt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="80px" hyphenate="true" language="en" keep-together="always" top="395.75757575757575px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_pt_local_total_amt) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_pt_local_total_amt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_pt_local_total_amt, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named federal_share_grand_total-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="80px" hyphenate="true" language="en" keep-together="always" top="538.1818181818182px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_grand_total) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_grand_total = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_grand_total, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named local_share_grand_total-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="260px" hyphenate="true" language="en" keep-together="always" top="538.1818181818182px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_grand_total) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_grand_total = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_grand_total, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_full_time_officers_requested_local-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="314.54545454545456px" hyphenate="true" language="en" keep-together="always" top="337.5757575757576px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_full_time_officers_requested_local) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_full_time_officers_requested_local = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_full_time_officers_requested_local, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_part_time_officers_requested_local-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="314.54545454545456px" hyphenate="true" language="en" keep-together="always" top="395.75757575757575px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_part_time_officers_requested_local) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_part_time_officers_requested_local = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_part_time_officers_requested_local, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_full_time_officers_requested_fed-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.3636363636364px" hyphenate="true" language="en" keep-together="always" top="163.63636363636365px" height="13.333333333333334px" width="45.45454545454546px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_full_time_officers_requested_fed) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_full_time_officers_requested_fed = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_full_time_officers_requested_fed, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_part_time_officers_requested_fed-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="316.3636363636364px" hyphenate="true" language="en" keep-together="always" top="222.42424242424244px" height="13.333333333333334px" width="47.27272727272727px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_part_time_officers_requested_fed) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_part_time_officers_requested_fed = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_part_time_officers_requested_fed, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named federal_share_full_time-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="163.63636363636365px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_full_time) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_full_time = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_full_time, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named federal_share_part_time-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="222.42424242424244px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_part_time) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_part_time = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_part_time, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named federal_share_total-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="260.6060606060606px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_total) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_total = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:federal_share_total, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named local_share_full_time-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="337.5757575757576px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_full_time) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_full_time = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_full_time, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named local_share_part_time-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="395.75757575757575px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_part_time) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_part_time = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_part_time, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named local_share_total-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_total) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_total = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:local_share_total, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named sworn_officer_grand_total-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="538.1818181818182px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_grand_total) or //COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_grand_total = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:sworn_officer_budget/COPS_Budget:sworn_officer_grand_total, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="108.48484848484848px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named TotalSwornOfficerCostLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="110.30303030303031px" height="13.333333333333334px" width="112.12121212121212px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">4. Total Sworn Officer Cost</fo:block>
               </fo:block-container><!--Block below is for the label named TotalFederalShareAmountComputationLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="139.3939393939394px" height="13.333333333333334px" width="154.54545454545456px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="normal">Total Federal Share Amount Computation</fo:block>
               </fo:block-container><!--Block below is for the label named TotalLocalShareAmountComputationLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="310.3030303030303px" height="13.333333333333334px" width="177.5757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="normal">Total Local Share Amount Computation</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named sworn_officer_ft_fed_total_amt_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="180.60606060606062px" height="13.333333333333334px" width="215px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Total federal share amount per full-time position</fo:block>
               </fo:block-container><!--Block below is for the label named sworn_officer_pt_fed_total_amt_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="239.3939393939394px" height="13.333333333333334px" width="237.5757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Total federal share amount per part-time position</fo:block>
               </fo:block-container><!--Block below is for the label named GrandTotalComputationLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="12.727272727272728px" hyphenate="true" language="en" keep-together="always" top="507.2727272727273px" height="13.333333333333334px" width="100.60606060606061px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="normal">Grand Total Computation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="354.54545454545456px" height="13.333333333333334px" width="224.84848484848487px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Total local share amount per full-time position</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.333333333333334px" hyphenate="true" language="en" keep-together="always" top="413.33333333333337px" height="13.333333333333334px" width="223.63636363636365px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Total local share amount per part-time position</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="26.666666666666668px" hyphenate="true" language="en" keep-together="always" top="558.7878787878789px" height="12.121212121212121px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Box A</fo:block>
               </fo:block-container><!--Block below is for the label named federal_share_grand_total_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="52.121212121212125px" hyphenate="true" language="en" keep-together="always" top="558.7878787878789px" height="13.333333333333334px" width="152.12121212121212px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Total Federal Share Amount Requested)</fo:block>
               </fo:block-container>
<fo:block-container background-color="transparent" border-style="none" position="absolute" left="181px" hyphenate="true" language="en" keep-together="always" top="354.54545454545456px" height="13.333333333333334px" width="36.96969696969697px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">line 1 b</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL23-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="181px" hyphenate="true" language="en" keep-together="always" top="413.33333333333337px" height="13.333333333333334px" width="36.96969696969697px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">line 2 b</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL20-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="186px" hyphenate="true" language="en" keep-together="always" top="180.60606060606062px" height="13.333333333333334px" width="36.96969696969697px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">line 1 a</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL21-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="187px" hyphenate="true" language="en" keep-together="always" top="239.3939393939394px" height="13.333333333333334px" width="36.96969696969697px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">line 2 a</fo:block>
					</fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="208.4848484848485px" hyphenate="true" language="en" keep-together="always" top="535.7575757575758px" height="12.121212121212121px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">+</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="221.21212121212122px" hyphenate="true" language="en" keep-together="always" top="558.7878787878789px" height="12.121212121212121px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Box B</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="235.15151515151516px" hyphenate="true" language="en" keep-together="always" top="161.21212121212122px" height="14.545454545454547px" width="15.757575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="235.15151515151516px" hyphenate="true" language="en" keep-together="always" top="220px" height="14.545454545454547px" width="15.757575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="235.15151515151516px" hyphenate="true" language="en" keep-together="always" top="335.1515151515152px" height="12.121212121212121px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="235.15151515151516px" hyphenate="true" language="en" keep-together="always" top="393.33333333333337px" height="12.121212121212121px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named local_share_grand_total_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="246.66666666666669px" hyphenate="true" language="en" keep-together="always" top="558.7878787878789px" height="13.333333333333334px" width="158.1818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Total Local Share Amount Requested)</fo:block>
               </fo:block-container><!--Block below is for the label named sworn_full_time_officers_requested_fed_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="264.24242424242425px" hyphenate="true" language="en" keep-together="always" top="180.60606060606062px" height="13.333333333333334px" width="148.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of full-time positions requested</fo:block>
               </fo:block-container><!--Block below is for the label named sworn_part_time_officers_requested_fed_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="264.24242424242425px" hyphenate="true" language="en" keep-together="always" top="239.3939393939394px" height="13.333333333333334px" width="147.27272727272728px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of part-time positions requested</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="354.54545454545456px" height="13.333333333333334px" width="153.33333333333334px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of full-time positions requested</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266.06060606060606px" hyphenate="true" language="en" keep-together="always" top="413.33333333333337px" height="13.333333333333334px" width="150.9090909090909px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of part-time positions requested</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="399.39393939393943px" hyphenate="true" language="en" keep-together="always" top="535.7575757575758px" height="12.121212121212121px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">=</fo:block>
               </fo:block-container><!--Block below is for the label named sworn_officer_grand_total_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="415.7575757575758px" hyphenate="true" language="en" keep-together="always" top="558.7878787878789px" height="13.333333333333334px" width="129.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">TOTAL SWORN OFFICER COSTS</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="161.21212121212122px" height="14.545454545454547px" width="15.757575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">=</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="220px" height="14.545454545454547px" width="15.757575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">=</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="335.1515151515152px" height="12.121212121212121px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">=</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="418.1818181818182px" hyphenate="true" language="en" keep-together="always" top="393.33333333333337px" height="12.121212121212121px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">=</fo:block>
               </fo:block-container><!--Block below is for the label named federal_share_total_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="434.54545454545456px" hyphenate="true" language="en" keep-together="always" top="281.21212121212125px" height="13.333333333333334px" width="92.12121212121212px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">TOTAL FEDERAL AMT.</fo:block>
               </fo:block-container><!--Block below is for the label named local_share_total_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="437.5757575757576px" hyphenate="true" language="en" keep-together="always" top="456.3636363636364px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">TOTAL LOCAL AMT.</fo:block>
               </fo:block-container><!--Block below is for the label named TransferBudgetSummaryLabel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="440px" hyphenate="true" language="en" keep-together="always" top="577.5757575757576px" height="23.03030303030303px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Transfer to Budget Summary Line 1</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="456.969696969697px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="461.21212121212125px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="467.2727272727273px" hyphenate="true" language="en" keep-together="always" top="467.2727272727273px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Box B</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="468.4848484848485px" hyphenate="true" language="en" keep-together="always" top="291.51515151515156px" height="13.333333333333334px" width="29.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Box A</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
          
         <!-- page 9 -->
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named position_title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="67.27272727272728px" hyphenate="true" language="en" keep-together="always" top="182.42424242424244px" height="13.333333333333334px" width="357.5757575757576px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:position_title) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:position_title = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:position_title"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_social_security-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="264.8484848484849px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_medicare-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="281.21212121212125px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_health_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_life_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="313.93939393939394px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_vacation-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="330.3030303030303px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_sick_leave-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="346.6666666666667px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_retirement-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="363.03030303030306px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_workers_comp-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="379.39393939393943px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_unemployment_ins-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="395.75757575757575px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_other1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="412.1212121212121px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_other2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_benefit_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_total_fringe-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.21212121212122px" hyphenate="true" language="en" keep-together="always" top="454.54545454545456px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named annual_base_salary-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="125.45454545454547px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:annual_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:annual_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:annual_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt01-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="549.0909090909091px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt01) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt01 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt01"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt02-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="564.2424242424242px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt02) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt02 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt02"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt03-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="579.3939393939394px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt03) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt03 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt03"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt04-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="594.5454545454546px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt04) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt04 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt04"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt05-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="609.6969696969697px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt05) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt05 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt05"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt06-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="624.8484848484849px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt06) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt06 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt06"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt07-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="640px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt07) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt07 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt07"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt08-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="655.1515151515152px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt08) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt08 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt08"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named FilenameAtt09-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="670.3030303030304px" height="13.333333333333334px" width="225px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt09) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt09 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:FilenameAtt09"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>



        
	
	

<!--Block below is for the field named civilian_total_base_salary_and_fringe-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="161.8181818181818px" hyphenate="true" language="en" keep-together="always" top="474.54545454545456px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_base_salary_and_fringe) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named pct_project_base_salary-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="231.51515151515153px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:pct_project_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:pct_project_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:pct_project_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_social_security-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="264.8484848484849px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_medicare-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="281.21212121212125px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_health_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_life_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="313.93939393939394px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_vacation-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="330.3030303030303px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_sick_leave-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="346.6666666666667px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_retirement-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="363.03030303030306px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_workers_comp-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="379.39393939393943px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_unemployment_ins-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="395.75757575757575px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_other1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="412.1212121212121px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_other2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="268.4848484848485px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_pct_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named years_project_base_salary-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="311.51515151515156px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:years_project_base_salary) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:years_project_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:years_project_base_salary, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named total_base_salary_and_fringe_all_positions_civ-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="314.54545454545456px" hyphenate="true" language="en" keep-together="always" top="705px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:total_base_salary_and_fringe_all_positions_civ) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:total_base_salary_and_fringe_all_positions_civ = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:total_base_salary_and_fringe_all_positions_civ, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_civilian_fringe_other1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="361.8181818181818px" hyphenate="true" language="en" keep-together="always" top="412.1212121212121px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other1) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_civilian_fringe_other2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="361.8181818181818px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other2) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named base_salary_amount-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="394.54545454545456px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_base_salary_amount) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named civilian_family_coverage_yes-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="419.39393939393943px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_vacation_hours-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="421.21212121212125px" hyphenate="true" language="en" keep-together="always" top="330.3030303030303px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_hours) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_sick_leave_hours_per_yr-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="421.21212121212125px" hyphenate="true" language="en" keep-together="always" top="346.6666666666667px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_hours_per_yr) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named civilian_family_coverage_no-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="477.5757575757576px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named civilian_soc_sec_exempt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.2727272727273px" hyphenate="true" language="en" keep-together="always" top="264.8484848484849px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.2727272727273px" hyphenate="true" language="en" keep-together="always" top="261.8181818181818px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_soc_sec_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named civilian_medicare_exempt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.2727272727273px" hyphenate="true" language="en" keep-together="always" top="281.21212121212125px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.2727272727273px" hyphenate="true" language="en" keep-together="always" top="278.1818181818182px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_exempt) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named no_civilian_personnel-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="552.7272727272727px" hyphenate="true" language="en" keep-together="always" top="104.24242424242425px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="552.7272727272727px" hyphenate="true" language="en" keep-together="always" top="101.21212121212122px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:no_civilian_personnel) or //COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:no_civilian_personnel = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:civilian_other_personnel/COPS_Budget:no_civilian_personnel"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL33-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="61.21212121212122px" hyphenate="true" language="en" keep-together="always" top="124.24242424242425px" height="13.333333333333334px" width="197.5757575757576px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">Each position must be listed and computed separately.</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL40-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="61.81818181818182px" hyphenate="true" language="en" keep-together="always" top="133.93939393939394px" height="42.42424242424243px" width="503.03030303030306px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Civilian/Other Personnel Attachment form, can enter 9 more unique positions for a total of 10. Complete each position in accordance with the instructions.  Please remember that any files you attach on the page must be a PureEdge document.  If more than 10 positions are requested please complete additional pages using the Civilian/Other Personnel Attachment form on this page and attach them using the Other Attachments form.</fo:block>
					</fo:block-container><fo:block-container background-color="transparent" border-style="none" position="absolute" left="258.1818181818182px" hyphenate="true" language="en" keep-together="always" top="124.24242424242425px" height="13.333333333333334px" width="307.2727272727273px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">On this page you can enter one civilian position and then by extracting the</fo:block>
					</fo:block-container><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="49.6969696969697px" height="13.333333333333334px" width="104.24242424242425px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="101.81818181818183px" height="15.757575757575758px" width="138.1818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">B. Civilian/Other Personnel</fo:block>
               </fo:block-container><!--Block below is for the label named annual_base_salary_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary Computation:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named position_title_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7px" hyphenate="true" language="en" keep-together="always" top="182.42424242424244px" height="12.121212121212121px" width="80px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Position Title:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.484848484848484px" hyphenate="true" language="en" keep-together="always" top="474.54545454545456px" height="13.333333333333334px" width="150.3030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Subtotal Position Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="264.8484848484849px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="281.21212121212125px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="313.93939393939394px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="330.3030303030303px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="346.6666666666667px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="363.03030303030306px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="379.39393939393943px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="395.75757575757575px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL20-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="412.1212121212121px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL21-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_2_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="454.54545454545456px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL39-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="124.24242424242425px" height="12.121212121212121px" width="66.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="18.78787878787879px" hyphenate="true" language="en" keep-together="always" top="248.4848484848485px" height="13.333333333333334px" width="60px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL41-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="33.93939393939394px" hyphenate="true" language="en" keep-together="always" top="529.0909090909091px" height="12.121212121212121px" width="711.5151515151515px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Important:  Please attach your Civilian/Other Personnel position file(s) with the file name of the position title.  Each file name must be unique.</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt01-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="549.0909090909091px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">1) Please attach Attachment 1</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt02-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="564.2424242424242px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">2) Please attach Attachment 2</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt03-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="579.3939393939394px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">3) Please attach Attachment 3</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt04-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="594.5454545454546px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">4) Please attach Attachment 4</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt05-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="609.6969696969697px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">5) Please attach Attachment 5</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt06-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="624.8484848484849px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">6) Please attach Attachment 6</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt07-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="640px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">7) Please attach Attachment 7</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt08-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="655.1515151515152px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">8) Please attach Attachment 8</fo:block>
               </fo:block-container><!--Block below is for the label named LabelAtt09-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="37.57575757575758px" hyphenate="true" language="en" keep-together="always" top="670.3030303030304px" height="13.333333333333334px" width="115.15151515151516px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">9) Please attach Attachment 9</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL40-->
               <!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="95.15151515151516px" hyphenate="true" language="en" keep-together="always" top="223.63636363636365px" height="12.121212121212121px" width="556.3636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">((Annual Base Salary($) X Percent of Time Devoted to the Project(%)) X Number of Years Devoted to the Project)</fo:block>
               </fo:block-container><!--Block below is for the label named total_base_salary_and_fringe_all_positions_civ_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="110.90909090909092px" hyphenate="true" language="en" keep-together="always" top="705px" height="13.333333333333334px" width="156px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* CIVILIAN/OTHER PERSONNEL TOTAL:</fo:block>
               </fo:block-container><!--Block below is for the label named CivilianPersonnelTotalInstruction-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="110.90909090909092px" hyphenate="true" language="en" keep-together="always" top="720px" height="13.333333333333334px" width="146.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Add together all Subtotals per position)</fo:block>
               </fo:block-container><!--Block below is for the label named CivilianOtherPersonnelSectionFootnote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="113.33333333333334px" hyphenate="true" language="en" keep-together="always" top="750px" height="13.333333333333334px" width="391.51515151515156px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Please include a detailed position description for all positions listed in the Budget Narrative</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="116.36363636363637px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="13.333333333333334px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">((</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="167.27272727272728px" hyphenate="true" language="en" keep-together="always" top="248.4848484848485px" height="13.333333333333334px" width="35.151515151515156px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL34-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="216.36363636363637px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="256.969696969697px" hyphenate="true" language="en" keep-together="always" top="238.7878787878788px" height="23.03030303030303px" width="63.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base Salary Subtotal</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL37-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="288px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">)</fo:block>
               </fo:block-container><!--Block below is for the label named CivilianPersonnelTotalInstruction2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="285.4545454545455px" hyphenate="true" language="en" keep-together="always" top="720px" height="23.03030303030303px" width="150.9090909090909px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Civilian/Other Personnel Cost &#xD;
(Transfer to Budget Summary Line 2)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL35-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="295.75757575757575px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL30-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="317.5757575757576px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="44.24242424242424px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL29-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.1818181818182px" hyphenate="true" language="en" keep-together="always" top="412.1212121212121px" height="13.333333333333334px" width="42.42424242424243px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.7878787878788px" hyphenate="true" language="en" keep-together="always" top="264.8484848484849px" height="13.333333333333334px" width="76.36363636363637px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.7878787878788px" hyphenate="true" language="en" keep-together="always" top="281.21212121212125px" height="13.333333333333334px" width="80.60606060606061px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL26-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.7878787878788px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL27-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.7878787878788px" hyphenate="true" language="en" keep-together="always" top="330.3030303030303px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL28-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.7878787878788px" hyphenate="true" language="en" keep-together="always" top="346.6666666666667px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL38-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="365px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">)</fo:block>
               </fo:block-container><!--Block below is for the label named no_civilian_personnel_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="104.24242424242425px" height="13.333333333333334px" width="183.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No Civilian Personnel Positions Requested</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL36-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="378.1818181818182px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">=</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="390.3030303030303px" hyphenate="true" language="en" keep-together="always" top="247.8787878787879px" height="13.333333333333334px" width="103.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL22-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="420px" hyphenate="true" language="en" keep-together="always" top="264.8484848484849px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL23-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="420px" hyphenate="true" language="en" keep-together="always" top="281.21212121212125px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL24-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="429.69696969696975px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="456.969696969697px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="461.21212121212125px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named base_salary_amount_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="483.03030303030306px" hyphenate="true" language="en" keep-together="always" top="207.8787878787879px" height="12.121212121212121px" width="110.30303030303031px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">(Base Salary Subtotal)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL25-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="487.87878787878793px" hyphenate="true" language="en" keep-together="always" top="297.57575757575756px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
         
         
         	<xsl:for-each select="//COPS_Budget:COPS_Budget_Civilian_Attachment">
	
	 <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="65.45454545454545px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                  <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  
                  </fo:block>
               </fo:block-container><!--Block below is for the field named position_title-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="67.27272727272728px" hyphenate="true" language="en" keep-together="always" top="182.42424242424244px" height="13.333333333333334px" width="357.5757575757576px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:position_title) or COPS_Budget:civilian_other_personnel/COPS_Budget:position_title = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="COPS_Budget:civilian_other_personnel/COPS_Budget:position_title"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_social_security-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_medicare-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_health_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_life_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_vacation-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_sick_leave-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_retirement-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="389.0909090909091px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_workers_comp-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="405.4545454545455px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_unemployment_ins-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="421.8181818181818px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_other1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_benefit_amount_other2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="464.24242424242425px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_benefit_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_benefit_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_benefit_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_total_fringe-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="101.81818181818183px" hyphenate="true" language="en" keep-together="always" top="480.6060606060606px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_fringe) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named annual_base_salary-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="126.06060606060606px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:annual_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:annual_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:annual_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_total_base_salary_and_fringe-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="162.42424242424244px" hyphenate="true" language="en" keep-together="always" top="500.6060606060606px" height="13.333333333333334px" width="163.63636363636365px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_base_salary_and_fringe) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_base_salary_and_fringe = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_total_base_salary_and_fringe, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named pct_project_base_salary-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="232.12121212121212px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:pct_project_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:pct_project_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:pct_project_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_social_security-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_social_security_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_medicare-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_health_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_health_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_life_insurance-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_life_ins_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_vacation-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_sick_leave-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_retirement-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="389.0909090909091px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_retirement_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_workers_comp-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="405.4545454545455px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_workers_comp_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_unemployment_ins-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="421.8181818181818px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_unemployment_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_other1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other1_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_fringe_pct_base_salary_other2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="464.24242424242425px" height="13.333333333333334px" width="37.57575757575758px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_pct_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_pct_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_other2_fringe_pct_base_salary, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named years_project_base_salary-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="312.1212121212121px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:years_project_base_salary) or COPS_Budget:civilian_other_personnel/COPS_Budget:years_project_base_salary = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:years_project_base_salary, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_civilian_fringe_other1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="362.42424242424244px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other1) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other1 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other1"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named description_civilian_fringe_other2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="362.42424242424244px" hyphenate="true" language="en" keep-together="always" top="464.24242424242425px" height="23.03030303030303px" width="207.27272727272728px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other2) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other2 = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_description_fringe_other2"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named base_salary_amount-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="395.1515151515152px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_base_salary_amount) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_base_salary_amount = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_base_salary_amount, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named civilian_family_coverage_yes-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="420px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_family_coverage"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_vacation_hours-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="421.8181818181818px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_hours) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_hours = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_vacation_hours, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named civilian_sick_leave_hours_per_yr-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="421.8181818181818px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_hours_per_yr) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_hours_per_yr = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_sick_leave_hours_per_yr, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the radio named civilian_family_coverage_no-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="478.1818181818182px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="radioButton">
                              <xsl:with-param name="value" select="COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_family_coverage"/>
                              <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="65.45454545454545px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                  <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                                    </fo:block>
               </fo:block-container><!--Block below is for the check named civilian_soc_sec_exempt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.87878787878793px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.87878787878793px" hyphenate="true" language="en" keep-together="always" top="287.8787878787879px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_soc_sec_exempt) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_soc_sec_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_soc_sec_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named civilian_medicare_exempt-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.87878787878793px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="507.87878787878793px" hyphenate="true" language="en" keep-together="always" top="304.24242424242425px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_exempt) or COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_exempt = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="COPS_Budget:civilian_other_personnel/COPS_Budget:civilian_medicare_exempt"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL33-->
               <!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="49.6969696969697px" height="13.333333333333334px" width="104.24242424242425px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="101.81818181818183px" height="15.757575757575758px" width="138.78787878787878px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">B. Civilian/Other Personnel</fo:block>
               </fo:block-container><!--Block below is for the label named annual_base_salary_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Base Salary Computation:</fo:block>
               </fo:block-container><!--Block below is for the label named position_title_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7px" hyphenate="true" language="en" keep-together="always" top="182.42424242424244px" height="12.121212121212121px" width="80px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Position Title:</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_base_salary_and_fringe_1_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="9.090909090909092px" hyphenate="true" language="en" keep-together="always" top="500.6060606060606px" height="13.333333333333334px" width="150.3030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Subtotal Position Salary and Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL39-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="124.24242424242425px" height="12.121212121212121px" width="66.66666666666667px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Social Security</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*Medicare</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Health Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="340px" height="13.333333333333334px" width="73.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Life Insurance</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL15-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Vacation</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL16-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Sick Leave</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL17-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="389.0909090909091px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Retirement</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL18-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="405.4545454545455px" height="13.333333333333334px" width="67.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Worker's Comp</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL19-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="421.8181818181818px" height="13.333333333333334px" width="78.7878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Unemployment Ins.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL20-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL21-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="464.24242424242425px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other</fo:block>
               </fo:block-container><!--Block below is for the label named full_time_total_fringe_2_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="11.515151515151516px" hyphenate="true" language="en" keep-together="always" top="480.6060606060606px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Total Fringe Benefits:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="273.93939393939394px" height="13.333333333333334px" width="60px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Fringe Benefit</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL40-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="61.81818181818182px" hyphenate="true" language="en" keep-together="always" top="124.24242424242425px" height="13.333333333333334px" width="199.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="normal">Each position must be listed and computed separately.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="95.75757575757576px" hyphenate="true" language="en" keep-together="always" top="236.96969696969697px" height="12.121212121212121px" width="556.3636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">((Annual Base Salary($) X Percent of Time Devoted to the Project(%)) X Number of Years Devoted to the Project)</fo:block>
               </fo:block-container><!--Block below is for the label named CivilianOtherPersonnelSectionFootnote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="113.33333333333334px" hyphenate="true" language="en" keep-together="always" top="750px" height="13.333333333333334px" width="385.4545454545455px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Please include a detailed position description for all positions listed in the Budget Narrative</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="116.36363636363637px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="9.696969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">((</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="165.45454545454547px" hyphenate="true" language="en" keep-together="always" top="273.93939393939394px" height="13.333333333333334px" width="35.151515151515156px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Cost ($)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL34-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="216.36363636363637px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
              <fo:block-container background-color="transparent" border-style="none" position="absolute" left="256.3636363636364px" hyphenate="true" language="en" keep-together="always" top="264.24242424242425px" height="23.03030303030303px" width="63.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">% of Base Salary Subtotal</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL37-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="285px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL35-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="295.75757575757575px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL30-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.1818181818182px" hyphenate="true" language="en" keep-together="always" top="464.24242424242425px" height="13.333333333333334px" width="44.24242424242424px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL29-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.7878787878788px" hyphenate="true" language="en" keep-together="always" top="438.1818181818182px" height="13.333333333333334px" width="42.42424242424243px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">* Describe:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="319.39393939393943px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 6.2%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="319.39393939393943px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="79.3939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Can't Exceed 1.45%.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL26-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="319.39393939393943px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="12.121212121212121px" width="81.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Family Coverage?</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL27-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="319.39393939393943px" hyphenate="true" language="en" keep-together="always" top="356.3636363636364px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL28-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="319.39393939393943px" hyphenate="true" language="en" keep-together="always" top="372.72727272727275px" height="13.333333333333334px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Number of Hours Annually:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL38-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="365px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL36-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="378.1818181818182px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">=</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="390.90909090909093px" hyphenate="true" language="en" keep-together="always" top="273.93939393939394px" height="13.333333333333334px" width="100.60606060606061px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" text-decoration="underline" font-family="Helvetica" font-weight="bold">Additional Information</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL22-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="420.6060606060606px" hyphenate="true" language="en" keep-together="always" top="290.90909090909093px" height="13.333333333333334px" width="85.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL23-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="420.6060606060606px" hyphenate="true" language="en" keep-together="always" top="307.2727272727273px" height="13.333333333333334px" width="84.84848484848486px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If Exempt Check Here:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL24-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="430.3030303030303px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="27.87878787878788px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Yes</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="456.969696969697px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="461.21212121212125px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named base_salary_amount_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="483.6363636363637px" hyphenate="true" language="en" keep-together="always" top="221.21212121212122px" height="12.121212121212121px" width="110.30303030303031px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">(Base Salary Subtotal)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL25-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="488.4848484848485px" hyphenate="true" language="en" keep-together="always" top="323.6363636363636px" height="13.333333333333334px" width="23.03030303030303px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
         </xsl:for-each>
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named reason_not_budgeted_social_security_civ-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="199.3939393939394px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_social_security) or //COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_social_security = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_social_security"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named reason_not_budgeted_medicare_civ-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="300px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_medicare) or //COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_medicare = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_medicare"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named reason_not_budgeted_workers_comp_civ-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="401.8181818181818px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_workers_comp) or //COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_workers_comp = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_workers_comp"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named reason_not_budgeted_unemployment_ins_civ-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="504.8484848484849px" height="81.21212121212122px" width="503.03030303030306px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_unemployment_ins) or //COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_unemployment_ins = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:not_budgeted_reason/COPS_Budget:reason_unemployment_ins"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="109.0909090909091px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named CivilianOtherPersonnelSectionTitle-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="103.63636363636364px" height="15.757575757575758px" width="178.1818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">B. Civilian/Other Personnel (cont'd)</fo:block>
               </fo:block-container><!--Block below is for the label named ReasonNotBudgetedInstructions-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.303030303030303px" hyphenate="true" language="en" keep-together="always" top="155.75757575757578px" height="13.333333333333334px" width="536.969696969697px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">If no funds were budgeted for 1) Social Security, 2) Medicare, 3) Worker's Compensation, and/or 4) Unemployment Insurance, your </fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL3-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="10.90909090909091px" hyphenate="true" language="en" keep-together="always" top="166.66666666666669px" height="13.333333333333334px" width="149.0909090909091px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">agency must provide an explanation</fo:block>
					</fo:block-container><fo:block-container background-color="transparent" border-style="none" position="absolute" left="154.54545454545456px" hyphenate="true" language="en" keep-together="always" top="166.66666666666669px" height="13.333333333333334px" width="38.18181818181819px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">for each</fo:block>
					</fo:block-container>
					<!--Block below is for the label named LABEL5-->
					<fo:block-container background-color="transparent" border-style="none" position="absolute" left="189.0909090909091px" hyphenate="true" language="en" keep-together="always" top="166.66666666666669px" height="13.333333333333334px" width="78.18181818181819px">
						<fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">omission below:</fo:block>
					</fo:block-container><!--Block below is for the label named reason_not_budgeted_social_security_civ_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="185.45454545454547px" height="13.333333333333334px" width="69.6969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">1) Social Security:</fo:block>
               </fo:block-container><!--Block below is for the label named reason_not_budgeted_medicare_civ_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="286.06060606060606px" height="13.333333333333334px" width="49.09090909090909px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">2) Medicare:</fo:block>
               </fo:block-container><!--Block below is for the label named reason_not_budgeted_workers_comp_civ_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="387.8787878787879px" height="13.333333333333334px" width="101.81818181818183px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">3) Worker's Compensation:</fo:block>
               </fo:block-container><!--Block below is for the label named reason_not_budgeted_unemployment_ins_civ_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20.606060606060606px" hyphenate="true" language="en" keep-together="always" top="490.90909090909093px" height="13.333333333333334px" width="107.87878787878789px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">4) Unemployment Insurance:</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="456.969696969697px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="461.21212121212125px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                 <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>
         
         <!-- page 11 -->

         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named equip_budget_item_description_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="315.1515151515152px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_description_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="350.90909090909093px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_description_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="386.6666666666667px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_description_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="422.42424242424244px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_description_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="458.1818181818182px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_description_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.96969696969697px" hyphenate="true" language="en" keep-together="always" top="493.93939393939394px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_count_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="334.54545454545456px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_count_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="370.3030303030303px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_count_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="406.06060606060606px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_count_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="441.81818181818187px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_count_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="477.5757575757576px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_count_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="513.3333333333334px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_unit_cost_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="334.54545454545456px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_unit_cost_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="370.3030303030303px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_unit_cost_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="406.06060606060606px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_unit_cost_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="441.81818181818187px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_unit_cost_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="477.5757575757576px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_unit_cost_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="513.3333333333334px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_subtotal_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="334.54545454545456px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[1]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_subtotal_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="370.3030303030303px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[2]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_subtotal_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="406.06060606060606px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[3]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_subtotal_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="441.81818181818187px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[4]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_subtotal_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="477.5757575757576px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[5]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_item_subtotal_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="513.3333333333334px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:Equipment_Budget_Item[6]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named equip_budget_category_cost-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="533.3333333333334px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="bold"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:budget_category_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:budget_category_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:budget_category_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the check named no_equipment-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="553.939393939394px" hyphenate="true" language="en" keep-together="always" top="104.24242424242425px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="boolean(0)">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="553.939393939394px" hyphenate="true" language="en" keep-together="always" top="101.21212121212122px" height="12.121212121212121px" width="18.181818181818183px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="2pt" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="addBlankLines">
                        <xsl:with-param name="numLines">1</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:no_equipment) or //COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:no_equipment = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:call-template name="checkbox">
                              <xsl:with-param name="value" select="//COPS_Budget:COPS_Budget/COPS_Budget:Equipment_Section/COPS_Budget:no_equipment"/>
                              <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                           </xsl:call-template>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Write labels--><!--Block below is for the label named --><!--Block below is for the label named LABEL9-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.272727272727273px" hyphenate="true" language="en" keep-together="always" top="50.303030303030305px" height="13.333333333333334px" width="101.21212121212122px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Applicant Legal Name:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantOrganization-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.878787878787879px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333334px" width="488.4848484848485px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantOrganization"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the label named EquipmentSectionTitle-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.484848484848484px" hyphenate="true" language="en" keep-together="always" top="101.21212121212122px" height="15.757575757575758px" width="166.66666666666669px">
                  <fo:block background-color="transparent" color="#000000" font-size="10pt" font-style="normal" font-family="Helvetica" font-weight="bold">C. EQUIPMENT/TECHNOLOGY</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="14.545454545454547px" hyphenate="true" language="en" keep-together="always" top="129.69696969696972px" height="13.333333333333334px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Instructions:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL11-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="14.545454545454547px" hyphenate="true" language="en" keep-together="always" top="140.60606060606062px" height="12.121212121212121px" width="347.8787878787879px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">more than two years. Expendable items should be included either in the </fo:block>
               </fo:block-container><!--Block below is for the label named EquipmentSectionInstruction-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="14.545454545454547px" hyphenate="true" language="en" keep-together="always" top="151.51515151515153px" height="13.333333333333334px" width="536.969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">benefits of purchasing versus leasing equipment, especially for high-price items and those subject to rapid technical advances. Rented or leased </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL8-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="14.545454545454547px" hyphenate="true" language="en" keep-together="always" top="162.42424242424244px" height="12.121212121212121px" width="197.5757575757576px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">equipment costs should be listed in the </fo:block>
               </fo:block-container>
<fo:block-container background-color="transparent" border-style="none" position="absolute" left="14.545454545454547px" hyphenate="true" language="en" keep-together="always" top="173.33333333333334px" height="13.333333333333334px" width="558.1818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">please complete the information in an electronic format and attach the document using the "Other Attachments" form found in the Pure Edge forms package.</fo:block>
               </fo:block-container><!--Block below is for the label named EquipmentSectionInstruction2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="189.69696969696972px" height="23.03030303030303px" width="536.969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Pursuant to the Science, State, Justice, Commerce, and related agencies Appropriations Act, 2006, P.L.109-108, be advised that, to the greatest extent practical, all equipment and products purchased with these funds must be American-made.</fo:block>
               </fo:block-container><!--Block below is for the label named EquipmentSectionInstruction3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="215.75757575757578px" height="32.72727272727273px" width="536.969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">For agencies purchasing items related to enhanced communications systems, the COPS Office expects and encourages that, wherever feasible, such voice or data communications equipment should be incorporated into an intra- or interjurisdictional strategy for communications interoperability among federal, state, and local law enforcement agencies.</fo:block>
               </fo:block-container><!--Block below is for the label named EquipmentSectionInstruction4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="16.363636363636363px" hyphenate="true" language="en" keep-together="always" top="250.3030303030303px" height="13.333333333333334px" width="450.90909090909093px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">See the COPS Application Guide for a list of allowable/unallowable costs for the particular program for which you are applying.</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="64.84848484848486px" hyphenate="true" language="en" keep-together="always" top="129.69696969696972px" height="13.333333333333334px" width="491.51515151515156px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">List non-expendable items that are to be purchased. Non-expendable equipment is tangible property (e.g., technology) having a useful life of </fo:block>
               </fo:block-container><!--Block below is for the label named equip_budget_item_description_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="106.06060606060606px" hyphenate="true" language="en" keep-together="always" top="299.39393939393943px" height="13.333333333333334px" width="92.72727272727273px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Unit/Item Description</fo:block>
               </fo:block-container><!--Block below is for the label named EquipmentFootnote-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="150.3030303030303px" hyphenate="true" language="en" keep-together="always" top="750px" height="13.333333333333334px" width="332.72727272727275px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="italic" font-family="Helvetica" font-weight="bold">Please include a detailed description for all items listed in the Budget Narrative</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL7-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="153.93939393939394px" hyphenate="true" language="en" keep-together="always" top="162.42424242424244px" height="13.333333333333334px" width="123.63636363636364px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">"CONTRACTS/CONSULTANTS"</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL3-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="269.0909090909091px" hyphenate="true" language="en" keep-together="always" top="140.60606060606062px" height="12.121212121212121px" width="52.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">"SUPPLIES"</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL10-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="275.1515151515152px" hyphenate="true" language="en" keep-together="always" top="162.42424242424244px" height="13.333333333333334px" width="296.969696969697px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">category. If additional budget information is required to be entered for this category</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL12-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="297.57575757575756px" hyphenate="true" language="en" keep-together="always" top="300px" height="13.333333333333334px" width="67.27272727272728px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">( # of Items/Units</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL4-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="318.1818181818182px" hyphenate="true" language="en" keep-together="always" top="140.60606060606062px" height="12.121212121212121px" width="13.333333333333334px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">or</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL5-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="327.8787878787879px" hyphenate="true" language="en" keep-together="always" top="140.60606060606062px" height="12.121212121212121px" width="37.57575757575758px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">"OTHER"</fo:block>
               </fo:block-container><!--Block below is for the label named equip_budget_item_count_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="335.1515151515152px" hyphenate="true" language="en" keep-together="always" top="287.2727272727273px" height="13.333333333333334px" width="76.96969696969697px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">* Computation </fo:block>
               </fo:block-container><!--Block below is for the label named LABEL6-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="365.4545454545455px" hyphenate="true" language="en" keep-together="always" top="140.60606060606062px" height="12.121212121212121px" width="231.51515151515153px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">categories. Applicants should analyze the cost </fo:block>
               </fo:block-container><!--Block below is for the label named equip_budget_category_cost_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="367.8787878787879px" hyphenate="true" language="en" keep-together="always" top="533.3333333333334px" height="13.333333333333334px" width="84.24242424242425px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">EQUIPMENT TOTAL:</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL13-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="370.90909090909093px" hyphenate="true" language="en" keep-together="always" top="300px" height="13.333333333333334px" width="8.484848484848484px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">X</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL14-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="387.2727272727273px" hyphenate="true" language="en" keep-together="always" top="300px" height="13.333333333333334px" width="52px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Unit Cost($) )</fo:block>
               </fo:block-container><!--Block below is for the label named no_equipment_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="396.969696969697px" hyphenate="true" language="en" keep-together="always" top="104.24242424242425px" height="13.333333333333334px" width="153.93939393939394px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No Equipment/Technology Requested</fo:block>
               </fo:block-container><!--Block below is for the label named expiration_date-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="456.969696969697px" hyphenate="true" language="en" keep-together="always" top="29.6969696969697px" height="12.121212121212121px" width="129.69696969696972px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Expiration Date: 2/29/2008</fo:block>
               </fo:block-container><!--Block below is for the label named equip_budget_item_subtotal_1_1_LBL-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="458.1818181818182px" hyphenate="true" language="en" keep-together="always" top="300px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Per Item Subtotal ($)</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL32-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="461.21212121212125px" hyphenate="true" language="en" keep-together="always" top="17.575757575757578px" height="12.121212121212121px" width="105.45454545454545px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">OMB Number: 1103-0097</fo:block>
               </fo:block-container><!--Block below is for the label named EquipmentTotalLabel2-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="465.4545454545455px" hyphenate="true" language="en" keep-together="always" top="549.0909090909091px" height="21.81818181818182px" width="71.51515151515152px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="7pt" font-style="normal" font-family="Helvetica" font-weight="bold">Transfer to Budget Summary Line 3</fo:block>
               </fo:block-container><!--Block below is for the label named LABEL31-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="51.515151515151516px" height="13.333333333333334px" width="32.121212121212125px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">ORI #:</fo:block>
               </fo:block-container><!--Block below is for the label named ApplicantORINumber-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="499.39393939393943px" hyphenate="true" language="en" keep-together="always" top="64.84848484848486px" height="13.333333333333334px" width="61.81818181818182px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber) or //COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:ApplicantORINumber"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Draw lines-->
            </fo:flow>
         </fo:page-sequence>

<!-- page 12 -->         
         
         <fo:page-sequence master-reference="default-page" format="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:block>
                  <fo:inline font-size="6px" font-weight="bold">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
                  </fo:inline>
               </fo:block>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body"><!--Data components--><!--Block below is for the field named othercosts_budget_item_description_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="266.6666666666667px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_description_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="302.42424242424244px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_description_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="338.1818181818182px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_description_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="373.93939393939394px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_description_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="409.69696969696975px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_description_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.151515151515152px" hyphenate="true" language="en" keep-together="always" top="445.4545454545455px" height="32.72727272727273px" width="275.1515151515152px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_description) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_description = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_description"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_count_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="286.06060606060606px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_count_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="321.8181818181818px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_count_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="357.5757575757576px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_count_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="393.33333333333337px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_count_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="429.0909090909091px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_count_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="303.03030303030306px" hyphenate="true" language="en" keep-together="always" top="464.8484848484849px" height="13.333333333333334px" width="52.72727272727273px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_count) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_count = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_count, '#,##0')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_unit_cost_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="286.06060606060606px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_unit_cost_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="321.8181818181818px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_unit_cost_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="357.5757575757576px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_unit_cost_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="393.33333333333337px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_unit_cost_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="429.0909090909091px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_unit_cost_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="366.6666666666667px" hyphenate="true" language="en" keep-together="always" top="464.8484848484849px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_unit_cost) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_unit_cost = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_unit_cost, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_subtotal_1_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="286.06060606060606px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[1]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_subtotal_2_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="321.8181818181818px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[2]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_subtotal_3_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="357.5757575757576px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[3]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_subtotal_4_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="393.33333333333337px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[4]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_subtotal_5_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="429.0909090909091px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[5]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_item_subtotal_6_1-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="457.5757575757576px" hyphenate="true" language="en" keep-together="always" top="464.8484848484849px" height="13.333333333333334px" width="86.06060606060606px">
                  <fo:block line-height="normal" background-color="transparent" color="#000000" font-style="normal" font-size="8pt" font-family="Helvetica" font-weight="normal"/>
                  <fo:block background-color="transparent" color="#000000" text-align="end" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal" border-top-style="solid" border-bottom-style="solid" border-start-style="solid" border-end-style="solid">
                     <xsl:choose>
                        <xsl:when test="not(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_subtotal) or //COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_subtotal = ''">
                           <fo:inline color="#FFFFFF">&#160;</fo:inline>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(//COPS_Budget:COPS_Budget/COPS_Budget:Other_Costs_Section/COPS_Budget:Other_Costs_Budget_Item[6]/COPS_Budget:budget_item_subtotal, '#,##0.00')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </fo:block>
               </fo:block-container><!--Block below is for the field named othercosts_budget_category_cost-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="459.39393939393943px" hyphe