<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:grant="http://apply.grants.gov/system/MetaGrantApplication" xmlns:PHS_Additional_IndirectCosts="http://apply.grants.gov/forms/PHS_Additional_IndirectCosts-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:header="http://apply.grants.gov/system/Header-V1.0">
	<xsl:template match="PHS_Additional_IndirectCosts:PHS_Additional_IndirectCosts">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="AB" page-height="8.5in" page-width="11in" margin-left="0.3in" margin-right="0.3in">
					<fo:region-body margin-top="0.3in" margin-bottom=".4in"/>
					<fo:region-before region-name="region-before-first" extent=".4in"/>
					<fo:region-after extent=".3in"/>
				</fo:simple-page-master>
				<fo:simple-page-master master-name="main" page-height="11in" page-width="8.5in" margin-left="0.4in" margin-right="0.4in">
					<fo:region-body margin-top="0.5in" margin-bottom="0.5in"/>
					<fo:region-after extent=".3in"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="primary">
					<fo:single-page-master-reference master-reference="main"/>
				</fo:page-sequence-master>
				<fo:page-sequence-master master-name="summary">
					<fo:single-page-master-reference master-reference="main"/>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			<!--==========================================================================-->
			<xsl:for-each select="PHS_Additional_IndirectCosts:BudgetYear">
				<fo:page-sequence master-reference="AB" format="1">
					<!-- ===================================== -->
					<!-- Header for Page 1                     -->
					<!-- ===================================== -->
					<fo:static-content flow-name="region-before-first">
						<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt" table-layout="fixed">
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell hyphenate="true" language="en" line-height="10pt" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="right" border-style="solid" border-width="0pt" border-color="white">
										<fo:block>
											<fo:inline font-size="6px">OMB Number: 0925-0001</fo:inline>
										</fo:block>
										<fo:block>
											<fo:inline font-size="6px">Expiration Date: 03/31/2020</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:static-content>
					<fo:static-content flow-name="xsl-region-after">
						<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt" table-layout="fixed">
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell hyphenate="true" language="en" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="left" border-style="solid" border-width="0pt" border-color="white">
										<fo:block>
											<xsl:if test="/*/*/footer:Grants_govTrackingNumber != ''">
												<fo:inline font-size="8px">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
												</fo:inline>
											</xsl:if>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell hyphenate="true" language="en" line-height="10pt" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="right" border-style="solid" border-width="0pt" border-color="white">
										<fo:block>
											<xsl:if test="/*/*/header:OpportunityID != ''">
												<fo:inline font-size="8px">Funding Opportunity Number: <xsl:value-of select="/*/*/header:OpportunityID"/>
												</fo:inline>
											</xsl:if>
											<xsl:if test="/*/*/footer:ReceivedDateTime != ''">
												<fo:inline font-size="8px">.       Received Date: <xsl:value-of select="/*/*/footer:ReceivedDateTime"/>
												</fo:inline>
											</xsl:if>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:static-content>
					<fo:flow flow-name="xsl-region-body">
						<xsl:call-template name="SingleYearPart1">
							<xsl:with-param name="year">
								<xsl:value-of select="position()"/>
							</xsl:with-param>
						</xsl:call-template>
					</fo:flow>
				</fo:page-sequence>
			
			</xsl:for-each>
			<!-- ====================================== new section SUMMARY ===============================-->
			<fo:page-sequence master-reference="summary" format="1">
				<fo:static-content flow-name="xsl-region-after">
					<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell hyphenate="true" language="en" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="left" border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<xsl:if test="/*/*/footer:Grants_govTrackingNumber != ''">
											<fo:inline font-size="8px">Tracking Number: <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber"/>
											</fo:inline>
										</xsl:if>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell hyphenate="true" language="en" line-height="10pt" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="right" border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<xsl:if test="/*/*/header:OpportunityID != ''">
											<fo:inline font-size="8px">Funding Opportunity Number: <xsl:value-of select="/*/*/header:OpportunityID"/>
											</fo:inline>
										</xsl:if>
										<xsl:if test="/*/*/footer:ReceivedDateTime != ''">
											<fo:inline font-size="8px">.       Received Date: <xsl:value-of select="/*/*/footer:ReceivedDateTime"/>
											</fo:inline>
										</xsl:if>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<!--<xsl:for-each select="XXX">-->
					<fo:table width="100%" space-before.optimum="3pt" space-after.optimum="2pt">
						<fo:table-column/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="before">
									<fo:block>
										<fo:inline font-weight="bold" font-size="12px">PHS Additional Indirect Costs - Cumulative Budget</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<fo:block>
						<fo:leader leader-pattern="space"/>
					</fo:block>
					<fo:block>
						<fo:leader leader-pattern="space"/>
					</fo:block>
					<fo:block font-size="9px">
						<fo:table width="90%" space-before.optimum="3pt" space-after.optimum="2pt">
							<fo:table-column column-width="proportional-column-width(50)"/>
							<fo:table-column column-width="proportional-column-width(50)"/>
							<fo:table-body>
								<fo:table-row>
									<fo:table-cell number-columns-spanned="2">
										<fo:block/>
									</fo:table-cell>
								</fo:table-row>
								<!--============= ROWS Begin ======================-->
								<xsl:for-each select="PHS_Additional_IndirectCosts:BudgetSummary">
									<fo:table-row>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell text-align="center">
											<fo:block>
												<fo:inline font-family="arialuni" font-size="9px" font-weight="bold">Totals ($)</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2">
											<fo:block>&#160;</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell hyphenate="true" language="en" padding-before="3pt" padding-after="3pt">
											<fo:block font-family="arialuni" font-size="9px" font-weight="bold">Indirect Costs</fo:block>
										</fo:table-cell>
										
										<fo:table-cell text-align="right">
											<fo:block>
												<!-- <xsl:for-each select="RR_MP_Budget:CumulativeTotalFundsRequestedSeniorKeyPerson[. != '0.00']">-->
												<xsl:for-each select="PHS_Additional_IndirectCosts:CumulativeTotalFundsRequestedIndirectCost">
													<fo:inline font-family="arialuni" font-size="9px" font-weight="bold">
														<xsl:value-of select="format-number(., '#,##0.00')"/>
													</fo:inline>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<!--============ ROWS End ================================-->
								</xsl:for-each>
							</fo:table-body>
						</fo:table>
					</fo:block>
					<!--</xsl:for-each>-->
					<!--================== end new section summary ======================= -->
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<!--==============   Single Year Template ======================================-->
	<xsl:template name="SingleYearPart1">
		<xsl:param name="year"/>
		<fo:block>
			<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt">
				<fo:table-column/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell text-align="center" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
							<fo:block>
								<fo:inline font-family="arialuni" font-size="12px" font-weight="bold">PHS Additional Indirect Costs - Budget Period&#160;<xsl:value-of select="$year"/>
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:leader leader-pattern="space"/>
			<fo:block font-family="arialuni" font-size="9px">
				<fo:inline font-weight="bold">ORGANIZATIONAL DUNS*:&#160;&#160;</fo:inline>
				<fo:inline>
					<xsl:value-of select="PHS_Additional_IndirectCosts:DUNSID"/>
				</fo:inline>
			</fo:block>
			<fo:inline font-size="9px" font-weight="bold">Budget Type*:&#160;&#160;&#160;&#160;&#160;&#160;&#160; </fo:inline>
			<xsl:for-each select="PHS_Additional_IndirectCosts:BudgetType">
				<fo:inline padding-before="-1pt" padding-after="-2pt" color="black">
					<fo:inline font-size="9px">
						<xsl:choose>
							<xsl:when test=".='Project'">
								<fo:inline font-family="ZapfDingbats" font-size="9px">&#x25cf;</fo:inline>
							</xsl:when>
							<xsl:otherwise>
								<fo:inline font-family="ZapfDingbats" font-size="9px">&#x274d;</fo:inline>
							</xsl:otherwise>
						</xsl:choose>
					</fo:inline>
				</fo:inline>
			</xsl:for-each>
			<fo:inline font-size="9px"> Project&#160;&#160;&#160;&#160;&#160;&#160; </fo:inline>
			<xsl:for-each select="PHS_Additional_IndirectCosts:BudgetType">
				<fo:inline padding-before="-1pt" padding-after="-2pt" color="black">
					<fo:inline font-size="9px">
						<xsl:choose>
							<xsl:when test=".='Subaward/Consortium'">
								<fo:inline font-family="ZapfDingbats" font-size="9px">&#x25cf;</fo:inline>
							</xsl:when>
							<xsl:otherwise>
								<fo:inline font-family="ZapfDingbats" font-size="9px">&#x274d;</fo:inline>
							</xsl:otherwise>
						</xsl:choose>
					</fo:inline>
				</fo:inline>
			</xsl:for-each>
			<fo:inline font-size="9px"> Subaward/Consortium</fo:inline>
			<fo:block>
			</fo:block>
			<fo:inline font-size="9px" hyphenate="true" language="en" font-weight="bold">Enter name of Organization: </fo:inline>
			<fo:inline font-size="9px">
				<xsl:value-of select="../PHS_Additional_IndirectCosts:OrganizationName"/>
			</fo:inline>
			<fo:block>
			</fo:block>
			<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt">
				<fo:table-column/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell text-align="center" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
							<fo:block>
								<fo:inline font-size="9px" font-weight="bold">Start Date*:&#160;&#160;</fo:inline>
								<fo:inline font-size="9px">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="PHS_Additional_IndirectCosts:BudgetPeriodStartDate"/>
									</xsl:call-template>
								</fo:inline>
								<fo:inline font-size="9px" font-weight="bold">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;End Date*:&#160;</fo:inline>
								<fo:inline font-size="9px">
									<xsl:call-template name="formatDate">
										<xsl:with-param name="value" select="PHS_Additional_IndirectCosts:BudgetPeriodEndDate"/>
									</xsl:call-template>
								</fo:inline>
								<fo:inline font-size="9px" font-weight="bold">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Budget Period:&#160;<xsl:value-of select="$year"/>
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<xsl:for-each select="PHS_Additional_IndirectCosts:IndirectCosts">
				<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt">
					<fo:table-column/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell border-style="solid" border-color="black" text-align="left" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
								<fo:block>
									<fo:inline font-size="9px" font-weight="bold">Indirect Costs</fo:inline>
									<fo:table width="10.4in" space-before.optimum="0pt" space-after.optimum="0pt">
										<fo:table-column column-width="4in"/>
										<fo:table-column column-width="2in"/>
										<fo:table-column column-width="2in"/>
										<fo:table-column column-width="2.3in"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell text-align="left" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
													<fo:block>
														<fo:inline font-weight="bold" font-size="9px">Indirect Cost Type</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
													<fo:block>
														<fo:inline font-weight="bold" font-size="9px">Indirect Cost Rate (%)</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
													<fo:block>
														<fo:inline font-weight="bold" font-size="9px">Indirect Cost Base ($)</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
													<fo:block>
														<fo:inline font-weight="bold" font-size="9px">Funds Requested ($)</fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<!-- adding next row -->
										</fo:table-body>
									</fo:table>
									<xsl:for-each select="PHS_Additional_IndirectCosts:IndirectCost">
										<fo:table width="10.4in" space-before.optimum="0pt" space-after.optimum="0pt">
											<fo:table-column column-width="4in"/>
											<fo:table-column column-width="2in"/>
											<fo:table-column column-width="2in"/>
											<fo:table-column column-width="2.3in"/>
											<fo:table-body>
												<fo:table-row border-bottom-color="gray" border-bottom-style="dotted" border-bottom-width="1px">
													<fo:table-cell hyphenate="true" language="en" line-height="10pt" text-align="left" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
														<fo:block>
															<xsl:for-each select="PHS_Additional_IndirectCosts:CostType">
																<fo:inline font-size="9px">
																	<xsl:apply-templates/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell hyphenate="true" language="en" line-height="10pt" text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
														<fo:block>
															<xsl:for-each select="PHS_Additional_IndirectCosts:Rate">
																<fo:inline font-size="9px">
																	<xsl:apply-templates/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell hyphenate="true" language="en" line-height="10pt" text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
														<fo:block>
															<xsl:for-each select="PHS_Additional_IndirectCosts:Base">
																<fo:inline font-size="9px">
																	<xsl:value-of select="format-number(., '#,##0.00')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell hyphenate="true" language="en" line-height="10pt" text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
														<fo:block>
															<xsl:for-each select="PHS_Additional_IndirectCosts:FundRequested">
																<fo:inline font-size="9px">
																	<xsl:value-of select="format-number(., '#,##0.00')"/>
																</fo:inline>
															</xsl:for-each>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</xsl:for-each>
									<fo:table width="10.4in" space-before.optimum="0pt" space-after.optimum="0pt">
										<fo:table-column column-width="8in"/>
										<fo:table-column column-width="2.3in"/>
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before">
													<fo:block>
														<fo:inline font-size="9px" font-weight="bold">Total Indirect Costs:</fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell text-align="right" padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="before" border-top-color="black" border-top-style="solid" border-top-width="1px">
													<fo:block>
														<xsl:for-each select="PHS_Additional_IndirectCosts:TotalIndirectCosts">
															<fo:inline font-size="9px" font-weight="bold">
																<xsl:value-of select="format-number(., '#,##0.00')"/>
															</fo:inline>
														</xsl:for-each>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</xsl:for-each>
			<fo:block>
				<fo:leader leader-pattern="space"/>
			</fo:block>
			<!--

          -->
			<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt">
				<fo:table-column/>
				<fo:table-column/>
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="2pt" padding-after="2pt" display-align="before" text-align="start">
							<fo:block>
								<fo:inline font-size="9px" font-weight="bold">Budget Justification</fo:inline>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="2pt" padding-after="2pt" display-align="before" text-align="start">
							<fo:block>
								<fo:inline font-size="9px">File Name: </fo:inline>
								<xsl:for-each select="../PHS_Additional_IndirectCosts:BudgetJustificationAttachment">
									<xsl:for-each select="att:FileName">
										<fo:inline font-size="9px">
											<xsl:apply-templates/>
										</fo:inline>
									</xsl:for-each>
								</xsl:for-each>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<!--===========================End Single Year Template===========-->
	<!--========================== date template =================-->
	<xsl:template name="formatDate">
		<xsl:param name="value"/>
		<xsl:value-of select="format-number(substring($value,6,2), '00')"/>
		<xsl:text>-</xsl:text>
		<xsl:value-of select="format-number(substring($value,9,2), '00')"/>
		<xsl:text>-</xsl:text>
		<xsl:value-of select="format-number(substring($value,1,4), '0000')"/>
	</xsl:template>
</xsl:stylesheet>
