/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.flatten.internal;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import java.io.Closeable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.flatten.internal.FlattenResponse;
import org.kuali.research.pdf.flatten.internal.FlattenService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.env.Env;
import org.kuali.research.pdf.sys.env.EnvService;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.PdfException;
import org.kuali.research.pdf.sys.model.RequestMetaData;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/kuali/research/pdf/flatten/internal/FlattenServiceImpl;", "Lorg/kuali/research/pdf/flatten/internal/FlattenService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "envService", "Lorg/kuali/research/pdf/sys/env/EnvService;", "<init>", "(Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/sys/env/EnvService;)V", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getEnvService", "()Lorg/kuali/research/pdf/sys/env/EnvService;", "flatten", "Lorg/kuali/research/pdf/flatten/internal/FlattenResponse;", "source", "Lorg/kuali/research/pdf/link/Link;", "destination", "flattenResponse", "form", "Lcom/itextpdf/forms/PdfAcroForm;", "getDocumentProperties", "Lcom/itextpdf/kernel/pdf/StampingProperties;", "pdf"})
public class FlattenServiceImpl
implements FlattenService,
Logging {
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final EnvService envService;

    public FlattenServiceImpl(@Autowired @NotNull LinkService linkService, @Autowired @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        this.linkService = linkService;
        this.envService = envService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public EnvService getEnvService() {
        return this.envService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public FlattenResponse flatten(@NotNull Link source, @NotNull Link destination) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        try {
            FlattenResponse flattenResponse;
            closeable = (Closeable)new PdfReader(this.getLinkService().input(source));
            Throwable throwable = null;
            try {
                FlattenResponse flattenResponse2;
                PdfReader reader = (PdfReader)closeable;
                boolean bl = false;
                Closeable closeable2 = (Closeable)new PdfWriter(this.getLinkService().output(destination));
                Throwable throwable2 = null;
                try {
                    FlattenResponse flattenResponse3;
                    PdfWriter writer = (PdfWriter)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = (Closeable)new PdfDocument(reader, writer, this.getDocumentProperties());
                    Throwable throwable3 = null;
                    try {
                        PdfDocument document = (PdfDocument)closeable3;
                        boolean bl3 = false;
                        PdfAcroForm pdfAcroForm = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)pdfAcroForm, (String)"getAcroForm(...)");
                        flattenResponse3 = this.flattenResponse(pdfAcroForm, source, destination);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    flattenResponse2 = flattenResponse3;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                flattenResponse = flattenResponse2;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = flattenResponse;
        }
        catch (PdfException e) {
            this.getLogger().error((CharSequence)"flattening failed", (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            closeable = new FlattenResponse(source, destination, Status.FAIL, CollectionsKt.listOf((Object)Message.Companion.fatal(string, e.getMessageKey(), e.getProps())));
        }
        catch (Exception e) {
            this.getLogger().error((CharSequence)"flattening failed", (Throwable)e);
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            closeable = new FlattenResponse(source, destination, Status.FAIL, CollectionsKt.listOf((Object)Message.Companion.fatal$default((Message.Companion)Message.Companion, (String)string, (String)"unknown.error", null, (int)4, null)));
        }
        return closeable;
    }

    private FlattenResponse flattenResponse(PdfAcroForm form, Link source, Link destination) {
        if (form.hasXfaForm()) {
            v0 = new FlattenResponse(source, destination, Status.FAIL, CollectionsKt.listOf((Object)Message.Companion.fatal$default((Message.Companion)Message.Companion, (String)"This pdf uses xfa forms.  Flattening is currently not supported.", (String)"xfa.flattening.not.supported", null, (int)4, null)));
        } else {
            form.flattenFields();
            v0 = Unit.INSTANCE;
        }
        return new FlattenResponse(source, destination, Status.SUCCESS, null, 8, null);
    }

    @NotNull
    public StampingProperties getDocumentProperties() {
        StampingProperties stampingProperties;
        StampingProperties $this$getDocumentProperties_u24lambda_u243 = stampingProperties = new StampingProperties();
        boolean bl = false;
        Object object = (Env)this.getEnvService().getEnv().get();
        if (object == null || (object = object.getRequestHeaders()) == null) {
            object = MapsKt.emptyMap();
        }
        $this$getDocumentProperties_u24lambda_u243.setEventCountingMetaInfo((IMetaInfo)new RequestMetaData(null, null, (Map)object, 3, null));
        return stampingProperties;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

