/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ClasspathLink;
import org.kuali.research.pdf.link.FileLink;
import org.kuali.research.pdf.link.HttpLink;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkTypeIdResolver;
import org.kuali.research.pdf.sys.model.PdfException;
import org.kuali.research.pdf.sys.model.Props;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kuali/research/pdf/link/LinkTypeIdResolver;", "Lcom/fasterxml/jackson/databind/jsontype/TypeIdResolver;", "<init>", "()V", "baseType", "Lcom/fasterxml/jackson/databind/JavaType;", "init", "", "getMechanism", "Lcom/fasterxml/jackson/annotation/JsonTypeInfo$Id;", "idFromValue", "", "value", "", "idFromBaseType", "", "idFromValueAndType", "suggestedType", "Ljava/lang/Class;", "typeFromId", "context", "Lcom/fasterxml/jackson/databind/DatabindContext;", "url", "getDescForKnownTypeIds", "Companion", "pdf"})
public final class LinkTypeIdResolver
implements TypeIdResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JavaType baseType;
    @NotNull
    private static final Map<String, KClass<? extends Link>> linkMap;

    public void init(@NotNull JavaType baseType) {
        Intrinsics.checkNotNullParameter((Object)baseType, (String)"baseType");
        this.baseType = baseType;
    }

    @NotNull
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    @NotNull
    public String idFromValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.idFromValueAndType(value, value.getClass());
    }

    @NotNull
    public Void idFromBaseType() {
        throw new PdfException("unsupported.link.type", MapsKt.emptyMap(), "Unsupported link type", null, 8, null);
    }

    @NotNull
    public String idFromValueAndType(@NotNull Object value, @NotNull Class<?> suggestedType) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(suggestedType, (String)"suggestedType");
        if (!(value instanceof Link)) {
            String string = value.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            throw new PdfException("unsupported.link.type", MapsKt.mapOf((Pair)Props.LINK_TYPE.pair((Object)string)), "Unsupported link type", null, 8, null);
        }
        return ((Link)value).protocol();
    }

    @NotNull
    public JavaType typeFromId(@NotNull DatabindContext context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String protocol = StringsKt.substringBefore$default((String)url, (String)"://", null, (int)2, null);
        Object v = linkMap.get(protocol);
        if (v == null) {
            boolean bl = false;
            throw new PdfException("unsupported.link.type", MapsKt.mapOf((Pair)Props.PROTOCOL.pair((Object)protocol)), "Unsupported link type " + protocol, null, 8, null);
        }
        JavaType javaType = ExtensionsKt.jacksonObjectMapper().constructType((Type)JvmClassMappingKt.getJavaClass((KClass)((KClass)v)));
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"constructType(...)");
        return javaType;
    }

    @NotNull
    public String getDescForKnownTypeIds() {
        return "supported protocols are: " + linkMap.keySet();
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)"http", (Object)Reflection.getOrCreateKotlinClass(HttpLink.class)), new Pair((Object)"https", (Object)Reflection.getOrCreateKotlinClass(HttpLink.class)), new Pair((Object)"file", (Object)Reflection.getOrCreateKotlinClass(FileLink.class)), new Pair((Object)"action", (Object)Reflection.getOrCreateKotlinClass(ActionLink.class)), new Pair((Object)"classpath", (Object)Reflection.getOrCreateKotlinClass(ClasspathLink.class))};
        linkMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

