/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.mapper.FunctionProviderBase;
import org.kuali.research.pdf.mapper.MapperFunction;
import org.kuali.research.pdf.mapper.MiscFunctions;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kuali/research/pdf/mapper/MiscFunctions;", "Lorg/kuali/research/pdf/mapper/FunctionProviderBase;", "<init>", "()V", "Companion", "pdf"})
public class MiscFunctions
extends FunctionProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MiscFunctions() {
        super("Miscellaneous");
    }

    @JvmStatic
    @MapperFunction(registeredName="trunc", description="ex: #trunc(\"truncate a string\", 10) = \"truncate a\"  Truncate a string to a max length.")
    @Nullable
    public static final String trunc(@Nullable String input, int length) {
        return Companion.trunc(input, length);
    }

    @JvmStatic
    @MapperFunction(registeredName="mapVals", description="ex: #mapVals(#sponsor.name, \"NIH\", \"National Institutes of Health (NIH)\", \"NSF\", \"National Science Foundation (NSF)\", \"Select from drop down options\")  Map a value to a set of possible values allowed in the pdf field.  The last mapping value will be used as a default if supplied and no other value matches.")
    @Nullable
    public static final String mapVals(@Nullable String actualValue, String ... mappings) {
        return Companion.mapVals(actualValue, mappings);
    }

    @JvmStatic
    @MapperFunction(registeredName="mapPatternVals", description="ex: #mapPatternVals(#sponsor.name, \".*NIH.*\", \"National Institutes of Health (NIH)\", \".*NSF.*|.*National Science Foundation.*\", \"National Science Foundation (NSF)\", \"Select from drop down options\")  Map a value to a set of possible values allowed in the pdf field.  The last mapping value will be used as a default if supplied and no other value matches.")
    @Nullable
    public static final String mapPatternVals(@Nullable String actualValue, String ... mappings) {
        return Companion.mapPatternVals(actualValue, mappings);
    }

    @JvmStatic
    @MapperFunction(registeredName="inSet", description="ex: #inSet(#field, \"value1\", \"value2\", ...)  Tell whether this value is in the given set of strings.")
    public static final boolean inSet(@Nullable String needle, String ... haystack) {
        return Companion.inSet(needle, haystack);
    }

    @JvmStatic
    @MapperFunction(registeredName="inPatternSet", description="ex: #inPatternSet(#field, \".*value1\", \"val.?ue2\", ...)  Tell whether this value matches any in the given set of patterns.")
    public static final boolean inPatternSet(@Nullable String needle, String ... haystack) {
        return Companion.inPatternSet(needle, haystack);
    }

    @JvmStatic
    @MapperFunction(registeredName="fullName", description="ex: #fullName(#path.to.person, true) = \"Smith, Bob Ing\"  Takes an object that has the fields firstName, middleName, lastName and outputs a full name. The second argument is whether to list the last name first.")
    @NotNull
    public static final String fullName(@Nullable Map<String, ?> person, boolean lastNameFirst) {
        return Companion.fullName(person, lastNameFirst);
    }
}

