/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper.internal;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.mapper.MapperFunctionDescription;
import org.kuali.research.pdf.mapper.MapperFunctionProvider;
import org.kuali.research.pdf.mapper.internal.MapRequest;
import org.kuali.research.pdf.mapper.internal.MapResponse;
import org.kuali.research.pdf.mapper.internal.MapperService;
import org.kuali.research.pdf.sys.rest.InternalApiController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@InternalApiController
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B+\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0001\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00070\u0016H\u0017J\u001a\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/kuali/research/pdf/mapper/internal/MapperController;", "", "mapperService", "Lorg/kuali/research/pdf/mapper/internal/MapperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "mapperProviders", "", "Lorg/kuali/research/pdf/mapper/MapperFunctionProvider;", "<init>", "(Lorg/kuali/research/pdf/mapper/internal/MapperService;Lorg/kuali/research/pdf/link/LinkService;Ljava/util/List;)V", "getMapperService", "()Lorg/kuali/research/pdf/mapper/internal/MapperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getMapperProviders", "()Ljava/util/List;", "map", "Lorg/kuali/research/pdf/mapper/internal/MapResponse;", "mapRequest", "Lorg/kuali/research/pdf/mapper/internal/MapRequest;", "listMapperFunctions", "", "", "Lorg/kuali/research/pdf/mapper/MapperFunctionDescription;", "fetchLink", "", "link", "Lorg/kuali/research/pdf/link/Link;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "pdf"})
@SourceDebugExtension(value={"SMAP\nMapperController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapperController.kt\norg/kuali/research/pdf/mapper/internal/MapperController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1187#2,2:70\n1261#2,4:72\n*S KotlinDebug\n*F\n+ 1 MapperController.kt\norg/kuali/research/pdf/mapper/internal/MapperController\n*L\n46#1:70,2\n46#1:72,4\n*E\n"})
public class MapperController {
    @NotNull
    private final MapperService mapperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final List<MapperFunctionProvider> mapperProviders;

    public MapperController(@Autowired @NotNull MapperService mapperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull List<? extends MapperFunctionProvider> mapperProviders) {
        Intrinsics.checkNotNullParameter((Object)mapperService, (String)"mapperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter(mapperProviders, (String)"mapperProviders");
        this.mapperService = mapperService;
        this.linkService = linkService;
        this.mapperProviders = mapperProviders;
    }

    @NotNull
    public MapperService getMapperService() {
        return this.mapperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public List<MapperFunctionProvider> getMapperProviders() {
        return this.mapperProviders;
    }

    @PostMapping(value={"/map"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public MapResponse map(@RequestBody @NotNull MapRequest mapRequest) {
        Intrinsics.checkNotNullParameter((Object)mapRequest, (String)"mapRequest");
        return this.getMapperService().map(mapRequest);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/map/listFunctions"}, produces={"application/json"})
    @NotNull
    public Map<String, List<MapperFunctionDescription>> listMapperFunctions() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this.getMapperProviders();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            MapperFunctionProvider it = (MapperFunctionProvider)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.functionCategory(), (Object)it.mapperFunctionDescriptions());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/fetchLink"}, consumes={"application/json"}, produces={"application/json"})
    public void fetchLink(@RequestBody @NotNull Link link, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (link instanceof ActionLink) {
            throw new IllegalArgumentException("Cannot fetch action link outside of job context");
        }
        Closeable closeable = this.getLinkService().input(link);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            response.setContentType("application/pdf");
            response.setHeader("Content-Disposition", "attachment; filename=\"proxied.pdf\"");
            ServletOutputStream servletOutputStream = response.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"getOutputStream(...)");
            ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)((OutputStream)servletOutputStream), (int)0, (int)2, null);
            response.flushBuffer();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

