/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.env.Env;
import org.kuali.research.pdf.sys.env.EnvService;
import org.kuali.research.pdf.sys.extensions.CoreExtensionsKt;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0014J\b\u0010\r\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kuali/research/pdf/sys/mongo/EnvAwareMongoClientDatabaseFactory;", "Lorg/springframework/data/mongodb/core/SimpleMongoClientDatabaseFactory;", "envService", "Lorg/kuali/research/pdf/sys/env/EnvService;", "mongoClient", "Lcom/mongodb/client/MongoClient;", "databaseName", "", "<init>", "(Lorg/kuali/research/pdf/sys/env/EnvService;Lcom/mongodb/client/MongoClient;Ljava/lang/String;)V", "doGetMongoDatabase", "Lcom/mongodb/client/MongoDatabase;", "dbName", "getDefaultDatabaseName", "pdf"})
public final class EnvAwareMongoClientDatabaseFactory
extends SimpleMongoClientDatabaseFactory {
    @NotNull
    private final EnvService envService;

    public EnvAwareMongoClientDatabaseFactory(@NotNull EnvService envService, @NotNull MongoClient mongoClient, @NotNull String databaseName) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        Intrinsics.checkNotNullParameter((Object)mongoClient, (String)"mongoClient");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        super(mongoClient, databaseName);
        this.envService = envService;
    }

    @NotNull
    protected MongoDatabase doGetMongoDatabase(@NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        Object t = this.envService.getEnv().get();
        Intrinsics.checkNotNull(t);
        Env env = (Env)t;
        MongoDatabase mongoDatabase = super.doGetMongoDatabase(CoreExtensionsKt.ensureSuffix((String)dbName, (String)(env.getTenant() + "-" + env.getLane())));
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"doGetMongoDatabase(...)");
        return mongoDatabase;
    }

    @NotNull
    protected String getDefaultDatabaseName() {
        Object t = this.envService.getEnv().get();
        Intrinsics.checkNotNull(t);
        Env env = (Env)t;
        return super.getDefaultDatabaseName() + "-" + env.getTenant() + "-" + env.getLane();
    }
}

