/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.form.acro;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.pdf.PdfDocument;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.form.FieldAction;
import org.kuali.research.pdf.form.MultiValueAction;
import org.kuali.research.pdf.form.ValueAction;
import org.kuali.research.pdf.form.VisibilityAction;
import org.kuali.research.pdf.form.acro.AcroFormPutAction;
import org.kuali.research.pdf.form.acro.AcroFormPutActionServiceImplKt;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.extensions.AcroFormExtensionsKt;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Props;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B/\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J4\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0012J(\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001eH\u0012J\"\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001b0*2\u0006\u0010\u0017\u001a\u00020\u0002H\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lorg/kuali/research/pdf/form/acro/AcroFormPutActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/form/acro/AcroFormPutAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "init", "action", "exec", "finalize", "doActions", "", "Lorg/kuali/research/pdf/sys/model/Message;", "name", "", "actions", "Lorg/kuali/research/pdf/form/FieldAction;", "field", "Lcom/itextpdf/forms/fields/PdfFormField;", "executingAction", "warn", "formActionName", "fieldName", "actionName", "actualFieldType", "fieldActions", "", "pdf"})
@SourceDebugExtension(value={"SMAP\nAcroFormPutActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcroFormPutActionServiceImpl.kt\norg/kuali/research/pdf/form/acro/AcroFormPutActionServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,179:1\n1863#2,2:180\n60#3:182\n51#3:183\n216#4,2:184\n*S KotlinDebug\n*F\n+ 1 AcroFormPutActionServiceImpl.kt\norg/kuali/research/pdf/form/acro/AcroFormPutActionServiceImpl\n*L\n126#1:180,2\n174#1:182\n174#1:183\n81#1:184,2\n*E\n"})
public class AcroFormPutActionServiceImpl
implements ActionService<AcroFormPutAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;

    public AcroFormPutActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull ObjectMapper objectMapper, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
        this.objectMapper = objectMapper;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @NotNull
    public AcroFormPutAction init(@NotNull AcroFormPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (AcroFormPutAction)this.getActionHelperService().initOneToOne((Action)action, arg_0 -> AcroFormPutActionServiceImpl.init$lambda$0(this, arg_0));
    }

    @NotNull
    public AcroFormPutAction exec(@NotNull AcroFormPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (AcroFormPutAction)this.getActionHelperService().execOneToOne((Action)action, (arg_0, arg_1) -> AcroFormPutActionServiceImpl.exec$lambda$2(this, arg_0, arg_1));
    }

    @NotNull
    public AcroFormPutAction finalize(@NotNull AcroFormPutAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (AcroFormPutAction)this.getActionHelperService().finalizeOneToOne((Action)action, arg_0 -> AcroFormPutActionServiceImpl.finalize$lambda$3(this, arg_0));
    }

    private List<Message> doActions(String name, List<? extends FieldAction> actions, PdfFormField field, AcroFormPutAction executingAction) {
        List executedMessages = new ArrayList();
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldAction fa = (FieldAction)element$iv;
            boolean bl = false;
            FieldAction fieldAction = fa;
            if (fieldAction instanceof ValueAction) {
                if (field instanceof PdfChoiceFormField) {
                    ((Collection)executedMessages).add(this.warn(executingAction.getName(), name, ((ValueAction)fa).getName(), "multi-value"));
                    continue;
                }
                AcroFormExtensionsKt.fixFonts((PdfFormField)field);
                field.setValue(((ValueAction)fa).getValue());
                continue;
            }
            if (fieldAction instanceof MultiValueAction) {
                if (field instanceof PdfChoiceFormField) {
                    AcroFormExtensionsKt.populate((PdfChoiceFormField)((PdfChoiceFormField)field), (List)((MultiValueAction)fa).getValue());
                    continue;
                }
                ((Collection)executedMessages).add(this.warn(executingAction.getName(), name, ((MultiValueAction)fa).getName(), "single-value"));
                continue;
            }
            if (!(fieldAction instanceof VisibilityAction)) continue;
            PdfFormAnnotation pdfFormAnnotation = field.getFirstFormAnnotation();
            Intrinsics.checkNotNullExpressionValue((Object)pdfFormAnnotation, (String)"getFirstFormAnnotation(...)");
            AcroFormPutActionServiceImplKt.setVisibility((PdfFormAnnotation)pdfFormAnnotation, (VisibilityAction)((VisibilityAction)fa));
        }
        return executedMessages;
    }

    private Message warn(String formActionName, String fieldName, String actionName, String actualFieldType) {
        Pair[] pairArray = new Pair[]{Props.ACTION_NAME.pair((Object)formActionName), Props.FIELD_ACTION_NAME.pair((Object)actionName), Props.FIELD_NAME.pair((Object)fieldName)};
        return Message.Companion.warn("The " + formActionName + " action with field [" + fieldName + "] is a " + actualFieldType + " field but a " + actionName + " field action is supplied.", "field.actions.wrong.type", MapsKt.mapOf((Pair[])pairArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<FieldAction>> fieldActions(AcroFormPutAction action) {
        Object object;
        block9: {
            block8: {
                Map map;
                object = action.getFieldActionSource();
                if (object == null) break block8;
                Link it = object;
                boolean bl = false;
                LinkService linkService = this.getLinkService();
                Link link = action.getFieldActionSource();
                String string = action.getJobId();
                Intrinsics.checkNotNull((Object)string);
                String string2 = action.getActionId();
                Intrinsics.checkNotNull((Object)string2);
                Link resolvedSource = linkService.newIfNull(link, string, string2, "0");
                Closeable closeable = this.getLinkService().input(resolvedSource);
                Throwable throwable = null;
                try {
                    Map fieldActions;
                    InputStream it2 = (InputStream)closeable;
                    boolean bl2 = false;
                    ObjectMapper $this$readValue$iv = this.getObjectMapper();
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    Map map2 = fieldActions = (Map)$this$readValue$iv.readValue(it2, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    map = map2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = map;
                if (map != null) break block9;
            }
            object = action.getFieldActions();
        }
        return object;
    }

    @NotNull
    public AcroFormPutAction preValidate(@NotNull AcroFormPutAction action) {
        return (AcroFormPutAction)ActionService.DefaultImpls.preValidate((ActionService)this, (Action)((Action)action));
    }

    @NotNull
    public AcroFormPutAction postValidate(@NotNull AcroFormPutAction action) {
        return (AcroFormPutAction)ActionService.DefaultImpls.postValidate((ActionService)this, (Action)((Action)action));
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    private static final AcroFormPutAction init$lambda$0(AcroFormPutActionServiceImpl this$0, AcroFormPutAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link fieldActionSource = executingAction.getFieldActionSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getFieldActionSource(), (Action)executingAction) : executingAction.getFieldActionSource();
        return AcroFormPutAction.copy$default((AcroFormPutAction)executingAction, null, null, null, null, (Link)fieldActionSource, null, null, null, null, (int)495, null);
    }

    private static final AcroFormPutAction exec$lambda$2(AcroFormPutActionServiceImpl this$0, AcroFormPutAction executingAction, PdfDocument document) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        List executedMessages = CollectionsKt.toMutableList((Collection)executingAction.getMessages());
        Map fieldActions = this$0.fieldActions(executingAction);
        PdfAcroForm form = PdfAcroForm.getAcroForm((PdfDocument)document, (boolean)false);
        if (form == null) {
            ((Collection)executedMessages).add(Message.Companion.error$default((Message.Companion)Message.Companion, (String)"The source pdf does not have an acroform.", (String)"source.acroform.not.found", null, (int)4, null));
        } else {
            if (fieldActions.isEmpty()) {
                ((Collection)executedMessages).add(Message.Companion.warn("The " + executingAction.getName() + " action does not have any fields.", "field.actions.missing", MapsKt.mapOf((Pair)Props.ACTION_NAME.pair((Object)executingAction.getName()))));
            }
            Map $this$forEach$iv = fieldActions;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                PdfFormField field;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                String name = (String)entry.getKey();
                List actions = (List)entry.getValue();
                if (actions.isEmpty()) {
                    ((Collection)executedMessages).add(Message.Companion.warn("The " + executingAction.getName() + " action with field [" + name + "] not have any field actions.", "field.actions.action.missing", MapsKt.mapOf((Pair)Props.ACTION_NAME.pair((Object)executingAction.getName()))));
                }
                if ((field = form.getField(name)) != null) {
                    CollectionsKt.addAll((Collection)executedMessages, (Iterable)this$0.doActions(name, actions, field, executingAction));
                    continue;
                }
                Collection collection = executedMessages;
                Message message = new Message[]{Props.ACTION_NAME.pair((Object)executingAction.getName()), Props.FIELD_NAME.pair((Object)name)};
                message = Message.Companion.warn("The " + executingAction.getName() + " action with field [" + name + "] does not exist on the acroform.", "acroform.field.not.found", MapsKt.mapOf((Pair[])message));
                collection.add(message);
            }
        }
        return AcroFormPutAction.copy$default((AcroFormPutAction)executingAction, null, null, null, null, null, null, null, null, (List)executedMessages, (int)255, null);
    }

    private static final AcroFormPutAction finalize$lambda$3(AcroFormPutActionServiceImpl this$0, AcroFormPutAction executingAction) {
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Link fieldActionSource = executingAction.getFieldActionSource() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getFieldActionSource(), (Action)executingAction) : executingAction.getFieldActionSource();
        return AcroFormPutAction.copy$default((AcroFormPutAction)executingAction, null, null, null, null, (Link)fieldActionSource, null, null, null, null, (int)495, null);
    }
}

