/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.graph.Graph;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.job.Job;
import org.kuali.research.pdf.job.JobAware;
import org.kuali.research.pdf.sys.model.CacheKeyAware;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Processable;
import org.kuali.research.pdf.sys.model.Status;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u00012BS\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0012\b\b\u0003\u0010\u000b\u001a\u00020\f\u0012\b\b\u0003\u0010\r\u001a\u00020\u000e\u0012\u000e\b\u0003\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u000b\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\u0013\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003J\t\u0010)\u001a\u00020\u000eH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u00c6\u0003JW\u0010+\u001a\u00020\u00002\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0012\b\u0002\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\b\b\u0003\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\u000e2\u000e\b\u0003\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tH\u00c6\u0001J\u0013\u0010,\u001a\u00020\u00072\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0005H\u00d6\u0001R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 8GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"\u00a8\u00063"}, d2={"Lorg/kuali/research/pdf/job/Job;", "Lorg/kuali/research/pdf/sys/model/Processable;", "Lorg/kuali/research/pdf/job/JobAware;", "Lorg/kuali/research/pdf/sys/model/CacheKeyAware;", "jobId", "", "dryRun", "", "actions", "", "Lorg/kuali/research/pdf/action/Action;", "status", "Lorg/kuali/research/pdf/sys/model/Status;", "updated", "Ljava/time/LocalDateTime;", "messages", "Lorg/kuali/research/pdf/sys/model/Message;", "<init>", "(Ljava/lang/String;ZLjava/util/List;Lorg/kuali/research/pdf/sys/model/Status;Ljava/time/LocalDateTime;Ljava/util/List;)V", "getJobId", "()Ljava/lang/String;", "getDryRun", "()Z", "getActions", "()Ljava/util/List;", "getStatus", "()Lorg/kuali/research/pdf/sys/model/Status;", "getUpdated", "()Ljava/time/LocalDateTime;", "getMessages", "cacheKey", "actionGraph", "Lcom/google/common/graph/Graph;", "getActionGraph", "()Lcom/google/common/graph/Graph;", "actionGraph$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "pdf"})
@SourceDebugExtension(value={"SMAP\nJobModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobModel.kt\norg/kuali/research/pdf/job/Job\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1557#2:74\n1628#2,3:75\n*S KotlinDebug\n*F\n+ 1 JobModel.kt\norg/kuali/research/pdf/job/Job\n*L\n41#1:74\n41#1:75,3\n*E\n"})
public final class Job
implements Processable,
JobAware,
CacheKeyAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @Nullable
    private final String jobId;
    private final boolean dryRun;
    @NotNull
    private final List<Action<?>> actions;
    @NotNull
    private final Status status;
    @NotNull
    private final LocalDateTime updated;
    @NotNull
    private final List<Message> messages;
    @JsonIgnore
    @Transient
    @NotNull
    private final Lazy actionGraph$delegate;

    public Job(@JsonProperty(access=JsonProperty.Access.READ_ONLY) @Nullable String jobId, boolean dryRun, @NotNull List<? extends Action<?>> actions, @JsonProperty(access=JsonProperty.Access.READ_ONLY) @NotNull Status status, @JsonProperty(access=JsonProperty.Access.READ_ONLY) @NotNull LocalDateTime updated, @JsonProperty(access=JsonProperty.Access.READ_ONLY) @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.jobId = jobId;
        this.dryRun = dryRun;
        this.actions = actions;
        this.status = status;
        this.updated = updated;
        this.messages = messages;
        this.actionGraph$delegate = LazyKt.lazy(() -> Job.actionGraph_delegate$lambda$1(this));
    }

    public /* synthetic */ Job(String string, boolean bl, List list, Status status, LocalDateTime localDateTime, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            status = Status.PENDING;
        }
        if ((n & 0x10) != 0) {
            localDateTime = LocalDateTime.now();
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, bl, list, status, localDateTime, list2);
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    public final boolean getDryRun() {
        return this.dryRun;
    }

    @NotNull
    public final List<Action<?>> getActions() {
        return this.actions;
    }

    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @NotNull
    public LocalDateTime getUpdated() {
        return this.updated;
    }

    @NotNull
    public List<Message> getMessages() {
        return this.messages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String cacheKey() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new Object[2];
        objectArray[0] = this.dryRun;
        Iterable iterable2 = this.actions;
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Action action = (Action)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.defaultKey((Object)it));
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        return String.valueOf(Objects.hash(objectArray));
    }

    @JsonIgnore
    @Transient
    @NotNull
    public final Graph<String> getActionGraph() {
        Lazy lazy = this.actionGraph$delegate;
        return (Graph)lazy.getValue();
    }

    @Nullable
    public final String component1() {
        return this.jobId;
    }

    public final boolean component2() {
        return this.dryRun;
    }

    @NotNull
    public final List<Action<?>> component3() {
        return this.actions;
    }

    @NotNull
    public final Status component4() {
        return this.status;
    }

    @NotNull
    public final LocalDateTime component5() {
        return this.updated;
    }

    @NotNull
    public final List<Message> component6() {
        return this.messages;
    }

    @NotNull
    public final Job copy(@JsonProperty(access=JsonProperty.Access.READ_ONLY) @Nullable String jobId, boolean dryRun, @NotNull List<? extends Action<?>> actions, @JsonProperty(access=JsonProperty.Access.READ_ONLY) @NotNull Status status, @JsonProperty(access=JsonProperty.Access.READ_ONLY) @NotNull LocalDateTime updated, @JsonProperty(access=JsonProperty.Access.READ_ONLY) @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return new Job(jobId, dryRun, actions, status, updated, messages);
    }

    public static /* synthetic */ Job copy$default(Job job, String string, boolean bl, List list, Status status, LocalDateTime localDateTime, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = job.jobId;
        }
        if ((n & 2) != 0) {
            bl = job.dryRun;
        }
        if ((n & 4) != 0) {
            list = job.actions;
        }
        if ((n & 8) != 0) {
            status = job.status;
        }
        if ((n & 0x10) != 0) {
            localDateTime = job.updated;
        }
        if ((n & 0x20) != 0) {
            list2 = job.messages;
        }
        return job.copy(string, bl, list, status, localDateTime, list2);
    }

    @NotNull
    public String toString() {
        return "Job(jobId=" + this.jobId + ", dryRun=" + this.dryRun + ", actions=" + this.actions + ", status=" + this.status + ", updated=" + this.updated + ", messages=" + this.messages + ")";
    }

    public int hashCode() {
        int result = this.jobId == null ? 0 : this.jobId.hashCode();
        result = result * 31 + Boolean.hashCode(this.dryRun);
        result = result * 31 + ((Object)this.actions).hashCode();
        result = result * 31 + this.status.hashCode();
        result = result * 31 + this.updated.hashCode();
        result = result * 31 + ((Object)this.messages).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Job)) {
            return false;
        }
        Job job = (Job)other;
        if (!Intrinsics.areEqual((Object)this.jobId, (Object)job.jobId)) {
            return false;
        }
        if (this.dryRun != job.dryRun) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.actions, (Object)job.actions)) {
            return false;
        }
        if (this.status != job.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.updated, (Object)job.updated)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.messages, (Object)job.messages);
    }

    @NotNull
    public String defaultKey(@Nullable Object obj) {
        return CacheKeyAware.DefaultImpls.defaultKey((CacheKeyAware)this, (Object)obj);
    }

    private static final Graph actionGraph_delegate$lambda$1(Job this$0) {
        return Companion.toGraph(this$0.actions);
    }
}

